/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "", "statementContext", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsContext;)V", "addedDeclarations", "", "declarations", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "renamings", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "applyRenameTo", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "target", "newVar", "", "name", "value", "source", "replaceName", "replacement", "js.translator"})
public final class NamingContext {
    private final Map<JsName, JsExpression> renamings;
    private final List<JsVars> declarations;
    private boolean addedDeclarations;
    private final JsContext<JsStatement> statementContext;

    @NotNull
    public final JsNode applyRenameTo(@NotNull JsNode target) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        if (!this.addedDeclarations) {
            this.statementContext.addPrevious(this.declarations);
            this.addedDeclarations = true;
        }
        return RewriteUtilsKt.replaceNames(target, this.renamings);
    }

    public final void replaceName(@NotNull JsName name2, @NotNull JsExpression replacement) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(name2, "name");
        Intrinsics.checkParameterIsNotNull(replacement, "replacement");
        boolean bl2 = bl = !this.renamings.containsKey(name2);
        if (_Assertions.ENABLED && !bl) {
            String string2 = name2 + " has been renamed already";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.renamings.put(name2, replacement);
    }

    public final void newVar(@NotNull JsName name2, @Nullable JsExpression value2, @Nullable Object source) {
        Intrinsics.checkParameterIsNotNull(name2, "name");
        JsVars jsVars = JsAstUtils.newVar(name2, value2);
        Intrinsics.checkExpressionValueIsNotNull(jsVars, "JsAstUtils.newVar(name, value)");
        JsVars vars = jsVars;
        MetadataProperties.setSynthetic(vars, true);
        vars.setSource(source);
        this.declarations.add(vars);
    }

    public static /* synthetic */ void newVar$default(NamingContext namingContext, JsName jsName, JsExpression jsExpression, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            jsExpression = null;
        }
        namingContext.newVar(jsName, jsExpression, object);
    }

    public NamingContext(@NotNull JsContext<JsStatement> statementContext) {
        Intrinsics.checkParameterIsNotNull(statementContext, "statementContext");
        this.statementContext = statementContext;
        NamingContext namingContext = this;
        Object object = new LinkedHashMap();
        namingContext.renamings = object;
        namingContext = this;
        namingContext.declarations = object = (List)new ArrayList();
    }
}

