/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion;", "", "()V", "cache", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/js/naming/SuggestedName;", "generate", "descriptor", "generateDefault", "getSuggestedName", "", "suggest", "Companion", "js.frontend"})
public final class NameSuggestion {
    private final Map<DeclarationDescriptor, SuggestedName> cache;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SuggestedName suggest(@NotNull DeclarationDescriptor descriptor2) {
        SuggestedName suggestedName;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Map<DeclarationDescriptor, SuggestedName> $receiver$iv = this.cache;
        SuggestedName value$iv = $receiver$iv.get(descriptor2);
        if (value$iv == null) {
            DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.original");
            SuggestedName answer$iv = this.generate(declarationDescriptor);
            $receiver$iv.put(descriptor2, answer$iv);
            suggestedName = answer$iv;
        } else {
            void var3_3;
            suggestedName = var3_3;
        }
        return suggestedName;
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestedName generate(DeclarationDescriptor descriptor2) {
        if (AnnotationsUtils.isNativeObject(descriptor2) && DescriptorUtils.isCompanionObject(descriptor2)) {
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.containingDeclaration!!");
            return this.suggest(declarationDescriptor);
        }
        if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isSuspend()) {
            FunctionDescriptor functionDescriptor = ((FunctionDescriptor)descriptor2).getInitialSignatureDescriptor();
            if (functionDescriptor != null) {
                FunctionDescriptor functionDescriptor2;
                FunctionDescriptor it;
                FunctionDescriptor functionDescriptor3 = it = (functionDescriptor2 = functionDescriptor);
                Intrinsics.checkExpressionValueIsNotNull(functionDescriptor3, "it");
                return this.suggest(functionDescriptor3);
            }
        }
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            List<String> list2 = CollectionsKt.listOf(descriptor2.getName().asString());
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.containingDeclaration!!");
            return new SuggestedName(list2, true, descriptor2, declarationDescriptor);
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ModuleDescriptor) {
            return null;
        }
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            SuggestedName suggestedName;
            if (!((PackageFragmentDescriptor)descriptor2).getFqName().isRoot()) {
                Collection<String> collection;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                List<Name> list3 = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
                Intrinsics.checkExpressionValueIsNotNull(list3, "descriptor.fqName.pathSegments()");
                Iterable $i$a$1$let = $receiver$iv = (Iterable)list3;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void p1;
                    Name name2 = (Name)item$iv$iv;
                    collection = destination$iv$iv;
                    String string2 = p1.asString();
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv;
                DeclarationDescriptor declarationDescriptor2 = ((PackageFragmentDescriptor)descriptor2).getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor3 = descriptor2;
                boolean bl = true;
                List list4 = collection;
                suggestedName = new SuggestedName(list4, bl, declarationDescriptor3, declarationDescriptor2);
            } else {
                suggestedName = null;
            }
            return suggestedName;
        }
        if (declarationDescriptor instanceof FakeCallableDescriptorForObject) {
            return this.suggest(((FakeCallableDescriptorForObject)descriptor2).getReferencedObject());
        }
        if (declarationDescriptor instanceof TypeAliasConstructorDescriptor) {
            return this.suggest(((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor());
        }
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            if (((ConstructorDescriptor)descriptor2).isPrimary() || AnnotationsUtils.isNativeObject(descriptor2)) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull(classifierDescriptorWithTypeParameters, "descriptor.containingDeclaration");
                return this.suggest(classifierDescriptorWithTypeParameters);
            }
        } else if (declarationDescriptor instanceof CallableDescriptor && DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            String ownName;
            String string3 = AnnotationsUtils.getNameForAnnotatedObject(descriptor2);
            if (string3 == null) {
                string3 = this.getSuggestedName(descriptor2);
            }
            Intrinsics.checkExpressionValueIsNotNull(string3, "getNameForAnnotatedObjec\u2026SuggestedName(descriptor)");
            String name3 = ownName = string3;
            DeclarationDescriptor declarationDescriptor4 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor4, "descriptor.containingDeclaration");
            DeclarationDescriptor scope = declarationDescriptor4;
            if (descriptor2 instanceof FunctionDescriptor) {
                DeclarationDescriptor declarationDescriptor5 = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor5, "descriptor.containingDeclaration");
                DeclarationDescriptor container2 = declarationDescriptor5;
                String liftedName = ownName;
                boolean hasInline = false;
                while (container2 instanceof FunctionDescriptor) {
                    if (((FunctionDescriptor)container2).isInline() && NameSuggestion.Companion.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)container2).isPublicAPI()) {
                        hasInline = true;
                    }
                    liftedName = this.getSuggestedName(container2) + "$" + liftedName;
                    Intrinsics.checkExpressionValueIsNotNull(((FunctionDescriptor)container2).getContainingDeclaration(), "container.containingDeclaration");
                }
                if (hasInline) {
                    scope = container2;
                    name3 = liftedName;
                }
            }
            return new SuggestedName(CollectionsKt.listOf(name3), false, descriptor2, scope);
        }
        return this.generateDefault(descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestedName generateDefault(DeclarationDescriptor descriptor2) {
        void id;
        String string2;
        List parts = new ArrayList();
        DeclarationDescriptor current = descriptor2;
        if (current instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)current).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            CallableDescriptor callableDescriptor = NameSuggestion.Companion.getOverridden((CallableDescriptor)current);
            if (callableDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
            }
            CallableMemberDescriptor overridden = (CallableMemberDescriptor)callableDescriptor;
            if (!ModalityKt.isOverridableOrOverrides(overridden)) {
                current = overridden;
            }
        }
        DeclarationDescriptor fixedDescriptor = current;
        Collection collection = parts;
        if (fixedDescriptor instanceof ConstructorDescriptor) {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            current = declarationDescriptor;
            string2 = this.getSuggestedName(current) + "_init";
        } else {
            string2 = this.getSuggestedName(fixedDescriptor);
        }
        Object object = string2;
        collection.add(object);
        if (current.getContainingDeclaration() instanceof FunctionDescriptor && !(current instanceof TypeParameterDescriptor)) {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            SuggestedName suggestedName = this.suggest((FunctionDescriptor)declarationDescriptor);
            if (suggestedName == null) {
                Intrinsics.throwNpe();
            }
            SuggestedName outerFunctionName = suggestedName;
            object = parts;
            String string3 = CollectionsKt.single(outerFunctionName.getNames());
            object.add(string3);
            current = outerFunctionName.getScope();
        } else {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            if (declarationDescriptor == null) {
                Intrinsics.throwNpe();
            }
            current = declarationDescriptor;
        }
        if (current instanceof PropertyDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)current).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "current.containingDeclaration");
            current = declarationDescriptor;
        }
        CollectionsKt.reverse(parts);
        String unmangledName = CollectionsKt.joinToString$default(parts, "$", null, null, 0, null, null, 62, null);
        Companion.NameAndStability nameAndStability = NameSuggestion.Companion.mangleNameIfNecessary(unmangledName, fixedDescriptor);
        object = nameAndStability.component1();
        boolean stable = nameAndStability.component2();
        return new SuggestedName(CollectionsKt.listOf(id), stable, fixedDescriptor, current);
    }

    private final String getSuggestedName(DeclarationDescriptor descriptor2) {
        String string2;
        Name name2 = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name2, "descriptor.name");
        Name name3 = name2;
        if (name3.isSpecial()) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PropertyGetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("get_");
                PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
                string2 = stringBuilder.append(this.getSuggestedName(propertyDescriptor)).toString();
            } else if (declarationDescriptor instanceof PropertySetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("set_");
                PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
                string2 = stringBuilder.append(this.getSuggestedName(propertyDescriptor)).toString();
            } else {
                string2 = "f";
            }
        } else {
            String string3 = name3.asString();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "name.asString()");
        }
        return string2;
    }

    public NameSuggestion() {
        Map map2 = Collections.synchronizedMap(new WeakHashMap());
        Intrinsics.checkExpressionValueIsNotNull(map2, "Collections.synchronizedMap(WeakHashMap())");
        this.cache = map2;
    }

    @JvmStatic
    @NotNull
    public static final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
        return Companion.getPrivateMangledName(baseName, descriptor2);
    }

    @JvmStatic
    @NotNull
    public static final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
        return Companion.getStableMangledName(suggestedName, forCalculateId);
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeName(@NotNull String name2) {
        return Companion.sanitizeName(name2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0007R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion;", "", "()V", "ownEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "getOwnEffectiveVisibility", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "getInternalMangledName", "", "suggestedName", "forCalculateId", "getOverridden", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptor", "getPrivateMangledName", "baseName", "getStableMangledName", "mangleNameIfNecessary", "Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "mangleRegularNameIfNecessary", "mangledId", "sanitizeName", "name", "NameAndStability", "js.frontend"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final NameAndStability mangleNameIfNecessary(String baseName, DeclarationDescriptor descriptor2) {
            DeclarationDescriptor overriddenDescriptor2 = descriptor2 instanceof CallableDescriptor ? SequencesKt.last(SequencesKt.generateSequence(descriptor2, (Function1)mangleNameIfNecessary.overriddenDescriptor.1.INSTANCE)) : descriptor2;
            String nativeName = AnnotationsUtils.getNameForAnnotatedObject(overriddenDescriptor2);
            if (nativeName != null) {
                return new NameAndStability(nativeName, true);
            }
            if (overriddenDescriptor2 instanceof FunctionDescriptor) {
                String name2;
                String string2 = DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor2).asString();
                switch (string2.hashCode()) {
                    case 1930023214: {
                        if (!string2.equals("kotlin.Any.equals")) break;
                        return new NameAndStability("equals", true);
                    }
                    case -1544237172: {
                        if (!string2.equals("kotlin.CharSequence.get")) break;
                        return new NameAndStability("charCodeAt", true);
                    }
                }
                DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)overriddenDescriptor2).getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "overriddenDescriptor.containingDeclaration");
                DeclarationDescriptor container2 = declarationDescriptor;
                if (!(container2 instanceof ClassDescriptor)) return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
                SimpleType simpleType2 = ((ClassDescriptor)container2).getDefaultType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "container.defaultType");
                if (!ReflectionTypes.Companion.isNumberedKPropertyOrKMutablePropertyType(simpleType2)) return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
                String string3 = ((FunctionDescriptor)overriddenDescriptor2).getName().asString();
                Intrinsics.checkExpressionValueIsNotNull(string3, "overriddenDescriptor.name.asString()");
                String string4 = name2 = string3;
                switch (string4.hashCode()) {
                    case 113762: {
                        if (!string4.equals("set")) return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
                        return new NameAndStability(name2, true);
                    }
                    case 102230: {
                        if (!string4.equals("get")) return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
                        return new NameAndStability(name2, true);
                    }
                }
                return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
            }
            if (!(overriddenDescriptor2 instanceof PropertyDescriptor)) return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
            String string5 = DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor2).asString();
            switch (string5.hashCode()) {
                case -1572854188: {
                    if (!string5.equals("kotlin.reflect.KCallable.name")) return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
                    return new NameAndStability("callableName", true);
                }
            }
            return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor2);
        }

        private final CallableDescriptor getOverridden(CallableDescriptor descriptor2) {
            return SequencesKt.last(SequencesKt.generateSequence(descriptor2, (Function1)getOverridden.1.INSTANCE));
        }

        private final NameAndStability mangleRegularNameIfNecessary(String baseName, DeclarationDescriptor descriptor2) {
            Object object;
            DeclarationDescriptor containingDeclaration;
            if (descriptor2 instanceof ClassOrPackageFragmentDescriptor) {
                return new NameAndStability(baseName, !DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2));
            }
            Function0<NameAndStability> regularAndUnstable$ = new Function0<NameAndStability>(baseName){
                final /* synthetic */ String $baseName;

                @NotNull
                public final NameAndStability invoke() {
                    return new NameAndStability(this.$baseName, false);
                }
                {
                    this.$baseName = string2;
                    super(0);
                }
            };
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return regularAndUnstable$.invoke();
            }
            Function0<NameAndStability> mangledAndStable$ = new Function0<NameAndStability>(baseName, descriptor2){
                final /* synthetic */ String $baseName;
                final /* synthetic */ DeclarationDescriptor $descriptor;

                @NotNull
                public final NameAndStability invoke() {
                    return new NameAndStability(NameSuggestion.Companion.getStableMangledName(this.$baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)this.$descriptor)), true);
                }
                {
                    this.$baseName = string2;
                    this.$descriptor = declarationDescriptor;
                    super(0);
                }
            };
            Function0<NameAndStability> mangledInternal$ = new Function0<NameAndStability>(baseName, descriptor2){
                final /* synthetic */ String $baseName;
                final /* synthetic */ DeclarationDescriptor $descriptor;

                @NotNull
                public final NameAndStability invoke() {
                    return new NameAndStability(NameSuggestion.Companion.getInternalMangledName(this.$baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)this.$descriptor)), true);
                }
                {
                    this.$baseName = string2;
                    this.$descriptor = declarationDescriptor;
                    super(0);
                }
            };
            Function0<NameAndStability> mangledPrivate$ = new Function0<NameAndStability>(baseName, descriptor2){
                final /* synthetic */ String $baseName;
                final /* synthetic */ DeclarationDescriptor $descriptor;

                @NotNull
                public final NameAndStability invoke() {
                    return new NameAndStability(NameSuggestion.Companion.getPrivateMangledName(this.$baseName, (CallableDescriptor)this.$descriptor), false);
                }
                {
                    this.$baseName = string2;
                    this.$descriptor = declarationDescriptor;
                    super(0);
                }
            };
            Visibility effectiveVisibility = this.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)descriptor2);
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.containingDeclaration");
            DeclarationDescriptor declarationDescriptor2 = containingDeclaration = declarationDescriptor;
            if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
                object = effectiveVisibility.isPublicAPI() ? mangledAndStable$.invoke() : (Intrinsics.areEqual(effectiveVisibility, Visibilities.INTERNAL) ? mangledInternal$.invoke() : regularAndUnstable$.invoke());
            } else if (declarationDescriptor2 instanceof ClassDescriptor) {
                object = descriptor2 instanceof FunctionDescriptor && DescriptorUtilsKt.isEnumValueOfMethod((FunctionDescriptor)descriptor2) ? mangledAndStable$.invoke() : (Intrinsics.areEqual(effectiveVisibility, Visibilities.PUBLIC) ? mangledAndStable$.invoke() : (ModalityKt.isOverridableOrOverrides((CallableMemberDescriptor)descriptor2) ? mangledAndStable$.invoke() : (Intrinsics.areEqual(effectiveVisibility, Visibilities.PROTECTED) && !ModalityKt.isFinalClass((ClassDescriptor)containingDeclaration) && ((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() ? mangledAndStable$.invoke() : (Intrinsics.areEqual(effectiveVisibility, Visibilities.INTERNAL) ? mangledInternal$.invoke() : (((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() && !ModalityKt.isFinalClass((ClassDescriptor)containingDeclaration) ? mangledPrivate$.invoke() : regularAndUnstable$.invoke())))));
            } else {
                boolean bl = containingDeclaration instanceof CallableMemberDescriptor;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "containingDeclaration for descriptor have unsupported type for mangling, descriptor: " + descriptor2 + ", containingDeclaration: " + containingDeclaration;
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                object = regularAndUnstable$.invoke();
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull(baseName, "baseName");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.containingDeclaration");
            String string2 = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "descriptor.containingDec\u2026n.fqNameUnsafe.asString()");
            String ownerName = string2;
            return this.getStableMangledName(this.sanitizeName(baseName), ownerName + "." + baseName + ":" + EncodeSignatureKt.encodeSignature(descriptor2));
        }

        @NotNull
        public final String getInternalMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkParameterIsNotNull(suggestedName, "suggestedName");
            Intrinsics.checkParameterIsNotNull(forCalculateId, "forCalculateId");
            String suffix = '_' + this.mangledId("internal:" + forCalculateId) + '$';
            return suggestedName + suffix;
        }

        @JvmStatic
        @NotNull
        public final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkParameterIsNotNull(suggestedName, "suggestedName");
            Intrinsics.checkParameterIsNotNull(forCalculateId, "forCalculateId");
            CharSequence charSequence = forCalculateId;
            String suffix = charSequence.length() == 0 ? "" : '_' + this.mangledId(forCalculateId) + '$';
            return suggestedName + suffix;
        }

        private final String mangledId(String forCalculateId) {
            String string2;
            int absHashCode = Math.abs(forCalculateId.hashCode());
            if (absHashCode != 0) {
                String string3 = Integer.toString(absHashCode, 36);
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull(string3, "Integer.toString(absHashCode, Character.MAX_RADIX)");
            } else {
                string2 = "";
            }
            return string2;
        }

        private final Visibility getOwnEffectiveVisibility(@NotNull DeclarationDescriptorWithVisibility $receiver) {
            return $receiver.getVisibility().effectiveVisibility($receiver, true).toVisibility();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final String sanitizeName(@NotNull String name2) {
            Collection<Character> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(name2, "name");
            CharSequence charSequence = name2;
            if (charSequence.length() == 0) {
                return "_";
            }
            char c = StringsKt.first(name2);
            char it22 = c;
            char first2 = NameSuggestionKt.isES5IdentifierStart(it22) ? it22 : (char)'_';
            CharSequence charSequence2 = StringsKt.drop(name2, 1);
            StringBuilder stringBuilder = new StringBuilder().append(String.valueOf(first2));
            void it22 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length());
            void var6_10 = $receiver$iv$iv;
            for (int i = 0; i < var6_10.length(); ++i) {
                char it;
                char item$iv$iv;
                char c2 = item$iv$iv = var6_10.charAt(i);
                collection = destination$iv$iv;
                Character c3 = Character.valueOf(NameSuggestionKt.isES5IdentifierPart(it) ? it : (char)'_');
                collection.add(c3);
            }
            collection = (List)destination$iv$iv;
            return stringBuilder.append(CollectionsKt.joinToString$default(collection, "", null, null, 0, null, null, 62, null)).toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "", "name", "", "stable", "", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getStable", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "js.frontend"})
        public static final class NameAndStability {
            @NotNull
            private final String name;
            private final boolean stable;

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final boolean getStable() {
                return this.stable;
            }

            public NameAndStability(@NotNull String name2, boolean stable) {
                Intrinsics.checkParameterIsNotNull(name2, "name");
                this.name = name2;
                this.stable = stable;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            public final boolean component2() {
                return this.stable;
            }

            @NotNull
            public final NameAndStability copy(@NotNull String name2, boolean stable) {
                Intrinsics.checkParameterIsNotNull(name2, "name");
                return new NameAndStability(name2, stable);
            }

            @NotNull
            public static /* synthetic */ NameAndStability copy$default(NameAndStability nameAndStability, String string2, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = nameAndStability.name;
                }
                if ((n & 2) != 0) {
                    bl = nameAndStability.stable;
                }
                return nameAndStability.copy(string2, bl);
            }

            @NotNull
            public String toString() {
                return "NameAndStability(name=" + this.name + ", stable=" + this.stable + ")";
            }

            public int hashCode() {
                String string2 = this.name;
                int n = (string2 != null ? string2.hashCode() : 0) * 31;
                int n2 = this.stable ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return n + n2;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof NameAndStability)) break block3;
                        NameAndStability nameAndStability = (NameAndStability)object;
                        if (!Intrinsics.areEqual(this.name, nameAndStability.name) || !(this.stable == nameAndStability.stable)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

