/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonBoolean;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0082\b\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001bH\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\b\u0010#\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0018H\u0002J\b\u0010)\u001a\u00020\u000fH\u0002J\u0014\u0010*\u001a\u00020\u000f2\n\u0010+\u001a\u00060,j\u0002`-H\u0002J\u0014\u0010.\u001a\u00020\u000f2\n\u0010+\u001a\u00060,j\u0002`-H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonParser;", "", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "charCode", "", "col", "line", "offset", "getReader", "()Ljava/io/Reader;", "wasCR", "", "advance", "", "advanceAndThen", "T", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "error", "", "text", "", "expectCharAndAdvance", "expected", "", "expectString", "parse", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "parseArray", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonArray;", "parseEscapeSequence", "parseHexEscapeSequence", "parseNode", "parseNumber", "", "parseObject", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonObject;", "parseString", "skipSpaces", "takeExponentTo", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "takeIntegerDigitsTo", "js.parser"})
final class JsonParser {
    private int charCode;
    private int offset;
    private int line;
    private int col;
    private boolean wasCR;
    @NotNull
    private final Reader reader;

    @NotNull
    public final JsonNode parse() {
        JsonNode result2 = this.parseNode();
        this.skipSpaces();
        if (this.charCode != -1) {
            Void void_ = this.error("End of input expected");
            throw null;
        }
        return result2;
    }

    private final void skipSpaces() {
        block3: while (true) {
            switch (this.charCode) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.advance();
                    continue block3;
                }
            }
            break;
        }
    }

    private final JsonNode parseNode() {
        JsonNode jsonNode;
        this.skipSpaces();
        int n = this.charCode;
        if (n == 91) {
            jsonNode = this.parseArray();
        } else if (n == 123) {
            jsonNode = this.parseObject();
        } else if (n == 34) {
            jsonNode = new JsonString(this.parseString());
        } else if (n == 110) {
            this.expectString("null");
            jsonNode = JsonNull.INSTANCE;
        } else if (n == 102) {
            this.expectString("false");
            jsonNode = JsonBoolean.Companion.getFALSE();
        } else if (n == 116) {
            this.expectString("true");
            jsonNode = JsonBoolean.Companion.getTRUE();
        } else {
            int n2 = n;
            if (48 <= n2 && 57 >= n2) {
                jsonNode = new JsonNumber(this.parseNumber());
            } else if (n == 45) {
                this.advance();
                jsonNode = new JsonNumber(-this.parseNumber());
            } else {
                Void void_ = this.error("Unexpected char");
                throw null;
            }
        }
        return jsonNode;
    }

    private final JsonArray parseArray() {
        this.advance();
        JsonArray result2 = new JsonArray(new JsonNode[0]);
        while (true) {
            this.skipSpaces();
            if (this.charCode == 93) break;
            Collection collection = result2.getElements();
            if (!collection.isEmpty()) {
                this.expectCharAndAdvance(',');
            }
            collection = result2.getElements();
            JsonNode jsonNode = this.parseNode();
            collection.add(jsonNode);
        }
        this.advance();
        return result2;
    }

    private final JsonObject parseObject() {
        this.advance();
        JsonObject result2 = new JsonObject(new Pair[0]);
        while (true) {
            this.skipSpaces();
            if (this.charCode == 125) break;
            Map<String, JsonNode> map2 = result2.getProperties();
            if (!map2.isEmpty()) {
                this.expectCharAndAdvance(',');
            }
            this.skipSpaces();
            String key = this.parseString();
            Map<String, JsonNode> map3 = result2.getProperties();
            Object object = map3;
            if (object.containsKey(key)) {
                Void void_ = this.error("Duplicate property name: " + key);
                throw null;
            }
            this.skipSpaces();
            this.expectCharAndAdvance(':');
            map3 = result2.getProperties();
            object = this.parseNode();
            map3.put(key, (JsonNode)object);
        }
        this.advance();
        return result2;
    }

    private final String parseString() {
        this.expectCharAndAdvance('\"');
        StringBuilder sb = new StringBuilder();
        block4: while (true) {
            switch (this.charCode) {
                case 34: {
                    this.advance();
                    String string2 = sb.toString();
                    Intrinsics.checkExpressionValueIsNotNull(string2, "sb.toString()");
                    return string2;
                }
                case 92: {
                    sb.append(this.parseEscapeSequence());
                    continue block4;
                }
            }
            if (this.charCode < 32) break;
            sb.append((char)this.charCode);
            this.advance();
        }
        Void void_ = this.error("Invalid character in string literal");
        throw null;
    }

    private final char parseEscapeSequence() {
        int n;
        this.advance();
        switch (this.charCode) {
            case 34: {
                JsonParser this_$iv = this;
                this_$iv.advance();
                n = 34;
                break;
            }
            case 92: {
                JsonParser this_$iv = this;
                this_$iv.advance();
                n = 92;
                break;
            }
            case 47: {
                JsonParser this_$iv = this;
                this_$iv.advance();
                n = 47;
                break;
            }
            case 98: {
                JsonParser this_$iv = this;
                this_$iv.advance();
                n = 8;
                break;
            }
            case 110: {
                JsonParser this_$iv = this;
                this_$iv.advance();
                n = 10;
                break;
            }
            case 114: {
                JsonParser this_$iv = this;
                this_$iv.advance();
                n = 13;
                break;
            }
            case 102: {
                JsonParser this_$iv = this;
                this_$iv.advance();
                n = 12;
                break;
            }
            case 116: {
                JsonParser this_$iv = this;
                this_$iv.advance();
                n = 9;
                break;
            }
            case 117: {
                n = this.parseHexEscapeSequence();
                break;
            }
            default: {
                Void void_ = this.error("Invalid escape sequence");
                throw null;
            }
        }
        return (char)n;
    }

    private final char parseHexEscapeSequence() {
        this.advance();
        int value2 = 0;
        int n = 4;
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            int n3;
            int it = i;
            value2 *= 16;
            int n4 = this.charCode;
            int n5 = n4;
            if (48 <= n5 && 57 >= n5) {
                n3 = this.charCode - 48;
            } else {
                n5 = n4;
                if (97 <= n5 && 102 >= n5) {
                    n3 = this.charCode - 97 + 10;
                } else {
                    n5 = n4;
                    if (65 <= n5 && 70 >= n5) {
                        n3 = this.charCode - 65 + 10;
                    } else {
                        Void void_ = this.error("Invalid escape sequence, hexadecimal char expected");
                        throw null;
                    }
                }
            }
            value2 += n3;
            this.advance();
        }
        return (char)value2;
    }

    private final double parseNumber() {
        double d;
        StringBuilder sb = new StringBuilder();
        this.takeIntegerDigitsTo(sb);
        if (StringsKt.startsWith$default((CharSequence)sb, '0', false, 2, null) && sb.length() > 1) {
            Void void_ = this.error("Number must not start with zero");
            throw null;
        }
        switch (this.charCode) {
            case 46: {
                sb.append('.');
                this.advance();
                this.takeIntegerDigitsTo(sb);
                if (this.charCode == 101 || this.charCode == 69) {
                    this.takeExponentTo(sb);
                }
                String string2 = sb.toString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "sb.toString()");
                String string3 = string2;
                d = Double.parseDouble(string3);
                break;
            }
            case 69: 
            case 101: {
                this.takeExponentTo(sb);
                String string4 = sb.toString();
                Intrinsics.checkExpressionValueIsNotNull(string4, "sb.toString()");
                String string5 = string4;
                d = Double.parseDouble(string5);
                break;
            }
            default: {
                String string6 = sb.toString();
                Intrinsics.checkExpressionValueIsNotNull(string6, "sb.toString()");
                String string7 = string6;
                return Double.parseDouble(string7);
            }
        }
        return d;
    }

    private final void takeIntegerDigitsTo(StringBuilder buffer) {
        int n;
        int size = 0;
        while (48 <= (n = this.charCode) && 57 >= n) {
            buffer.append((char)this.charCode);
            this.advance();
            ++size;
        }
        if (size == 0) {
            Void void_ = this.error("Invalid char, decimal digit expected");
            throw null;
        }
    }

    private final void takeExponentTo(StringBuilder buffer) {
        buffer.append('e');
        this.advance();
        if (this.charCode == 45 || this.charCode == 43) {
            buffer.append((char)this.charCode);
            this.advance();
        }
        this.takeIntegerDigitsTo(buffer);
    }

    private final void expectString(String expected) {
        String string2 = expected;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (this.charCode != c) {
                Void void_ = this.error("Unexpected char, '" + expected + "' expected here");
                throw null;
            }
            this.advance();
        }
    }

    private final void expectCharAndAdvance(char expected) {
        if (this.charCode != expected) {
            Void void_ = this.error("Unexpected char, '" + expected + "' expected here");
            throw null;
        }
        this.advance();
    }

    private final void advance() {
        int n;
        if (this.charCode == -1) {
            return;
        }
        switch (this.charCode) {
            case 13: {
                n = this.line;
                this.line = n + 1;
                this.col = 0;
                this.wasCR = true;
                break;
            }
            case 10: {
                if (this.wasCR) break;
                n = this.line;
                this.line = n + 1;
                this.col = 0;
                this.wasCR = false;
                break;
            }
            default: {
                n = this.col;
                this.col = n + 1;
                this.wasCR = false;
            }
        }
        this.charCode = this.reader.read();
        n = this.offset;
        this.offset = n + 1;
    }

    private final Void error(String text2) {
        throw (Throwable)new JsonSyntaxException(this.offset, this.line, this.col, text2);
    }

    @NotNull
    public final Reader getReader() {
        return this.reader;
    }

    public JsonParser(@NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        this.reader = reader;
        this.charCode = this.reader.read();
    }
}

