/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000e\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkIdentifier", "name", "", "checkSpreadOperator", "reportInOperation", "reportedOn", "", "element", "js.frontend"})
public final class JsDynamicCallChecker
implements CallChecker {
    public static final JsDynamicCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        KtExpression calleePsi;
        IElementType iElementType;
        KtElement element;
        Object callee;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object obj = callee = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, "callee");
        if (!DynamicCallsKt.isDynamic((DeclarationDescriptor)obj)) {
            this.checkSpreadOperator(resolvedCall2, context);
            return;
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "resolvedCall.call.callElement");
        KtElement ktElement2 = element = ktElement;
        if (ktElement2 instanceof KtArrayAccessExpression) {
            if (((KtArrayAccessExpression)element).getIndexExpressions().size() > 1) {
                context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(reportOn, "indexed access with more than one index"));
            }
        } else if (ktElement2 instanceof KtWhenConditionInRange) {
            this.reportInOperation(context, reportOn);
        } else if (ktElement2 instanceof KtBinaryExpression) {
            IElementType iElementType2 = ((KtBinaryExpression)element).getOperationToken();
            Intrinsics.checkExpressionValueIsNotNull(iElementType2, "element.operationToken");
            IElementType token = iElementType2;
            iElementType = token;
            ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.IN_OPERATIONS;
            Intrinsics.checkExpressionValueIsNotNull(immutableSet, "OperatorConventions.IN_OPERATIONS");
            if (CollectionsKt.contains((Iterable)immutableSet, iElementType)) {
                this.reportInOperation(context, reportOn);
            } else if (Intrinsics.areEqual(iElementType, KtTokens.RANGE)) {
                context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(reportOn, "`..` operation"));
            }
        } else if (ktElement2 instanceof KtDestructuringDeclarationEntry) {
            ASTNode aSTNode = ((KtDestructuringDeclarationEntry)element).getNode();
            Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.node");
            ASTNode aSTNode2 = aSTNode.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull(aSTNode2, "element.node.treeParent");
            PsiElement psiElement = aSTNode2.getPsi();
            Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.node.treeParent.psi");
            if (!this.reportedOn(context, psiElement)) {
                context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(((KtDestructuringDeclarationEntry)element).getParent(), "destructuring declaration"));
            }
        } else if (ktElement2 instanceof KtSimpleNameExpression) {
            this.checkIdentifier(((KtSimpleNameExpression)element).getReferencedName(), element, context);
        } else if (ktElement2 instanceof KtCallExpression && (calleePsi = ((KtCallExpression)element).getCalleeExpression()) instanceof KtSimpleNameExpression) {
            this.checkIdentifier(((KtSimpleNameExpression)calleePsi).getReferencedName(), calleePsi, context);
        }
        Call call3 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call3, "resolvedCall.call");
        for (ValueArgument valueArgument : call3.getValueArguments()) {
            if (valueArgument.getSpreadElement() == null) continue;
            IElementType it = iElementType;
            context.getTrace().report(ErrorsJs.SPREAD_OPERATOR_IN_DYNAMIC_CALL.on((PsiElement)((Object)it)));
        }
    }

    private final void checkIdentifier(String name2, PsiElement reportOn, CallCheckerContext context) {
        if (name2 == null) {
            return;
        }
        if (Intrinsics.areEqual(NameSuggestion.Companion.sanitizeName(name2), name2) ^ true) {
            context.getTrace().report(ErrorsJs.NAME_CONTAINS_ILLEGAL_CHARS.on(reportOn));
        }
    }

    private final void checkSpreadOperator(ResolvedCall<?> resolvedCall2, CallCheckerContext context) {
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        for (ValueArgument valueArgument : call2.getValueArguments()) {
            KtExpression argExpression;
            if (valueArgument.getArgumentExpression() == null) {
                continue;
            }
            KotlinType kotlinType = context.getTrace().getBindingContext().getType(argExpression);
            if (kotlinType == null) continue;
            if (!DynamicTypesKt.isDynamic(kotlinType)) continue;
            if (valueArgument.getSpreadElement() == null) continue;
            context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(valueArgument.asElement(), "spread operator"));
        }
    }

    private final void reportInOperation(CallCheckerContext context, PsiElement reportOn) {
        context.getTrace().report(ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC.on(reportOn, "`in` operation"));
    }

    private final boolean reportedOn(CallCheckerContext context, PsiElement element) {
        boolean bl;
        block3: {
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
            Iterable $receiver$iv = bindingContext.getDiagnostics().forElement(element);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    if (!Intrinsics.areEqual(it.getFactory(), ErrorsJs.WRONG_OPERATION_WITH_DYNAMIC)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private JsDynamicCallChecker() {
    }

    static {
        JsDynamicCallChecker jsDynamicCallChecker;
        INSTANCE = jsDynamicCallChecker = new JsDynamicCallChecker();
    }
}

