/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

abstract class JsEqualsHashcodeToStringGenerator
extends DataClassMethodGenerator {
    protected final TranslationContext context;

    protected JsEqualsHashcodeToStringGenerator(KtClassOrObject klass2, TranslationContext context) {
        super(klass2, context.bindingContext());
        this.context = context;
    }

    @Override
    public void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        assert (!classProperties.isEmpty());
        JsFunction functionObj = this.generateJsMethod(function2);
        JsExpression result2 = null;
        for (int i = 0; i < classProperties.size(); ++i) {
            String printName = classProperties.get(i).getName().asString();
            JsName name2 = this.context.getNameForDescriptor(classProperties.get(i));
            JsStringLiteral literal = new JsStringLiteral((i == 0 ? this.getClassDescriptor().getName() + "(" : ", ") + printName + "=");
            JsInvocation expr = new JsInvocation((JsExpression)this.context.namer().kotlin("toString"), new JsNameRef(name2, (JsExpression)new JsThisRef()));
            PsiElement source = KotlinSourceElementKt.getPsi(classProperties.get(i).getSource());
            JsExpression component = JsAstUtils.sum(literal, expr).source(source);
            result2 = result2 == null ? component : JsAstUtils.sum(result2, component);
        }
        assert (result2 != null);
        result2 = JsAstUtils.sum(result2, new JsStringLiteral(")"));
        JsReturn returnStatement = new JsReturn(result2);
        returnStatement.setSource(this.getDeclaration());
        functionObj.getBody().getStatements().add(returnStatement);
    }

    @Override
    public void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        JsFunction functionObj = this.generateJsMethod(function2);
        List<JsStatement> statements = functionObj.getBody().getStatements();
        JsName varName = functionObj.getScope().declareName("result");
        JsVars resultVar = new JsVars(new JsVars.JsVar(varName, new JsIntLiteral(0)));
        resultVar.setSource(this.getDeclaration());
        statements.add(resultVar);
        for (PropertyDescriptor propertyDescriptor : classProperties) {
            JsName name2 = this.context.getNameForDescriptor(propertyDescriptor);
            JsInvocation component = new JsInvocation((JsExpression)this.context.namer().kotlin("hashCode"), new JsNameRef(name2, (JsExpression)new JsThisRef()));
            JsBinaryOperation newHashValue = JsAstUtils.sum(JsAstUtils.mul(new JsNameRef(varName), new JsIntLiteral(31)), component);
            JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(varName), new JsBinaryOperation(JsBinaryOperator.BIT_OR, newHashValue, new JsIntLiteral(0)));
            statements.add(assignment.source(KotlinSourceElementKt.getPsi(propertyDescriptor.getSource())).makeStmt());
        }
        JsReturn returnStatement = new JsReturn(new JsNameRef(varName));
        returnStatement.setSource(this.getDeclaration());
        statements.add(returnStatement);
    }

    @Override
    public void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        assert (!classProperties.isEmpty());
        JsFunction functionObj = this.generateJsMethod(function2);
        JsFunctionScope funScope = functionObj.getScope();
        JsName paramName = funScope.declareName("other");
        functionObj.getParameters().add(new JsParameter(paramName));
        JsBinaryOperation referenceEqual = JsAstUtils.equality(new JsThisRef(), new JsNameRef(paramName));
        JsBinaryOperation isNotNull = JsAstUtils.inequality(new JsNameRef(paramName), new JsNullLiteral());
        JsBinaryOperation otherIsObject = JsAstUtils.typeOfIs(paramName.makeRef(), new JsStringLiteral("object"));
        JsBinaryOperation prototypeEqual = JsAstUtils.equality(new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), new JsThisRef()), new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), new JsNameRef(paramName)));
        JsNode fieldChain = null;
        for (PropertyDescriptor propertyDescriptor : classProperties) {
            JsName name2 = this.context.getNameForDescriptor(propertyDescriptor);
            PsiElement source = KotlinSourceElementKt.getPsi(propertyDescriptor.getSource());
            JsNode next = new JsInvocation((JsExpression)this.context.namer().kotlin("equals"), new JsNameRef(name2, (JsExpression)new JsThisRef()), new JsNameRef(name2, (JsExpression)new JsNameRef(paramName))).source(source);
            if (fieldChain == null) {
                fieldChain = next;
                continue;
            }
            fieldChain = JsAstUtils.and((JsExpression)fieldChain, (JsExpression)next);
        }
        assert (fieldChain != null);
        JsBinaryOperation returnExpression = JsAstUtils.or(referenceEqual, JsAstUtils.and(isNotNull, JsAstUtils.and(otherIsObject, JsAstUtils.and(prototypeEqual, fieldChain))));
        JsReturn jsReturn = new JsReturn(returnExpression);
        jsReturn.setSource(this.getDeclaration());
        functionObj.getBody().getStatements().add(jsReturn);
    }

    @Override
    protected void generateComponentFunction(@NotNull FunctionDescriptor function2, @NotNull ValueParameterDescriptor parameter) {
    }

    @Override
    protected void generateCopyFunction(@NotNull FunctionDescriptor function2, @NotNull List<? extends KtParameter> constructorParameters) {
    }

    protected JsFunction generateJsMethod(@NotNull FunctionDescriptor functionDescriptor) {
        JsFunction functionObject = this.context.createRootScopedFunction(functionDescriptor);
        functionObject.setSource(this.getDeclaration());
        ClassDescriptor containingClass = (ClassDescriptor)functionDescriptor.getContainingDeclaration();
        this.context.addDeclarationStatement(UtilsKt.addFunctionToPrototype(this.context, containingClass, functionDescriptor, functionObject));
        return functionObject;
    }
}

