/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.NameReplacingVisitor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0005\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "fillCoroutineMetadata", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl$WithDestructuringDeclaration;", "js.translator"})
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        PsiElement finalElement = UtilsKt.getFinalElement(declaration);
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        TranslationContext invokingContext = translationContext;
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration);
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "getFunctionDescriptor(in\u2026ngContext(), declaration)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        JsFunction jsFunction = invokingContext.getFunctionObject(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "invokingContext.getFunctionObject(descriptor)");
        JsFunction lambda2 = jsFunction;
        TranslationContext translationContext2 = invokingContext.newFunctionBodyWithUsageTracker(lambda2, descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(translationContext2, "invokingContext\n        \u2026acker(lambda, descriptor)");
        List<JsParameter> list2 = lambda2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "lambda.parameters");
        TranslationContext functionContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext2, descriptor2, list2);
        List<ValueParameterDescriptor> list3 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, "descriptor.valueParameters");
        Iterable $receiver$iv = list3;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            if (!(it instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration)) continue;
            JsBlock jsBlock = lambda2.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "lambda.body");
            jsBlock.getStatements().add(this.translate((ValueParameterDescriptorImpl.WithDestructuringDeclaration)it, functionContext));
        }
        JsBlock jsBlock = lambda2.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "lambda.body");
        $receiver$iv = jsBlock.getStatements();
        List<JsStatement> list4 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, functionContext);
        Intrinsics.checkExpressionValueIsNotNull(list4, "setDefaultValueForArgume\u2026criptor, functionContext)");
        Object object = list4;
        CollectionsKt.addAll($receiver$iv, object);
        JsBlock jsBlock2 = lambda2.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock2, "lambda.body");
        $receiver$iv = jsBlock2.getStatements();
        object = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, functionContext);
        $receiver$iv.add(object);
        MetadataProperties.setFunctionDescriptor(lambda2, descriptor2);
        lambda2.setSource(finalElement);
        UsageTracker usageTracker = functionContext.usageTracker();
        if (usageTracker == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(usageTracker, "functionContext.usageTracker()!!");
        UsageTracker tracker = usageTracker;
        JsName jsName = invokingContext.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "invokingContext.getInner\u2026ForDescriptor(descriptor)");
        JsName name2 = jsName;
        if (UsageTrackerKt.hasCapturedExceptContaining(tracker)) {
            JsFunction jsFunction2 = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda2.source(declaration));
            Intrinsics.checkExpressionValueIsNotNull(jsFunction2, "simpleReturnFunction(inv\u2026mbda.source(declaration))");
            JsFunction lambdaCreator = jsFunction2;
            MetadataProperties.setLocal(lambdaCreator, true);
            if (tracker.getCapturedDescriptors().contains(descriptor2) && !DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
                lambda2.setName(UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor2));
            }
            MetadataProperties.setStaticRef(name2, lambdaCreator);
            this.fillCoroutineMetadata(lambdaCreator, invokingContext, descriptor2);
            lambdaCreator.setSource(declaration);
            return LiteralFunctionTranslatorKt.withCapturedParameters(lambdaCreator, functionContext, name2, invokingContext, declaration);
        }
        if (tracker.getCapturedDescriptors().contains(descriptor2)) {
            JsName jsName2 = UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor2);
            if (jsName2 == null) {
                Intrinsics.throwNpe();
            }
            JsName capturedName = jsName2;
            JsName jsName3 = invokingContext.getInnerNameForDescriptor(descriptor2);
            Intrinsics.checkExpressionValueIsNotNull(jsName3, "invokingContext.getInner\u2026ForDescriptor(descriptor)");
            JsName globalName = jsName3;
            NameReplacingVisitor replacingVisitor = new NameReplacingVisitor(MapsKt.mapOf(TuplesKt.to(capturedName, JsAstUtils.pureFqn(globalName, null))));
            replacingVisitor.accept((JsNode)lambda2);
        }
        MetadataProperties.setLocal(lambda2, true);
        LiteralFunctionTranslatorKt.access$addFunctionDeclaration(invokingContext, name2, lambda2, declaration);
        this.fillCoroutineMetadata(lambda2, invokingContext, descriptor2);
        MetadataProperties.setStaticRef(name2, lambda2);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(name2, null);
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "JsAstUtils.pureFqn(name, null)");
        return jsNameRef;
    }

    public final void fillCoroutineMetadata(@NotNull JsFunction $receiver, @NotNull TranslationContext context, @NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (!descriptor2.isSuspend()) {
            return;
        }
        UtilsKt.fillCoroutineMetadata($receiver, context, descriptor2, descriptor2.getExtensionReceiverParameter() != null);
        MetadataProperties.setForceStateMachine($receiver, true);
    }

    @NotNull
    public final JsVars translate(@NotNull ValueParameterDescriptorImpl.WithDestructuringDeclaration $receiver, @NotNull TranslationContext context) {
        ASTDelegatePsiElement aSTDelegatePsiElement;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(context, "context");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration($receiver);
        if (!(psiElement instanceof KtParameter)) {
            psiElement = null;
        }
        if ((aSTDelegatePsiElement = (KtParameter)psiElement) == null || (aSTDelegatePsiElement = aSTDelegatePsiElement.getDestructuringDeclaration()) == null) {
            String string2 = "Destructuring declaration for descriptor " + $receiver + " not found";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Intrinsics.checkExpressionValueIsNotNull(aSTDelegatePsiElement, "(DescriptorToSourceUtils\u2026criptor $this not found\")");
        ASTDelegatePsiElement destructuringDeclaration = aSTDelegatePsiElement;
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference($receiver, context);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "ReferenceTranslator.tran\u2026eReference(this, context)");
        JsExpression parameterRef = jsExpression;
        JsVars jsVars = DestructuringDeclarationTranslator.translate((KtDestructuringDeclaration)destructuringDeclaration, parameterRef, context);
        Intrinsics.checkExpressionValueIsNotNull(jsVars, "DestructuringDeclaration\u2026n, parameterRef, context)");
        return jsVars;
    }

    public LiteralFunctionTranslator(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
    }
}

