/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.expression.CapturedArgsParams;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007H\u0002\u001a \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001e\u0010\u0015\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0002\u001a&\u0010\u0017\u001a\u00020\u0001*\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002\u001a*\u0010\u001e\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\"\u00a8\u0006#"}, d2={"declareAliasInsideFunction", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "name", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "alias", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getTemporaryNamesInScope", "", "suggested", "isLocalInlineDeclaration", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "moveCapturedLocalInside", "Lorg/jetbrains/kotlin/js/translate/expression/CapturedArgsParams;", "capturingFunction", "capturedName", "localFunAlias", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "addDeclaration", "value", "addFunctionDeclaration", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "source", "", "getStaticRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Lorg/jetbrains/kotlin/js/backend/ast/HasName;", "withCapturedParameters", "context", "functionName", "invokingContext", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "js.translator"})
public final class LiteralFunctionTranslatorKt {
    private static final void addFunctionDeclaration(@NotNull TranslationContext $receiver, JsName name2, JsFunction function2, Object source) {
        UtilsKt.addFunctionButNotExport($receiver, name2, $receiver.isPublicInlineFunction() ? InlineMetadata.Companion.wrapFunction($receiver, new FunctionWithWrapper(function2, null), source) : (JsExpression)function2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression withCapturedParameters(@NotNull JsFunction $receiver, @NotNull TranslationContext context, @NotNull JsName functionName, @NotNull TranslationContext invokingContext, @NotNull KtDeclaration source) {
        JsInvocation jsInvocation;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(invokingContext, "invokingContext");
        Intrinsics.checkParameterIsNotNull(source, "source");
        LiteralFunctionTranslatorKt.addFunctionDeclaration(invokingContext, functionName, $receiver, source);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(functionName, null);
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "JsAstUtils.pureFqn(functionName, null)");
        JsNameRef ref = jsNameRef;
        JsInvocation $receiver2 = jsInvocation = new JsInvocation((JsExpression)ref, new JsExpression[0]);
        MetadataProperties.setSideEffects($receiver2, SideEffectKind.PURE);
        JsInvocation invocation = jsInvocation;
        List<JsExpression> list2 = invocation.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "invocation.arguments");
        List<JsExpression> invocationArguments = list2;
        List<JsParameter> list3 = $receiver.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, "this.parameters");
        List<JsParameter> functionParameters = list3;
        UsageTracker usageTracker = context.usageTracker();
        if (usageTracker == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(usageTracker, "context.usageTracker()!!");
        UsageTracker tracker = usageTracker;
        Map<DeclarationDescriptor, JsName> map2 = tracker.getCapturedDescriptorToJsName();
        Iterator<Map.Entry<DeclarationDescriptor, JsName>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            JsExpression capturedRef;
            Map.Entry<DeclarationDescriptor, JsName> entry;
            Map.Entry<DeclarationDescriptor, JsName> entry2 = entry = iterator2.next();
            DeclarationDescriptor capturedDescriptor = entry2.getKey();
            entry2 = entry;
            JsName name2 = entry2.getValue();
            if (Intrinsics.areEqual(capturedDescriptor, tracker.getContainingDescriptor()) && !DescriptorUtilsKt.isCoroutineLambda(capturedDescriptor)) continue;
            Intrinsics.checkExpressionValueIsNotNull(invokingContext.getArgumentForClosureConstructor(capturedDescriptor), "invokingContext.getArgum\u2026uctor(capturedDescriptor)");
            List<JsExpression> additionalArgs = CollectionsKt.listOf(capturedRef);
            List<JsParameter> additionalParams = CollectionsKt.listOf(new JsParameter(name2));
            if (capturedDescriptor instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)capturedDescriptor).isReified()) {
                additionalArgs = CollectionsKt.plus((Collection)CollectionsKt.listOf(invokingContext.getCapturedTypeName((TypeParameterDescriptor)capturedDescriptor).makeRef()), (Iterable)additionalArgs);
                additionalParams = CollectionsKt.plus((Collection)CollectionsKt.listOf(new JsParameter(context.getCapturedTypeName((TypeParameterDescriptor)capturedDescriptor))), (Iterable)additionalParams);
            }
            if (capturedDescriptor instanceof CallableDescriptor && LiteralFunctionTranslatorKt.isLocalInlineDeclaration((CallableDescriptor)capturedDescriptor)) {
                JsExpression localFunAlias;
                JsNameRef aliasRef;
                JsExpression jsExpression = capturedRef;
                if (!(jsExpression instanceof JsNameRef)) {
                    jsExpression = null;
                }
                JsNameRef jsNameRef2 = aliasRef = (JsNameRef)jsExpression;
                JsNode jsNode = jsNameRef2 != null ? LiteralFunctionTranslatorKt.getStaticRef(jsNameRef2) : null;
                if (!(jsNode instanceof JsExpression)) {
                    jsNode = null;
                }
                if ((localFunAlias = (JsExpression)jsNode) != null) {
                    void args;
                    CapturedArgsParams capturedArgsParams = LiteralFunctionTranslatorKt.moveCapturedLocalInside($receiver, name2, localFunAlias);
                    List<JsExpression> list4 = capturedArgsParams.component1();
                    List<JsParameter> params = capturedArgsParams.component2();
                    additionalArgs = args;
                    additionalParams = params;
                }
            }
            functionParameters.addAll((Collection<JsParameter>)additionalParams);
            invocationArguments.addAll((Collection<JsExpression>)additionalArgs);
        }
        return invocation;
    }

    private static final CapturedArgsParams moveCapturedLocalInside(JsFunction capturingFunction, JsName capturedName, JsExpression localFunAlias) {
        CapturedArgsParams capturedArgsParams;
        JsExpression jsExpression = localFunAlias;
        if (jsExpression instanceof JsNameRef) {
            LiteralFunctionTranslatorKt.declareAliasInsideFunction(capturingFunction, capturedName, localFunAlias);
            capturedArgsParams = new CapturedArgsParams(null, null, 3, null);
        } else if (jsExpression instanceof JsInvocation) {
            capturedArgsParams = LiteralFunctionTranslatorKt.moveCapturedLocalInside(capturingFunction, capturedName, (JsInvocation)localFunAlias);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Local function reference has wrong alias " + localFunAlias)));
        }
        return capturedArgsParams;
    }

    /*
     * WARNING - void declaration
     */
    private static final CapturedArgsParams moveCapturedLocalInside(JsFunction capturingFunction, JsName capturedName, JsInvocation localFunAlias) {
        void $receiver$iv$iv;
        SourceInfoAwareJsNode sourceInfoAwareJsNode;
        Collection collection;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        List<JsExpression> list2 = localFunAlias.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "localFunAlias.arguments");
        List<JsExpression> capturedArgs = list2;
        List<JsName> freshNames = LiteralFunctionTranslatorKt.getTemporaryNamesInScope(capturedArgs);
        Iterable iterable = $receiver$iv = (Iterable)freshNames;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void p1;
            JsName jsName = (JsName)item$iv$iv;
            collection = destination$iv$iv;
            sourceInfoAwareJsNode = p1.makeRef();
            collection.add(sourceInfoAwareJsNode);
        }
        List aliasCallArguments = (List)destination$iv$iv;
        JsInvocation alias = new JsInvocation(localFunAlias.getQualifier(), aliasCallArguments);
        LiteralFunctionTranslatorKt.declareAliasInsideFunction(capturingFunction, capturedName, alias);
        Iterable $receiver$iv2 = freshNames;
        Iterable iterable2 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            JsName $i$f$mapTo = (JsName)item$iv$iv;
            collection = destination$iv$iv2;
            sourceInfoAwareJsNode = new JsParameter((JsName)p1);
            collection.add(sourceInfoAwareJsNode);
        }
        List capturedParameters = (List)destination$iv$iv2;
        return new CapturedArgsParams(capturedArgs, capturedParameters);
    }

    private static final void declareAliasInsideFunction(JsFunction function2, JsName name2, JsExpression alias) {
        block0: {
            MetadataProperties.setStaticRef(name2, alias);
            JsFunction jsFunction = FunctionUtilsKt.getInnerFunction(function2);
            if (jsFunction == null) break block0;
            LiteralFunctionTranslatorKt.addDeclaration(jsFunction, name2, alias);
        }
    }

    private static final List<JsName> getTemporaryNamesInScope(List<? extends JsExpression> suggested) {
        ArrayList<JsName> freshNames = new ArrayList<JsName>();
        for (JsExpression jsExpression : suggested) {
            JsName name2;
            String ident;
            if (!(jsExpression instanceof JsNameRef)) {
                throw (Throwable)((Object)new AssertionError((Object)"Expected suggestion to be JsNameRef"));
            }
            Intrinsics.checkExpressionValueIsNotNull(((JsNameRef)jsExpression).getIdent(), "suggestion.ident");
            Intrinsics.checkExpressionValueIsNotNull(JsScope.declareTemporaryName(ident), "JsScope.declareTemporaryName(ident)");
            freshNames.add(name2);
        }
        return freshNames;
    }

    private static final void addDeclaration(@NotNull JsFunction $receiver, JsName name2, JsExpression value2) {
        JsVars jsVars = JsAstUtils.newVar(name2, value2);
        Intrinsics.checkExpressionValueIsNotNull(jsVars, "JsAstUtils.newVar(name, value)");
        JsVars declaration = jsVars;
        JsBlock jsBlock = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "this.body");
        jsBlock.getStatements().add(0, declaration);
    }

    private static final JsNode getStaticRef(@NotNull HasName $receiver) {
        JsName jsName = $receiver.getName();
        return jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
    }

    private static final boolean isLocalInlineDeclaration(CallableDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual(descriptor2.getVisibility(), Visibilities.LOCAL) && InlineUtil.isInline(descriptor2);
    }

    public static final /* synthetic */ void access$addFunctionDeclaration(@NotNull TranslationContext $receiver, @NotNull JsName name2, @NotNull JsFunction function2, @Nullable Object source) {
        LiteralFunctionTranslatorKt.addFunctionDeclaration($receiver, name2, function2, source);
    }
}

