/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

public final class InitializerVisitor
extends TranslatorVisitor<Void> {
    @Override
    protected Void emptyResult(@NotNull TranslationContext context) {
        return null;
    }

    @Override
    public final Void visitProperty(@NotNull KtProperty property, @NotNull TranslationContext context) {
        PropertyDescriptor descriptor2 = BindingUtils.getPropertyDescriptor(context.bindingContext(), property);
        JsExpression value2 = PropertyTranslatorKt.translateDelegateOrInitializerExpression(context, property);
        JsStatement statement2 = null;
        KtExpression initializer2 = property.getInitializer();
        KtExpression delegate2 = property.getDelegateExpression();
        if (initializer2 != null) {
            assert (value2 != null);
            KotlinType type2 = TranslationUtils.isReferenceToSyntheticBackingField(descriptor2) ? descriptor2.getType() : TranslationUtils.getReturnTypeForCoercion(descriptor2);
            value2 = TranslationUtils.coerce(context, value2, type2);
            statement2 = InitializerUtils.generateInitializerForProperty(context, descriptor2, value2);
        } else if (delegate2 != null) {
            assert (value2 != null);
            statement2 = InitializerUtils.generateInitializerForDelegate(context, descriptor2, value2);
        } else if (Boolean.TRUE.equals(context.bindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context, descriptor2);
            JsExpression defaultValue = InitializerVisitor.generateDefaultValue(descriptor2, backingFieldReference);
            statement2 = TranslationUtils.assignmentToBackingField(context, descriptor2, defaultValue).source(property).makeStmt();
        } else if (JsDescriptorUtils.isSimpleFinalProperty(descriptor2)) {
            JsNameRef propRef = new JsNameRef(context.getNameForDescriptor(descriptor2), (JsExpression)new JsThisRef());
            JsExpression defaultValue = InitializerVisitor.generateDefaultValue(descriptor2, propRef);
            statement2 = JsAstUtils.assignment(propRef, defaultValue).source(property).makeStmt();
        }
        if (statement2 != null && !JsAstUtils.isEmptyStatement(statement2)) {
            context.addStatementsToCurrentBlock(JsAstUtils.flattenStatement(statement2));
        }
        return null;
    }

    @NotNull
    private static JsExpression generateDefaultValue(@NotNull PropertyDescriptor property, @NotNull JsExpression lateInitDefault) {
        if (property.isLateInit()) {
            return lateInitDefault.deepCopy();
        }
        KotlinType type2 = property.getType();
        if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isFloat(type2) || KotlinBuiltIns.isDouble(type2) || KotlinBuiltIns.isByte(type2) || KotlinBuiltIns.isShort(type2)) {
            return new JsIntLiteral(0);
        }
        if (KotlinBuiltIns.isBoolean(type2)) {
            return new JsBooleanLiteral(false);
        }
        return new JsNullLiteral();
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2, @NotNull TranslationContext context) {
        KtExpression initializerBody = initializer2.getBody();
        if (initializerBody != null) {
            context.addStatementsToCurrentBlock(JsAstUtils.flattenStatement(Translation.translateAsStatementAndMergeInBlockIfNeeded(initializerBody, context)));
        }
        return null;
    }

    @Override
    public Void visitDeclaration(@NotNull KtDeclaration expression2, @NotNull TranslationContext context) {
        return null;
    }

    @Override
    public Void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, TranslationContext data2) {
        return null;
    }
}

