/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.SignatureUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"escape", "", "s", "generateSignature", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "js.translator"})
public final class SignatureUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String generateSignature(@NotNull DeclarationDescriptor descriptor2) {
        String string2;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            return null;
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility && Intrinsics.areEqual(((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), Visibilities.PRIVATE) && !AnnotationsUtils.isNativeObject(descriptor2) && !AnnotationsUtils.isLibraryObject(descriptor2)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof CallableDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "descriptor.containingDeclaration");
            String string3 = SignatureUtilsKt.generateSignature(declarationDescriptor2);
            if (string3 == null) {
                return null;
            }
            String parent2 = string3;
            if (!(descriptor2 instanceof VariableAccessorDescriptor) && !(descriptor2 instanceof ConstructorDescriptor)) {
                Name name2 = ((CallableDescriptor)descriptor2).getName();
                Intrinsics.checkExpressionValueIsNotNull(name2, "descriptor.name");
                if (name2.isSpecial()) {
                    return null;
                }
            }
            String separator = descriptor2 instanceof FunctionDescriptor ? "#" : "!";
            StringBuilder stringBuilder = new StringBuilder().append(parent2).append(separator);
            String string4 = ((CallableDescriptor)descriptor2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string4, "descriptor.name.asString()");
            string2 = stringBuilder.append(SignatureUtilsKt.escape(string4)).append("|").append(EncodeSignatureKt.encodeSignature((CallableDescriptor)descriptor2)).toString();
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            String string5 = DescriptorUtilsKt.getModule(descriptor2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string5, "descriptor.module.name.asString()");
            String module2 = string5;
            Sequence<String> sequence2 = SequencesKt.sequenceOf(module2);
            List<Name> list2 = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.fqName.pathSegments()");
            Iterable iterable = list2;
            Sequence<String> sequence3 = sequence2;
            void var5_9 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Name name3 = (Name)item$iv$iv;
                collection = destination$iv$iv;
                void v9 = it;
                Intrinsics.checkExpressionValueIsNotNull(v9, "it");
                String string6 = v9.getIdentifier();
                collection.add(string6);
            }
            collection = (List)destination$iv$iv;
            Sequence<String> parts = SequencesKt.plus(sequence3, (Iterable)collection);
            string2 = SequencesKt.joinToString$default(parts, ".", null, null, 0, null, generateSignature.1.INSTANCE, 30, null);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((ClassDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "descriptor.containingDeclaration");
            String string7 = SignatureUtilsKt.generateSignature(declarationDescriptor3);
            if (string7 == null) {
                return null;
            }
            String parent3 = string7;
            Name name4 = ((ClassDescriptor)descriptor2).getName();
            Intrinsics.checkExpressionValueIsNotNull(name4, "descriptor.name");
            if (name4.isSpecial()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder().append(parent3).append("$");
            String string8 = ((ClassDescriptor)descriptor2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string8, "descriptor.name.asString()");
            string2 = stringBuilder.append(SignatureUtilsKt.escape(string8)).toString();
        } else {
            return null;
        }
        return string2;
    }

    private static final String escape(String s) {
        StringBuilder sb = new StringBuilder();
        String string2 = s;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            String string3;
            char c = string2.charAt(i);
            switch (c) {
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    string3 = "" + '\\' + c;
                    break;
                }
                default: {
                    string3 = String.valueOf(c);
                }
            }
            String escapedChar = string3;
            sb.append(escapedChar);
        }
        String string4 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string4, "sb.toString()");
        return string4;
    }

    @NotNull
    public static final /* synthetic */ String access$escape(@NotNull String s) {
        return SignatureUtilsKt.escape(s);
    }
}

