/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public class JavaAnnotationImpl
extends JavaElementImpl<PsiAnnotation>
implements JavaAnnotation {
    public JavaAnnotationImpl(@NotNull PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotationArgument> getArguments() {
        return JavaElementCollectionFromPsiArrayUtil.namedAnnotationArguments(((PsiAnnotation)this.getPsi()).getParameterList().getAttributes());
    }

    @Override
    @Nullable
    public ClassId getClassId() {
        PsiClass resolved = this.resolvePsi();
        if (resolved != null) {
            return JavaAnnotationImpl.computeClassId(resolved);
        }
        String qualifiedName2 = ((PsiAnnotation)this.getPsi()).getQualifiedName();
        if (qualifiedName2 != null) {
            return ClassId.topLevel(new FqName(qualifiedName2));
        }
        return null;
    }

    @Override
    @Nullable
    public JavaClass resolve() {
        PsiClass resolved = this.resolvePsi();
        return resolved == null ? null : new JavaClassImpl(resolved);
    }

    @Nullable
    private static ClassId computeClassId(@NotNull PsiClass psiClass) {
        PsiClass container2 = psiClass.getContainingClass();
        if (container2 != null) {
            ClassId parentClassId = JavaAnnotationImpl.computeClassId(container2);
            String name2 = psiClass.getName();
            return parentClassId == null || name2 == null ? null : parentClassId.createNestedClassId(Name.identifier(name2));
        }
        String fqName2 = psiClass.getQualifiedName();
        return fqName2 == null ? null : ClassId.topLevel(new FqName(fqName2));
    }

    @Nullable
    private PsiClass resolvePsi() {
        PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)this.getPsi()).getNameReferenceElement();
        if (referenceElement == null) {
            return null;
        }
        PsiElement resolved = referenceElement.resolve();
        return resolved instanceof PsiClass ? (PsiClass)resolved : null;
    }
}

