/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.ReadKotlinClassHeaderAnnotationVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class FileBasedKotlinClass
implements KotlinJvmBinaryClass {
    private final ClassId classId;
    private final int classVersion;
    private final KotlinClassHeader classHeader;
    private final InnerClassesInfo innerClasses;

    protected FileBasedKotlinClass(@NotNull ClassId classId, int classVersion, @NotNull KotlinClassHeader classHeader, @NotNull InnerClassesInfo innerClasses2) {
        this.classId = classId;
        this.classVersion = classVersion;
        this.classHeader = classHeader;
        this.innerClasses = innerClasses2;
    }

    @NotNull
    protected abstract byte[] getFileContents();

    @Nullable
    public static <T extends FileBasedKotlinClass> T create(@NotNull byte[] fileContents, @NotNull Function4<ClassId, Integer, KotlinClassHeader, InnerClassesInfo, T> factory2) {
        final ReadKotlinClassHeaderAnnotationVisitor readHeaderVisitor = new ReadKotlinClassHeaderAnnotationVisitor();
        final Ref classNameRef = Ref.create();
        final Ref classVersion = Ref.create();
        final InnerClassesInfo innerClasses2 = new InnerClassesInfo();
        new ClassReader(fileContents).accept(new ClassVisitor(327680){

            @Override
            public void visit(int version, int access, @NotNull String name2, String signature2, String superName, String[] interfaces) {
                classNameRef.set(name2);
                classVersion.set(version);
            }

            @Override
            public void visitInnerClass(@NotNull String name2, String outerName, String innerName, int access) {
                innerClasses2.add(name2, outerName, innerName);
            }

            @Override
            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                return FileBasedKotlinClass.convertAnnotationVisitor(readHeaderVisitor, desc, innerClasses2);
            }

            @Override
            public void visitEnd() {
                readHeaderVisitor.visitEnd();
            }
        }, 7);
        String className2 = (String)classNameRef.get();
        if (className2 == null) {
            return null;
        }
        KotlinClassHeader header = readHeaderVisitor.createHeader();
        if (header == null) {
            return null;
        }
        ClassId id = FileBasedKotlinClass.resolveNameByInternalName(className2, innerClasses2);
        return (T)((FileBasedKotlinClass)factory2.invoke(id, (Integer)classVersion.get(), header, innerClasses2));
    }

    @Override
    @NotNull
    public ClassId getClassId() {
        return this.classId;
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    @Override
    @NotNull
    public KotlinClassHeader getClassHeader() {
        return this.classHeader;
    }

    @Override
    public void loadClassAnnotations(final @NotNull KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor, @Nullable byte[] cachedContents) {
        byte[] fileContents = cachedContents != null ? cachedContents : this.getFileContents();
        new ClassReader(fileContents).accept(new ClassVisitor(327680){

            @Override
            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                return FileBasedKotlinClass.convertAnnotationVisitor(annotationVisitor, desc, FileBasedKotlinClass.this.innerClasses);
            }

            @Override
            public void visitEnd() {
                annotationVisitor.visitEnd();
            }
        }, 7);
    }

    @Nullable
    public static AnnotationVisitor convertAnnotationVisitor(@NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2, @NotNull String desc, @NotNull InnerClassesInfo innerClasses2) {
        KotlinJvmBinaryClass.AnnotationArgumentVisitor v2 = visitor2.visitAnnotation(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses2), SourceElement.NO_SOURCE);
        return v2 == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(v2, innerClasses2);
    }

    @NotNull
    private static AnnotationVisitor convertAnnotationVisitor(final @NotNull KotlinJvmBinaryClass.AnnotationArgumentVisitor v2, final @NotNull InnerClassesInfo innerClasses2) {
        return new AnnotationVisitor(327680){

            @Override
            public void visit(String name2, @NotNull Object value2) {
                if (value2 instanceof Type) {
                    KotlinJvmBinaryClass.ClassLiteralId classLiteralId = FileBasedKotlinClass.resolveKotlinNameByType((Type)value2, innerClasses2);
                    v2.visitClassLiteral(Name.identifier(name2), classLiteralId);
                } else {
                    v2.visit(name2 == null ? null : Name.identifier(name2), value2);
                }
            }

            @Override
            public AnnotationVisitor visitArray(String name2) {
                final KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor arv = v2.visitArray(Name.identifier(name2));
                return arv == null ? null : new AnnotationVisitor(327680){

                    @Override
                    public void visit(String name2, @NotNull Object value2) {
                        if (value2 instanceof Type) {
                            KotlinJvmBinaryClass.ClassLiteralId classLiteralId = FileBasedKotlinClass.resolveKotlinNameByType((Type)value2, innerClasses2);
                            arv.visitClassLiteral(classLiteralId);
                        } else {
                            arv.visit(value2);
                        }
                    }

                    @Override
                    public void visitEnum(String name2, @NotNull String desc, @NotNull String value2) {
                        arv.visitEnum(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses2), Name.identifier(value2));
                    }

                    @Override
                    public void visitEnd() {
                        arv.visitEnd();
                    }
                };
            }

            @Override
            public AnnotationVisitor visitAnnotation(String name2, @NotNull String desc) {
                KotlinJvmBinaryClass.AnnotationArgumentVisitor arv = v2.visitAnnotation(Name.identifier(name2), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses2));
                return arv == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(arv, innerClasses2);
            }

            @Override
            public void visitEnum(String name2, @NotNull String desc, @NotNull String value2) {
                v2.visitEnum(Name.identifier(name2), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses2), Name.identifier(value2));
            }

            @Override
            public void visitEnd() {
                v2.visitEnd();
            }
        };
    }

    @Override
    public void visitMembers(final @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor, @Nullable byte[] cachedContents) {
        byte[] fileContents = cachedContents != null ? cachedContents : this.getFileContents();
        new ClassReader(fileContents).accept(new ClassVisitor(327680){

            @Override
            public FieldVisitor visitField(int access, @NotNull String name2, @NotNull String desc, String signature2, Object value2) {
                final KotlinJvmBinaryClass.AnnotationVisitor v2 = memberVisitor.visitField(Name.identifier(name2), desc, value2);
                if (v2 == null) {
                    return null;
                }
                return new FieldVisitor(327680){

                    @Override
                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        return FileBasedKotlinClass.convertAnnotationVisitor(v2, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    @Override
                    public void visitEnd() {
                        v2.visitEnd();
                    }
                };
            }

            @Override
            public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, String signature2, String[] exceptions) {
                final KotlinJvmBinaryClass.MethodAnnotationVisitor v2 = memberVisitor.visitMethod(Name.identifier(name2), desc);
                if (v2 == null) {
                    return null;
                }
                return new MethodVisitor(327680){

                    @Override
                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        return FileBasedKotlinClass.convertAnnotationVisitor(v2, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    @Override
                    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String desc, boolean visible) {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor av = v2.visitParameterAnnotation(parameter, FileBasedKotlinClass.resolveNameByDesc(desc, FileBasedKotlinClass.this.innerClasses), SourceElement.NO_SOURCE);
                        return av == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(av, FileBasedKotlinClass.this.innerClasses);
                    }

                    @Override
                    public void visitEnd() {
                        v2.visitEnd();
                    }
                };
            }
        }, 7);
    }

    @NotNull
    private static ClassId resolveNameByDesc(@NotNull String desc, @NotNull InnerClassesInfo innerClasses2) {
        assert (desc.startsWith("L") && desc.endsWith(";")) : "Not a JVM descriptor: " + desc;
        String name2 = desc.substring(1, desc.length() - 1);
        return FileBasedKotlinClass.resolveNameByInternalName(name2, innerClasses2);
    }

    @NotNull
    private static KotlinJvmBinaryClass.ClassLiteralId resolveKotlinNameByType(@NotNull Type type2, @NotNull InnerClassesInfo innerClasses2) {
        String typeDesc = type2.getDescriptor();
        int dimensions = typeDesc.charAt(0) == '[' ? type2.getDimensions() : 0;
        String elementDesc = dimensions == 0 ? typeDesc : type2.getElementType().getDescriptor();
        JvmPrimitiveType primType = JvmPrimitiveType.getByDesc(elementDesc);
        if (primType != null) {
            return new KotlinJvmBinaryClass.ClassLiteralId(ClassId.topLevel(primType.getPrimitiveType().getTypeFqName()), dimensions);
        }
        ClassId javaClassId = FileBasedKotlinClass.resolveNameByDesc(elementDesc, innerClasses2);
        ClassId kotlinClassId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(javaClassId.asSingleFqName());
        return new KotlinJvmBinaryClass.ClassLiteralId(kotlinClassId != null ? kotlinClassId : javaClassId, dimensions);
    }

    @NotNull
    private static ClassId resolveNameByInternalName(@NotNull String name2, @NotNull InnerClassesInfo innerClasses2) {
        OuterAndInnerName outer;
        if (!name2.contains("$")) {
            return ClassId.topLevel(new FqName(name2.replace('/', '.')));
        }
        ArrayList<String> classes2 = new ArrayList<String>(1);
        boolean local = false;
        while ((outer = innerClasses2.get(name2)) != null) {
            if (outer.outerInternalName == null) {
                local = true;
                break;
            }
            classes2.add(outer.innerSimpleName);
            name2 = outer.outerInternalName;
        }
        FqName outermostClassFqName = new FqName(name2.replace('/', '.'));
        classes2.add(outermostClassFqName.shortName().asString());
        Collections.reverse(classes2);
        FqName packageFqName = outermostClassFqName.parent();
        FqName relativeClassName = FqName.fromSegments(classes2);
        return new ClassId(packageFqName, relativeClassName, local);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public static class InnerClassesInfo {
        private Map<String, OuterAndInnerName> map = null;

        public void add(@NotNull String name2, @Nullable String outerName, @Nullable String innerName) {
            if (this.map == null) {
                this.map = new HashMap<String, OuterAndInnerName>();
            }
            this.map.put(name2, new OuterAndInnerName(outerName, innerName));
        }

        @Nullable
        public OuterAndInnerName get(@NotNull String name2) {
            return this.map == null ? null : this.map.get(name2);
        }
    }

    public static class OuterAndInnerName {
        public final String outerInternalName;
        public final String innerSimpleName;

        private OuterAndInnerName(@Nullable String outerInternalName, @Nullable String innerSimpleName) {
            this.outerInternalName = outerInternalName;
            this.innerSimpleName = innerSimpleName;
        }
    }
}

