/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.header;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public class ReadKotlinClassHeaderAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private static final boolean IGNORE_OLD_METADATA = "true".equals(System.getProperty("kotlin.ignore.old.metadata"));
    private static final Map<ClassId, KotlinClassHeader.Kind> HEADER_KINDS = new HashMap<ClassId, KotlinClassHeader.Kind>();
    private int[] metadataVersionArray = null;
    private JvmBytecodeBinaryVersion bytecodeVersion = null;
    private String extraString = null;
    private int extraInt = 0;
    private String packageName = null;
    private String[] data = null;
    private String[] strings = null;
    private String[] incompatibleData = null;
    private KotlinClassHeader.Kind headerKind = null;

    @Nullable
    public KotlinClassHeader createHeader() {
        if (this.headerKind == null || this.metadataVersionArray == null) {
            return null;
        }
        JvmMetadataVersion metadataVersion2 = new JvmMetadataVersion(this.metadataVersionArray, (this.extraInt & 8) != 0);
        if (!metadataVersion2.isCompatible()) {
            this.incompatibleData = this.data;
            this.data = null;
        } else if (this.shouldHaveData() && this.data == null) {
            return null;
        }
        return new KotlinClassHeader(this.headerKind, metadataVersion2, this.bytecodeVersion != null ? this.bytecodeVersion : JvmBytecodeBinaryVersion.INVALID_VERSION, this.data, this.incompatibleData, this.strings, this.extraString, this.extraInt, this.packageName);
    }

    private boolean shouldHaveData() {
        return this.headerKind == KotlinClassHeader.Kind.CLASS || this.headerKind == KotlinClassHeader.Kind.FILE_FACADE || this.headerKind == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId, @NotNull SourceElement source) {
        FqName fqName2 = classId.asSingleFqName();
        if (fqName2.equals(JvmAnnotationNames.METADATA_FQ_NAME)) {
            return new KotlinMetadataArgumentVisitor();
        }
        if (IGNORE_OLD_METADATA) {
            return null;
        }
        if (this.headerKind != null) {
            return null;
        }
        KotlinClassHeader.Kind newKind = HEADER_KINDS.get(classId);
        if (newKind != null) {
            this.headerKind = newKind;
            return new OldDeprecatedAnnotationArgumentVisitor();
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    static /* synthetic */ int[] access$302(ReadKotlinClassHeaderAnnotationVisitor x0, int[] x1) {
        x0.metadataVersionArray = x1;
        return x1;
    }

    static /* synthetic */ String[] access$802(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.data = x1;
        return x1;
    }

    static /* synthetic */ String[] access$902(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.strings = x1;
        return x1;
    }

    static {
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinClass")), KotlinClassHeader.Kind.CLASS);
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinFileFacade")), KotlinClassHeader.Kind.FILE_FACADE);
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinMultifileClass")), KotlinClassHeader.Kind.MULTIFILE_CLASS);
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinMultifileClassPart")), KotlinClassHeader.Kind.MULTIFILE_CLASS_PART);
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinSyntheticClass")), KotlinClassHeader.Kind.SYNTHETIC_CLASS);
    }

    private static abstract class CollectStringArrayAnnotationVisitor
    implements KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor {
        private final List<String> strings = new ArrayList<String>();

        @Override
        public void visit(@Nullable Object value2) {
            if (value2 instanceof String) {
                this.strings.add((String)value2);
            }
        }

        @Override
        public void visitEnum(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
        }

        @Override
        public void visitClassLiteral(@NotNull KotlinJvmBinaryClass.ClassLiteralId classLiteralId) {
        }

        @Override
        public void visitEnd() {
            this.visitEnd(this.strings.toArray(new String[this.strings.size()]));
        }

        protected abstract void visitEnd(@NotNull String[] var1);
    }

    private class OldDeprecatedAnnotationArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        private OldDeprecatedAnnotationArgumentVisitor() {
        }

        @Override
        public void visit(@Nullable Name name2, @Nullable Object value2) {
            if (name2 == null) {
                return;
            }
            String string2 = name2.asString();
            if ("version".equals(string2)) {
                if (value2 instanceof int[]) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$302(ReadKotlinClassHeaderAnnotationVisitor.this, (int[])value2);
                    if (ReadKotlinClassHeaderAnnotationVisitor.this.bytecodeVersion == null) {
                        ReadKotlinClassHeaderAnnotationVisitor.this.bytecodeVersion = new JvmBytecodeBinaryVersion((int[])value2);
                    }
                }
            } else if ("multifileClassName".equals(string2)) {
                ReadKotlinClassHeaderAnnotationVisitor.this.extraString = value2 instanceof String ? (String)value2 : null;
            }
        }

        @Override
        public void visitClassLiteral(@NotNull Name name2, @NotNull KotlinJvmBinaryClass.ClassLiteralId classLiteralId) {
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name2) {
            String string2 = name2.asString();
            if ("data".equals(string2) || "filePartClassNames".equals(string2)) {
                return this.dataArrayVisitor();
            }
            if ("strings".equals(string2)) {
                return this.stringsArrayVisitor();
            }
            return null;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor dataArrayVisitor() {
            return new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] data2) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$802(ReadKotlinClassHeaderAnnotationVisitor.this, data2);
                }
            };
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor stringsArrayVisitor() {
            return new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] data2) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$902(ReadKotlinClassHeaderAnnotationVisitor.this, data2);
                }
            };
        }

        @Override
        public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name2, @NotNull ClassId classId) {
            return null;
        }

        @Override
        public void visitEnd() {
        }
    }

    private class KotlinMetadataArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        private KotlinMetadataArgumentVisitor() {
        }

        @Override
        public void visit(@Nullable Name name2, @Nullable Object value2) {
            if (name2 == null) {
                return;
            }
            String string2 = name2.asString();
            if ("k".equals(string2)) {
                if (value2 instanceof Integer) {
                    ReadKotlinClassHeaderAnnotationVisitor.this.headerKind = KotlinClassHeader.Kind.getById((Integer)value2);
                }
            } else if ("mv".equals(string2)) {
                if (value2 instanceof int[]) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$302(ReadKotlinClassHeaderAnnotationVisitor.this, (int[])value2);
                }
            } else if ("bv".equals(string2)) {
                if (value2 instanceof int[]) {
                    ReadKotlinClassHeaderAnnotationVisitor.this.bytecodeVersion = new JvmBytecodeBinaryVersion((int[])value2);
                }
            } else if ("xs".equals(string2)) {
                if (value2 instanceof String) {
                    ReadKotlinClassHeaderAnnotationVisitor.this.extraString = (String)value2;
                }
            } else if ("xi".equals(string2)) {
                if (value2 instanceof Integer) {
                    ReadKotlinClassHeaderAnnotationVisitor.this.extraInt = (Integer)value2;
                }
            } else if ("pn".equals(string2) && value2 instanceof String) {
                ReadKotlinClassHeaderAnnotationVisitor.this.packageName = (String)value2;
            }
        }

        @Override
        public void visitClassLiteral(@NotNull Name name2, @NotNull KotlinJvmBinaryClass.ClassLiteralId classLiteralId) {
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name2) {
            String string2 = name2.asString();
            if ("d1".equals(string2)) {
                return this.dataArrayVisitor();
            }
            if ("d2".equals(string2)) {
                return this.stringsArrayVisitor();
            }
            return null;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor dataArrayVisitor() {
            return new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] result2) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$802(ReadKotlinClassHeaderAnnotationVisitor.this, result2);
                }
            };
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor stringsArrayVisitor() {
            return new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] result2) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$902(ReadKotlinClassHeaderAnnotationVisitor.this, result2);
                }
            };
        }

        @Override
        public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name2, @NotNull ClassId classId) {
            return null;
        }

        @Override
        public void visitEnd() {
        }
    }
}

