/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.serialization;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.serialization.StringTable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\u00020\u0017*\u00020\u000fH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0007`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u000ej\b\u0012\u0004\u0012\u00020\u000b`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "Lorg/jetbrains/kotlin/metadata/serialization/StringTable;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "(Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;)V", "localNames", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "map", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "records", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/metadata/jvm/JvmProtoBuf$StringTableTypes$Record$Builder;", "Lkotlin/collections/ArrayList;", "strings", "getStrings", "()Ljava/util/ArrayList;", "getQualifiedClassNameIndex", "className", "isLocal", "", "getStringIndex", "string", "serializeTo", "", "output", "Ljava/io/OutputStream;", "isTrivial", "metadata.jvm"})
public class JvmStringTable
implements StringTable {
    @NotNull
    private final ArrayList<String> strings;
    private final ArrayList<JvmProtoBuf.StringTableTypes.Record.Builder> records;
    private final HashMap<String, Integer> map;
    private final LinkedHashSet<Integer> localNames;

    @NotNull
    public final ArrayList<String> getStrings() {
        return this.strings;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getStringIndex(@NotNull String string2) {
        Integer n;
        Intrinsics.checkParameterIsNotNull(string2, "string");
        Map $receiver$iv = this.map;
        Object value$iv = $receiver$iv.get(string2);
        if (value$iv == null) {
            int n2;
            int $receiver = n2 = this.strings.size();
            this.strings.add(string2);
            JvmProtoBuf.StringTableTypes.Record.Builder lastRecord = (JvmProtoBuf.StringTableTypes.Record.Builder)CollectionsKt.lastOrNull((List)this.records);
            if (lastRecord != null && this.isTrivial(lastRecord)) {
                lastRecord.setRange(lastRecord.getRange() + 1);
            } else {
                this.records.add(JvmProtoBuf.StringTableTypes.Record.newBuilder());
            }
            Integer answer$iv = n2;
            $receiver$iv.put(string2, answer$iv);
            n = answer$iv;
        } else {
            void var3_3;
            n = var3_3;
        }
        return ((Number)n).intValue();
    }

    private final boolean isTrivial(@NotNull JvmProtoBuf.StringTableTypes.Record.Builder $receiver) {
        return !$receiver.hasPredefinedIndex() && !$receiver.hasOperation() && $receiver.getSubstringIndexCount() == 0 && $receiver.getReplaceCharCount() == 0;
    }

    @Override
    public int getQualifiedClassNameIndex(@NotNull String className2, boolean isLocal) {
        Integer n;
        Integer recordedIndex;
        Intrinsics.checkParameterIsNotNull(className2, "className");
        Integer n2 = this.map.get(className2);
        if (n2 != null && isLocal == this.localNames.contains(recordedIndex = (n = n2))) {
            Integer n3 = recordedIndex;
            Intrinsics.checkExpressionValueIsNotNull(n3, "recordedIndex");
            return n3;
        }
        int index2 = this.strings.size();
        if (isLocal) {
            this.localNames.add(index2);
        }
        JvmProtoBuf.StringTableTypes.Record.Builder record2 = JvmProtoBuf.StringTableTypes.Record.newBuilder();
        if (isLocal || StringsKt.contains$default((CharSequence)className2, '$', false, 2, null)) {
            this.strings.add(className2);
        } else {
            Integer predefinedIndex = JvmNameResolver.Companion.getPredefinedStringIndex(className2);
            if (predefinedIndex != null) {
                JvmProtoBuf.StringTableTypes.Record.Builder builder = record2;
                Intrinsics.checkExpressionValueIsNotNull(builder, "record");
                builder.setPredefinedIndex(predefinedIndex);
                this.strings.add("");
            } else {
                JvmProtoBuf.StringTableTypes.Record.Builder builder = record2;
                Intrinsics.checkExpressionValueIsNotNull(builder, "record");
                builder.setOperation(JvmProtoBuf.StringTableTypes.Record.Operation.DESC_TO_CLASS_ID);
                this.strings.add('L' + StringsKt.replace$default(className2, '.', '$', false, 4, null) + ';');
            }
        }
        this.records.add(record2);
        Map map2 = this.map;
        Integer n4 = index2;
        map2.put(className2, n4);
        return index2;
    }

    /*
     * WARNING - void declaration
     */
    public final void serializeTo(@NotNull OutputStream output) {
        Collection<JvmProtoBuf.StringTableTypes.Record> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        JvmProtoBuf.StringTableTypes.Builder builder;
        Intrinsics.checkParameterIsNotNull(output, "output");
        JvmProtoBuf.StringTableTypes.Builder $receiver = builder = JvmProtoBuf.StringTableTypes.newBuilder();
        Iterable iterable = this.records;
        JvmProtoBuf.StringTableTypes.Builder builder2 = $receiver;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JvmProtoBuf.StringTableTypes.Record.Builder builder3 = (JvmProtoBuf.StringTableTypes.Record.Builder)item$iv$iv;
            collection = destination$iv$iv;
            JvmProtoBuf.StringTableTypes.Record record2 = it.build();
            collection.add(record2);
        }
        collection = (List)destination$iv$iv;
        builder2.addAllRecord((Iterable<? extends JvmProtoBuf.StringTableTypes.Record>)collection);
        $receiver.addAllLocalName((Iterable<? extends Integer>)this.localNames);
        $receiver.build().writeDelimitedTo(output);
    }

    /*
     * WARNING - void declaration
     */
    public JvmStringTable(@Nullable JvmNameResolver nameResolver) {
        this.strings = new ArrayList();
        this.records = new ArrayList();
        this.map = new HashMap();
        this.localNames = new LinkedHashSet();
        if (nameResolver != null) {
            Serializable serializable;
            void $receiver$iv2;
            CollectionsKt.addAll((Collection)this.strings, nameResolver.getStrings());
            Iterable iterable = nameResolver.getRecords();
            Collection destination$iv = this.records;
            for (Object item$iv : $receiver$iv2) {
                void p1;
                serializable = (JvmProtoBuf.StringTableTypes.Record)item$iv;
                Collection collection = destination$iv;
                JvmProtoBuf.StringTableTypes.Record.Builder builder = p1.toBuilder();
                collection.add(builder);
            }
            int $receiver$iv2 = 0;
            int n = ((Collection)this.strings).size();
            while ($receiver$iv2 < n) {
                void index2;
                Map map2 = this.map;
                String string2 = nameResolver.getString((int)index2);
                serializable = Integer.valueOf((int)index2);
                map2.put(string2, serializable);
                ++index2;
            }
            this.localNames.addAll((Collection<Integer>)nameResolver.getTypes().getLocalNameList());
        }
    }

    public /* synthetic */ JvmStringTable(JvmNameResolver jvmNameResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jvmNameResolver = null;
        }
        this(jvmNameResolver);
    }

    public JvmStringTable() {
        this(null, 1, null);
    }
}

