/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import org.jetbrains.annotations.NotNull;

public final class Name
implements Comparable<Name> {
    @NotNull
    private final String name;
    private final boolean special;

    private Name(@NotNull String name2, boolean special) {
        this.name = name2;
        this.special = special;
    }

    @NotNull
    public String asString() {
        return this.name;
    }

    @NotNull
    public String getIdentifier() {
        if (this.special) {
            throw new IllegalStateException("not identifier: " + this);
        }
        return this.asString();
    }

    public boolean isSpecial() {
        return this.special;
    }

    @Override
    public int compareTo(Name that) {
        return this.name.compareTo(that.name);
    }

    @NotNull
    public static Name identifier(@NotNull String name2) {
        return new Name(name2, false);
    }

    public static boolean isValidIdentifier(@NotNull String name2) {
        if (name2.isEmpty() || name2.startsWith("<")) {
            return false;
        }
        for (int i = 0; i < name2.length(); ++i) {
            char ch = name2.charAt(i);
            if (ch != '.' && ch != '/' && ch != '\\') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Name special(@NotNull String name2) {
        if (!name2.startsWith("<")) {
            throw new IllegalArgumentException("special name must start with '<': " + name2);
        }
        return new Name(name2, true);
    }

    @NotNull
    public static Name guessByFirstCharacter(@NotNull String name2) {
        if (name2.startsWith("<")) {
            return Name.special(name2);
        }
        return Name.identifier(name2);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name name1 = (Name)o;
        if (this.special != name1.special) {
            return false;
        }
        return this.name.equals(name1.name);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + (this.special ? 1 : 0);
        return result2;
    }
}

