/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.debugText;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.StubElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextBuildingVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ca\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u001b\u0010\b\u001a\u0017\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\b\fJ1\u0010\r\u001a\u0004\u0018\u00010\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u0011\"\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J0\u0010\u0014\u001a\u0004\u0018\u00010\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0015\u001a\u00020\u00022\b\b\u0002\u0010\u0016\u001a\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u0002J!\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010 J!\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020#2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020'2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010(J!\u0010)\u001a\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020+2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010,J!\u0010-\u001a\u0004\u0018\u00010\u00022\u0006\u0010.\u001a\u00020/2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00100J!\u00101\u001a\u0004\u0018\u00010\u00022\u0006\u00102\u001a\u0002032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00104J!\u00105\u001a\u0004\u0018\u00010\u00022\u0006\u00106\u001a\u0002072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00108J!\u00109\u001a\u0004\u0018\u00010\u00022\u0006\u0010:\u001a\u00020;2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010<J!\u0010=\u001a\u0004\u0018\u00010\u00022\u0006\u0010>\u001a\u00020?2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010@J!\u0010A\u001a\u0004\u0018\u00010\u00022\u0006\u0010B\u001a\u00020C2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010DJ!\u0010E\u001a\u0004\u0018\u00010\u00022\u0006\u0010F\u001a\u00020G2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010HJ!\u0010I\u001a\u0004\u0018\u00010\u00022\u0006\u0010J\u001a\u00020K2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010LJ!\u0010M\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010NJ!\u0010O\u001a\u0004\u0018\u00010\u00022\u0006\u0010P\u001a\u00020Q2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010RJ!\u0010S\u001a\u0004\u0018\u00010\u00022\u0006\u0010J\u001a\u00020T2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010UJ!\u0010V\u001a\u0004\u0018\u00010\u00022\u0006\u0010W\u001a\u00020X2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010YJ!\u0010Z\u001a\u0004\u0018\u00010\u00022\u0006\u0010[\u001a\u00020\\2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010]J!\u0010^\u001a\u0004\u0018\u00010\u00022\u0006\u0010_\u001a\u00020`2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010aJ!\u0010b\u001a\u0004\u0018\u00010\u00022\u0006\u0010c\u001a\u00020d2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010eJ!\u0010f\u001a\u0004\u0018\u00010\u00022\u0006\u0010J\u001a\u00020g2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010hJ!\u0010i\u001a\u0004\u0018\u00010\u00022\u0006\u0010j\u001a\u00020k2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010lJ!\u0010m\u001a\u0004\u0018\u00010\u00022\u0006\u0010n\u001a\u00020o2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010pJ!\u0010q\u001a\u0004\u0018\u00010\u00022\u0006\u00102\u001a\u00020r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010sJ!\u0010t\u001a\u0004\u0018\u00010\u00022\u0006\u0010J\u001a\u00020u2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010vJ!\u0010w\u001a\u0004\u0018\u00010\u00022\u0006\u0010x\u001a\u00020y2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010zJ!\u0010{\u001a\u0004\u0018\u00010\u00022\u0006\u0010|\u001a\u00020}2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010~J$\u0010\u007f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0082\u0001J$\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u00022\u0007\u0010J\u001a\u00030\u0084\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0085\u0001J$\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u00022\u0007\u0010c\u001a\u00030\u0087\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0088\u0001J$\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u00022\u0007\u0010J\u001a\u00030\u008a\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u008b\u0001J%\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u00022\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u008f\u0001J%\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u00022\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0093\u0001J%\u0010\u0094\u0001\u001a\u0004\u0018\u00010\u00022\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0097\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0098\u0001"}, d2={"Lorg/jetbrains/kotlin/psi/debugText/DebugTextBuildingVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "buildText", "body", "Lkotlin/Function1;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lkotlin/ExtensionFunctionType;", "render", "element", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "relevantChildren", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElementImplStub;[Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/lang/String;", "renderChildren", "separator", "prefix", "postfix", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotation;", "data", "(Lorg/jetbrains/kotlin/psi/KtAnnotation;Lkotlin/Unit;)Ljava/lang/String;", "visitAnnotationEntry", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lkotlin/Unit;)Ljava/lang/String;", "visitAnonymousInitializer", "initializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "(Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;Lkotlin/Unit;)Ljava/lang/String;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Ljava/lang/String;", "visitClassBody", "classBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "(Lorg/jetbrains/kotlin/psi/KtClassBody;Lkotlin/Unit;)Ljava/lang/String;", "visitConstructorCalleeExpression", "constructorCalleeExpression", "Lorg/jetbrains/kotlin/psi/KtConstructorCalleeExpression;", "(Lorg/jetbrains/kotlin/psi/KtConstructorCalleeExpression;Lkotlin/Unit;)Ljava/lang/String;", "visitDotQualifiedExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "(Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;Lkotlin/Unit;)Ljava/lang/String;", "visitDynamicType", "type", "Lorg/jetbrains/kotlin/psi/KtDynamicType;", "(Lorg/jetbrains/kotlin/psi/KtDynamicType;Lkotlin/Unit;)Ljava/lang/String;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "(Lorg/jetbrains/kotlin/psi/KtEnumEntry;Lkotlin/Unit;)Ljava/lang/String;", "visitFunctionType", "functionType", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "(Lorg/jetbrains/kotlin/psi/KtFunctionType;Lkotlin/Unit;)Ljava/lang/String;", "visitImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "(Lorg/jetbrains/kotlin/psi/KtImportDirective;Lkotlin/Unit;)Ljava/lang/String;", "visitImportList", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "(Lorg/jetbrains/kotlin/psi/KtImportList;Lkotlin/Unit;)Ljava/lang/String;", "visitInitializerList", "list", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "(Lorg/jetbrains/kotlin/psi/KtInitializerList;Lkotlin/Unit;)Ljava/lang/String;", "visitKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Ljava/lang/String;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/Unit;)Ljava/lang/String;", "visitModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "(Lorg/jetbrains/kotlin/psi/KtModifierList;Lkotlin/Unit;)Ljava/lang/String;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Ljava/lang/String;", "visitNullableType", "nullableType", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "(Lorg/jetbrains/kotlin/psi/KtNullableType;Lkotlin/Unit;)Ljava/lang/String;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Ljava/lang/String;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Ljava/lang/String;", "visitParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "(Lorg/jetbrains/kotlin/psi/KtParameterList;Lkotlin/Unit;)Ljava/lang/String;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Ljava/lang/String;", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;Lkotlin/Unit;)Ljava/lang/String;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lkotlin/Unit;)Ljava/lang/String;", "visitSuperTypeList", "Lorg/jetbrains/kotlin/psi/KtSuperTypeList;", "(Lorg/jetbrains/kotlin/psi/KtSuperTypeList;Lkotlin/Unit;)Ljava/lang/String;", "visitSuperTypeListEntry", "specifier", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "(Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeArgumentList", "typeArgumentList", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "(Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeConstraint", "constraint", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "(Lorg/jetbrains/kotlin/psi/KtTypeConstraint;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeConstraintList", "Lorg/jetbrains/kotlin/psi/KtTypeConstraintList;", "(Lorg/jetbrains/kotlin/psi/KtTypeConstraintList;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeParameterList", "Lorg/jetbrains/kotlin/psi/KtTypeParameterList;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameterList;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeProjection", "typeProjection", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "(Lorg/jetbrains/kotlin/psi/KtTypeProjection;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeReference", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lkotlin/Unit;)Ljava/lang/String;", "visitUserType", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "(Lorg/jetbrains/kotlin/psi/KtUserType;Lkotlin/Unit;)Ljava/lang/String;", "frontend"})
final class DebugTextBuildingVisitor
extends KtVisitor<String, Unit> {
    private static final Logger LOG;
    public static final DebugTextBuildingVisitor INSTANCE;

    @Override
    @Nullable
    public String visitKtFile(@NotNull KtFile file2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        return "STUB file: " + file2.getName();
    }

    @Override
    @Nullable
    public String visitKtElement(@NotNull KtElement element, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        if (element instanceof KtElementImplStub) {
            LOG.error("getDebugText() is not defined for " + element.getClass());
        }
        return element.getText();
    }

    @Override
    @Nullable
    public String visitImportDirective(@NotNull KtImportDirective importDirective, @Nullable Unit data2) {
        String string2;
        Intrinsics.checkParameterIsNotNull(importDirective, "importDirective");
        ImportPath importPath = importDirective.getImportPath();
        if (importPath == null) {
            return "import <invalid>";
        }
        Intrinsics.checkExpressionValueIsNotNull(importPath, "importDirective.importPa\u2026return \"import <invalid>\"");
        ImportPath importPath2 = importPath;
        if (importPath2.hasAlias()) {
            StringBuilder stringBuilder = new StringBuilder().append(" as ");
            Name name2 = importPath2.getAlias();
            if (name2 == null) {
                Intrinsics.throwNpe();
            }
            string2 = stringBuilder.append(name2.asString()).toString();
        } else {
            string2 = "";
        }
        String aliasStr = string2;
        return "import " + importPath2.getPathStr() + aliasStr;
    }

    @Override
    @Nullable
    public String visitImportList(@NotNull KtImportList importList, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(importList, "importList");
        return DebugTextBuildingVisitor.renderChildren$default(this, importList, "\n", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(annotationEntry, "annotationEntry");
        return this.render(annotationEntry, annotationEntry.getCalleeExpression(), annotationEntry.getTypeArgumentList());
    }

    @Override
    @Nullable
    public String visitTypeReference(@NotNull KtTypeReference typeReference, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        return DebugTextBuildingVisitor.renderChildren$default(this, typeReference, " ", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitTypeArgumentList(@NotNull KtTypeArgumentList typeArgumentList, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(typeArgumentList, "typeArgumentList");
        return this.renderChildren(typeArgumentList, ", ", "<", ">");
    }

    @Override
    @Nullable
    public String visitTypeConstraintList(@NotNull KtTypeConstraintList list2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(list2, "list");
        return this.renderChildren(list2, ", ", "where ", "");
    }

    @Override
    @Nullable
    public String visitUserType(@NotNull KtUserType userType, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(userType, "userType");
        return this.render(userType, userType.getQualifier(), userType.getReferenceExpression(), userType.getTypeArgumentList());
    }

    @Override
    @Nullable
    public String visitDynamicType(@NotNull KtDynamicType type2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return "dynamic";
    }

    @Override
    @Nullable
    public String visitAnnotation(@NotNull KtAnnotation annotation2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        return this.renderChildren(annotation2, " ", "[", "]");
    }

    @Override
    @Nullable
    public String visitConstructorCalleeExpression(@NotNull KtConstructorCalleeExpression constructorCalleeExpression, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(constructorCalleeExpression, "constructorCalleeExpression");
        return this.render(constructorCalleeExpression, constructorCalleeExpression.getConstructorReferenceExpression());
    }

    @Override
    @Nullable
    public String visitSuperTypeListEntry(@NotNull KtSuperTypeListEntry specifier, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(specifier, "specifier");
        return this.render(specifier, specifier.getTypeReference());
    }

    @Override
    @Nullable
    public String visitSuperTypeList(@NotNull KtSuperTypeList list2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(list2, "list");
        return DebugTextBuildingVisitor.renderChildren$default(this, list2, ", ", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitTypeParameterList(@NotNull KtTypeParameterList list2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(list2, "list");
        return this.renderChildren(list2, ", ", "<", ">");
    }

    @Override
    @Nullable
    public String visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        return DebugTextBuildingVisitor.renderChildren$default(this, expression2, ".", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitInitializerList(@NotNull KtInitializerList list2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(list2, "list");
        return DebugTextBuildingVisitor.renderChildren$default(this, list2, ", ", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitParameterList(@NotNull KtParameterList list2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(list2, "list");
        return this.renderChildren(list2, ", ", "(", ")");
    }

    @Override
    @Nullable
    public String visitEnumEntry(@NotNull KtEnumEntry enumEntry, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(enumEntry){
            final /* synthetic */ KtEnumEntry $enumEntry;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$enumEntry.getModifierList(), null, " ", 2, null);
                $receiver.append("enum entry ");
                DebugTextUtilKt.appendInn$default($receiver, this.$enumEntry.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$enumEntry.getInitializerList(), " : ", null, 4, null);
            }
            {
                this.$enumEntry = ktEnumEntry;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitFunctionType(@NotNull KtFunctionType functionType, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(functionType, "functionType");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(functionType){
            final /* synthetic */ KtFunctionType $functionType;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                DebugTextUtilKt.appendInn$default($receiver, this.$functionType.getReceiverTypeReference(), null, ".", 2, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$functionType.getParameterList(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$functionType.getReturnTypeReference(), " -> ", null, 4, null);
            }
            {
                this.$functionType = ktFunctionType;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitTypeParameter(@NotNull KtTypeParameter parameter, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(parameter){
            final /* synthetic */ KtTypeParameter $parameter;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                DebugTextUtilKt.appendInn$default($receiver, this.$parameter.getModifierList(), null, " ", 2, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$parameter.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$parameter.getExtendsBound(), " : ", null, 4, null);
            }
            {
                this.$parameter = ktTypeParameter;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitTypeProjection(@NotNull KtTypeProjection typeProjection, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(typeProjection){
            final /* synthetic */ KtTypeProjection $typeProjection;

            public final void invoke(@NotNull StringBuilder $receiver) {
                KtSingleValueToken token;
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                KtProjectionKind ktProjectionKind = this.$typeProjection.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktProjectionKind), "typeProjection.projectionKind");
                KtSingleValueToken ktSingleValueToken = token = ktProjectionKind.getToken();
                DebugTextUtilKt.appendInn$default($receiver, ktSingleValueToken != null ? ktSingleValueToken.getValue() : null, null, null, 6, null);
                KtTypeReference typeReference = this.$typeProjection.getTypeReference();
                if (token != null && typeReference != null) {
                    $receiver.append(" ");
                }
                DebugTextUtilKt.appendInn$default($receiver, typeReference, null, null, 6, null);
            }
            {
                this.$typeProjection = ktTypeProjection;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitModifierList(@NotNull KtModifierList list2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(list2, "list");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(list2){
            final /* synthetic */ KtModifierList $list;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                boolean first2 = true;
                for (KtModifierKeywordToken modifierKeywordToken : KtTokens.MODIFIER_KEYWORDS_ARRAY) {
                    if (!this.$list.hasModifier(modifierKeywordToken)) continue;
                    if (!first2) {
                        $receiver.append(" ");
                    }
                    KtModifierKeywordToken ktModifierKeywordToken = modifierKeywordToken;
                    Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "modifierKeywordToken");
                    $receiver.append(ktModifierKeywordToken.getValue());
                    first2 = false;
                }
            }
            {
                this.$list = ktModifierList;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        return expression2.getReferencedName();
    }

    @Override
    @Nullable
    public String visitNullableType(@NotNull KtNullableType nullableType, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(nullableType, "nullableType");
        return this.renderChildren(nullableType, "", "", "?");
    }

    @Override
    @Nullable
    public String visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(initializer2, "initializer");
        KtDeclaration containingDeclaration = KtStubbedPsiUtil.getContainingDeclaration(initializer2);
        StringBuilder stringBuilder = new StringBuilder().append("initializer in ");
        Object object = containingDeclaration;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder.append((String)object).toString();
    }

    @Override
    @Nullable
    public String visitClassBody(@NotNull KtClassBody classBody, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(classBody, "classBody");
        KtDeclaration containingDeclaration = KtStubbedPsiUtil.getContainingDeclaration(classBody);
        StringBuilder stringBuilder = new StringBuilder().append("class body for ");
        Object object = containingDeclaration;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder.append((String)object).toString();
    }

    @Override
    @Nullable
    public String visitPropertyAccessor(@NotNull KtPropertyAccessor accessor, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(accessor, "accessor");
        KtProperty containingProperty = KtStubbedPsiUtil.getContainingDeclaration(accessor, KtProperty.class);
        String what = accessor.isGetter() ? "getter" : "setter";
        StringBuilder stringBuilder = new StringBuilder().append(what).append(" for ");
        Object object = containingProperty;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder.append((String)object).toString();
    }

    @Override
    @Nullable
    public String visitClass(@NotNull KtClass klass2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(klass2, "klass");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(klass2){
            final /* synthetic */ KtClass $klass;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getModifierList(), null, " ", 2, null);
                $receiver.append("class ");
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getTypeParameterList(), null, null, 6, null);
                DebugTextUtilKt.access$appendInn($receiver, this.$klass.getPrimaryConstructorModifierList(), " ", " ");
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getPrimaryConstructorParameterList(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$klass.getSuperTypeList(), " : ", null, 4, null);
            }
            {
                this.$klass = ktClass;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitNamedFunction(@NotNull KtNamedFunction function2, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(function2){
            final /* synthetic */ KtNamedFunction $function;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getModifierList(), null, " ", 2, null);
                $receiver.append("fun ");
                KtTypeParameterList typeParameterList = this.$function.getTypeParameterList();
                if (this.$function.hasTypeParameterListBeforeFunctionName()) {
                    DebugTextUtilKt.appendInn$default($receiver, typeParameterList, null, " ", 2, null);
                }
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getReceiverTypeReference(), null, ".", 2, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getNameAsName(), null, null, 6, null);
                if (!this.$function.hasTypeParameterListBeforeFunctionName()) {
                    DebugTextUtilKt.appendInn$default($receiver, typeParameterList, null, null, 6, null);
                }
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getValueParameterList(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getTypeReference(), ": ", null, 4, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$function.getTypeConstraintList(), " ", null, 4, null);
            }
            {
                this.$function = ktNamedFunction;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(declaration){
            final /* synthetic */ KtObjectDeclaration $declaration;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$declaration.getModifierList(), null, " ", 2, null);
                $receiver.append("object ");
                DebugTextUtilKt.appendInn$default($receiver, this.$declaration.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$declaration.getSuperTypeList(), " : ", null, 4, null);
            }
            {
                this.$declaration = ktObjectDeclaration;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitParameter(@NotNull KtParameter parameter, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(parameter){
            final /* synthetic */ KtParameter $parameter;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                if (this.$parameter.hasValOrVar()) {
                    if (this.$parameter.isMutable()) {
                        $receiver.append("var ");
                    } else {
                        $receiver.append("val ");
                    }
                }
                Name name2 = this.$parameter.getNameAsName();
                DebugTextUtilKt.appendInn$default($receiver, name2, null, null, 6, null);
                KtTypeReference typeReference = this.$parameter.getTypeReference();
                if (typeReference != null && name2 != null) {
                    $receiver.append(": ");
                }
                DebugTextUtilKt.appendInn$default($receiver, typeReference, null, null, 6, null);
            }
            {
                this.$parameter = ktParameter;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitProperty(@NotNull KtProperty property, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(property){
            final /* synthetic */ KtProperty $property;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                $receiver.append("STUB: ");
                DebugTextUtilKt.appendInn$default($receiver, this.$property.getModifierList(), null, " ", 2, null);
                $receiver.append(this.$property.isVar() ? "var " : "val ");
                DebugTextUtilKt.appendInn$default($receiver, this.$property.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$property.getTypeReference(), ": ", null, 4, null);
            }
            {
                this.$property = ktProperty;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public String visitTypeConstraint(@NotNull KtTypeConstraint constraint, @Nullable Unit data2) {
        Intrinsics.checkParameterIsNotNull(constraint, "constraint");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(constraint){
            final /* synthetic */ KtTypeConstraint $constraint;

            public final void invoke(@NotNull StringBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                DebugTextUtilKt.appendInn$default($receiver, this.$constraint.getSubjectTypeParameterName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($receiver, this.$constraint.getBoundTypeReference(), " : ", null, 4, null);
            }
            {
                this.$constraint = ktTypeConstraint;
                super(1);
            }
        });
    }

    @Nullable
    public final String buildText(@NotNull Function1<? super StringBuilder, Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        StringBuilder sb = new StringBuilder();
        body.invoke(sb);
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String renderChildren(@NotNull KtElementImplStub<?> element, @NotNull String separator, @NotNull String prefix, @NotNull String postfix) {
        String childrenTexts;
        String string2;
        Object object;
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(separator, "separator");
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        Intrinsics.checkParameterIsNotNull(postfix, "postfix");
        Object t = element.getStub();
        if (t != null && (t = t.getChildrenStubs()) != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)t;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string3;
                StubElement it;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                StubElement stubElement = it = (StubElement)element$iv$iv;
                Object object2 = stubElement != null ? stubElement.getPsi() : null;
                if (!(object2 instanceof KtElement)) {
                    object2 = null;
                }
                KtElement ktElement = (KtElement)object2;
                String string4 = ktElement != null ? DebugTextUtilKt.getDebugText(ktElement) : null;
                if (string4 == null) continue;
                String it$iv$iv = string3 = string4;
                destination$iv$iv.add(it$iv$iv);
            }
            object = (List)destination$iv$iv;
        } else {
            object = null;
        }
        if ((string2 = (childrenTexts = object)) == null || (string2 = CollectionsKt.joinToString$default((Iterable)((Object)string2), separator, prefix, postfix, 0, null, null, 56, null)) == null) {
            string2 = element.getText();
        }
        return string2;
    }

    @Nullable
    public static /* synthetic */ String renderChildren$default(DebugTextBuildingVisitor debugTextBuildingVisitor, KtElementImplStub ktElementImplStub, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        return debugTextBuildingVisitor.renderChildren(ktElementImplStub, string2, string3, string4);
    }

    @Nullable
    public final String render(@NotNull KtElementImplStub<?> element, KtElement ... relevantChildren) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(relevantChildren, "relevantChildren");
        if (element.getStub() == null) {
            return element.getText();
        }
        return CollectionsKt.joinToString$default(ArraysKt.filterNotNull(relevantChildren), "", "", "", 0, null, render.1.INSTANCE, 24, null);
    }

    private DebugTextBuildingVisitor() {
    }

    static {
        DebugTextBuildingVisitor debugTextBuildingVisitor;
        INSTANCE = debugTextBuildingVisitor = new DebugTextBuildingVisitor();
        Logger logger = Logger.getInstance(debugTextBuildingVisitor.getClass());
        Intrinsics.checkExpressionValueIsNotNull(logger, "Logger.getInstance(this::class.java)");
        LOG = logger;
    }
}

