/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020 H\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "", "()V", "createFileStub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "deserializeFileStub", "dataStream", "Lcom/intellij/psi/stubs/StubInputStream;", "indexAnnotation", "", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinAnnotationEntryStub;", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "indexClass", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "indexFile", "indexFunction", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFunctionStub;", "indexObject", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "indexParameter", "Lorg/jetbrains/kotlin/psi/stubs/KotlinParameterStub;", "indexProperty", "Lorg/jetbrains/kotlin/psi/stubs/KotlinPropertyStub;", "indexScript", "Lorg/jetbrains/kotlin/psi/stubs/KotlinScriptStub;", "indexTypeAlias", "Lorg/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "serializeFileStub", "Lcom/intellij/psi/stubs/StubOutputStream;", "Companion", "psi"})
public class StubIndexService {
    private static final StubIndexService NO_INDEX;
    public static final Companion Companion;

    public void indexFile(@NotNull KotlinFileStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexClass(@NotNull KotlinClassStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexFunction(@NotNull KotlinFunctionStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexTypeAlias(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexObject(@NotNull KotlinObjectStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexProperty(@NotNull KotlinPropertyStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexParameter(@NotNull KotlinParameterStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexAnnotation(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    public void indexScript(@NotNull KotlinScriptStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(sink, "sink");
    }

    @NotNull
    public KotlinFileStub createFileStub(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        String string2 = file2.getPackageFqNameByTree().asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "file.packageFqNameByTree.asString()");
        return new KotlinFileStubImpl(file2, string2, file2.isScriptByTree());
    }

    public void serializeFileStub(@NotNull KotlinFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(dataStream, "dataStream");
        dataStream.writeName(stub.getPackageFqName().asString());
        dataStream.writeBoolean(stub.isScript());
    }

    @NotNull
    public KotlinFileStub deserializeFileStub(@NotNull StubInputStream dataStream) throws IOException {
        Intrinsics.checkParameterIsNotNull(dataStream, "dataStream");
        StringRef packageFqNameAsString = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        StringRef stringRef = packageFqNameAsString;
        if (stringRef == null) {
            Intrinsics.throwNpe();
        }
        return new KotlinFileStubImpl(null, stringRef, isScript);
    }

    protected StubIndexService() {
    }

    static {
        Companion = new Companion(null);
        NO_INDEX = new StubIndexService();
    }

    @JvmStatic
    @NotNull
    public static final StubIndexService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService$Companion;", "", "()V", "NO_INDEX", "Lorg/jetbrains/kotlin/psi/stubs/elements/StubIndexService;", "getInstance", "psi"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final StubIndexService getInstance() {
            StubIndexService stubIndexService = ServiceManager.getService(StubIndexService.class);
            if (stubIndexService == null) {
                stubIndexService = NO_INDEX;
            }
            return stubIndexService;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

