/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt$WhenMappings;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0007\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u000b*\u00020\u0007\u001a\u0014\u0010\r\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"JAVA_DEPRECATED", "Lorg/jetbrains/kotlin/name/FqName;", "createDeprecationDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "deprecation", "Lorg/jetbrains/kotlin/resolve/Deprecation;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecatedByAnnotationReplaceWithExpression", "", "deprecatedByOverriddenMessage", "wrapInTypeAliasExpansion", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "frontend"})
public final class DeprecationUtilKt {
    private static final FqName JAVA_DEPRECATED = new FqName("java.lang.Deprecated");

    @Nullable
    public static final String deprecatedByOverriddenMessage(@NotNull Deprecation $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Deprecation deprecation = $receiver;
        if (!(deprecation instanceof DeprecatedByOverridden)) {
            deprecation = null;
        }
        DeprecatedByOverridden deprecatedByOverridden = (DeprecatedByOverridden)deprecation;
        return deprecatedByOverridden != null ? deprecatedByOverridden.additionalMessage$frontend() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String deprecatedByAnnotationReplaceWithExpression(@NotNull Deprecation $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Deprecation deprecation = $receiver;
        if (!(deprecation instanceof DeprecatedByAnnotation)) {
            deprecation = null;
        }
        DeprecatedByAnnotation deprecatedByAnnotation = (DeprecatedByAnnotation)deprecation;
        Object object = deprecatedByAnnotation;
        if (deprecatedByAnnotation == null) return null;
        AnnotationDescriptor annotationDescriptor = ((DeprecatedByAnnotation)object).getAnnotation();
        object = annotationDescriptor;
        if (annotationDescriptor == null) return null;
        Object annotation2 = object;
        AnnotationValue annotationValue = AnnotationUtilKt.argumentValue((AnnotationDescriptor)annotation2, "replaceWith");
        Object object2 = annotationValue;
        if (annotationValue == null) return null;
        Object $receiver$iv = object2;
        AnnotationValue annotationValue2 = $receiver$iv;
        if (!(annotationValue2 instanceof AnnotationValue)) {
            annotationValue2 = null;
        }
        AnnotationValue annotationValue3 = annotationValue2;
        object2 = annotationValue3;
        if (annotationValue3 == null) return null;
        AnnotationDescriptor annotationDescriptor2 = (AnnotationDescriptor)((ConstantValue)object2).getValue();
        object2 = annotationDescriptor2;
        if (annotationDescriptor2 == null) return null;
        Object replaceWithAnnotation2 = object2;
        StringValue stringValue = AnnotationUtilKt.argumentValue((AnnotationDescriptor)replaceWithAnnotation2, "expression");
        StringValue stringValue2 = stringValue;
        if (stringValue == null) return null;
        $receiver$iv = stringValue2;
        Object object3 = $receiver$iv;
        if (!(object3 instanceof StringValue)) {
            object3 = null;
        }
        StringValue stringValue3 = (StringValue)object3;
        stringValue2 = stringValue3;
        if (stringValue3 == null) return null;
        String string2 = (String)stringValue2.getValue();
        return string2;
    }

    private static final Deprecation wrapInTypeAliasExpansion(@NotNull Deprecation $receiver, TypeAliasDescriptor typeAliasDescriptor) {
        return $receiver instanceof DeprecatedByAnnotation ? (Deprecation)new DeprecatedTypealiasByAnnotation(typeAliasDescriptor, (DeprecatedByAnnotation)$receiver) : $receiver;
    }

    @NotNull
    public static final Diagnostic createDeprecationDiagnostic(@NotNull PsiElement element, @NotNull Deprecation deprecation, @NotNull LanguageVersionSettings languageVersionSettings) {
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic;
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(deprecation, "deprecation");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        DeclarationDescriptor declarationDescriptor = deprecation.getTarget().getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "deprecation.target.original");
        DeclarationDescriptor targetOriginal = declarationDescriptor;
        Deprecation deprecation2 = deprecation;
        if (deprecation2 instanceof DeprecatedByVersionRequirement) {
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<LanguageVersion, String>> diagnosticFactory3;
            switch (DeprecationUtilKt$WhenMappings.$EnumSwitchMapping$0[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<LanguageVersion, String>> factory2 = diagnosticFactory3;
            parametrizedDiagnostic = factory2.on(element, targetOriginal, ((DeprecatedByVersionRequirement)deprecation).getVersionRequirement().getVersion(), TuplesKt.to(languageVersionSettings.getLanguageVersion(), deprecation.getMessage()));
        } else if (deprecation2 instanceof DeprecatedTypealiasByAnnotation) {
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> diagnosticFactory3;
            switch (DeprecationUtilKt$WhenMappings.$EnumSwitchMapping$1[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> factory3 = diagnosticFactory3;
            TypeAliasDescriptor typeAliasDescriptor = ((DeprecatedTypealiasByAnnotation)deprecation).getTypeAliasTarget().getOriginal();
            DeclarationDescriptor declarationDescriptor2 = ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getTarget().getOriginal();
            String string2 = ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getMessage();
            if (string2 == null) {
                string2 = "";
            }
            parametrizedDiagnostic = factory3.on(element, typeAliasDescriptor, declarationDescriptor2, string2);
        } else {
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> diagnosticFactory2;
            switch (DeprecationUtilKt$WhenMappings.$EnumSwitchMapping$2[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory2 = Errors.DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory2 = Errors.DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> factory4 = diagnosticFactory2;
            String string3 = deprecation.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            parametrizedDiagnostic = factory4.on(element, targetOriginal, string3);
        }
        Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "when (deprecation) {\n   \u2026ge ?: \"\")\n        }\n    }");
        return parametrizedDiagnostic;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getJAVA_DEPRECATED$p() {
        return JAVA_DEPRECATED;
    }

    @NotNull
    public static final /* synthetic */ Deprecation access$wrapInTypeAliasExpansion(@NotNull Deprecation $receiver, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        return DeprecationUtilKt.wrapInTypeAliasExpansion($receiver, typeAliasDescriptor);
    }
}

