/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeUtils;

public class PossiblyBareType {
    private final KotlinType actualType;
    private final TypeConstructor bareTypeConstructor;
    private final boolean nullable;

    @NotNull
    public static PossiblyBareType bare(@NotNull TypeConstructor bareTypeConstructor, boolean nullable2) {
        return new PossiblyBareType(null, bareTypeConstructor, nullable2);
    }

    @NotNull
    public static PossiblyBareType type(@NotNull KotlinType actualType) {
        return new PossiblyBareType(actualType, null, false);
    }

    private PossiblyBareType(@Nullable KotlinType actualType, @Nullable TypeConstructor bareTypeConstructor, boolean nullable2) {
        this.actualType = actualType;
        this.bareTypeConstructor = bareTypeConstructor;
        this.nullable = nullable2;
    }

    public boolean isBare() {
        return this.actualType == null;
    }

    @NotNull
    public KotlinType getActualType() {
        return this.actualType;
    }

    @NotNull
    public TypeConstructor getBareTypeConstructor() {
        return this.bareTypeConstructor;
    }

    private boolean isBareTypeNullable() {
        return this.nullable;
    }

    public boolean isNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable();
        }
        return this.getActualType().isMarkedNullable();
    }

    public PossiblyBareType makeNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable() ? this : PossiblyBareType.bare(this.getBareTypeConstructor(), true);
        }
        return PossiblyBareType.type(TypeUtils.makeNullable(this.getActualType()));
    }

    @NotNull
    public TypeReconstructionResult reconstruct(@NotNull KotlinType subjectType) {
        if (!this.isBare()) {
            return new TypeReconstructionResult(this.getActualType(), true);
        }
        TypeReconstructionResult reconstructionResult = CastDiagnosticsUtil.findStaticallyKnownSubtype(TypeUtils.makeNotNullable(subjectType), this.getBareTypeConstructor());
        KotlinType type2 = reconstructionResult.getResultingType();
        if (type2 == null) {
            return reconstructionResult;
        }
        KotlinType resultingType = TypeUtils.makeNullableAsSpecified(type2, this.isBareTypeNullable());
        return new TypeReconstructionResult(resultingType, reconstructionResult.isAllArgumentsInferred());
    }

    public String toString() {
        return this.isBare() ? "bare " + this.bareTypeConstructor + (this.isBareTypeNullable() ? "?" : "") : this.getActualType().toString();
    }
}

