/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.PostponeArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.components.ResolutionPartsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.SamConversionDescription;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0001H\u0002\u001a\u001c\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a&\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"getExpectedTypeWithSAMConversion", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "candidateParameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "isSubtypeOfFunctionType", "", "prepareExpectedType", "resolveKotlinArgument", "", "isReceiver", "resolution"})
public final class ResolutionPartsKt {
    private static final void resolveKotlinArgument(@NotNull KotlinResolutionCandidate $receiver, KotlinCallArgument argument, ParameterDescriptor candidateParameter, boolean isReceiver) {
        UnwrappedType unwrappedType;
        ParameterDescriptor parameterDescriptor = candidateParameter;
        if (parameterDescriptor != null) {
            ParameterDescriptor parameterDescriptor2;
            ParameterDescriptor it = parameterDescriptor2 = parameterDescriptor;
            unwrappedType = ResolutionPartsKt.prepareExpectedType($receiver, argument, candidateParameter);
        } else {
            unwrappedType = null;
        }
        UnwrappedType expectedType = unwrappedType;
        $receiver.addResolvedKtPrimitive(PostponeArgumentsChecksKt.resolveKtPrimitive($receiver.getCsBuilder$resolution(), argument, expectedType, $receiver, isReceiver));
    }

    private static final UnwrappedType prepareExpectedType(@NotNull KotlinResolutionCandidate $receiver, KotlinCallArgument argument, ParameterDescriptor candidateParameter) {
        Object object;
        UnwrappedType argumentType;
        UnwrappedType unwrappedType = ResolutionPartsKt.getExpectedTypeWithSAMConversion($receiver, argument, candidateParameter);
        if (unwrappedType == null) {
            unwrappedType = argumentType = ArgumentsUtilsKt.getExpectedType(argument, candidateParameter, $receiver.getCallComponents().getLanguageVersionSettings());
        }
        if ((object = $receiver.getKnownTypeParametersResultingSubstitutor()) == null || (object = InferenceUtilsKt.substitute((TypeSubstitutor)object, argumentType)) == null) {
            object = argumentType;
        }
        Object resultType = object;
        return $receiver.getResolvedCall().getSubstitutor().substituteKeepAnnotations((UnwrappedType)resultType);
    }

    private static final UnwrappedType getExpectedTypeWithSAMConversion(@NotNull KotlinResolutionCandidate $receiver, KotlinCallArgument argument, ParameterDescriptor candidateParameter) {
        boolean bl;
        boolean argumentIsFunctional;
        if (!$receiver.getCallComponents().getSamConversionTransformer().shouldRunSamConversionForFunction($receiver.getResolvedCall().getCandidateDescriptor())) {
            return null;
        }
        KotlinCallArgument kotlinCallArgument = argument;
        boolean bl2 = kotlinCallArgument instanceof SimpleKotlinCallArgument ? ResolutionPartsKt.isSubtypeOfFunctionType(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver())) : (argumentIsFunctional = kotlinCallArgument instanceof LambdaKotlinCallArgument || kotlinCallArgument instanceof CallableReferenceKotlinCallArgument);
        if (!argumentIsFunctional) {
            return null;
        }
        ParameterDescriptor parameterDescriptor = candidateParameter.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(parameterDescriptor, "candidateParameter.original");
        UnwrappedType originalExpectedType = ArgumentsUtilsKt.getExpectedType(argument, parameterDescriptor, $receiver.getCallComponents().getLanguageVersionSettings());
        UnwrappedType unwrappedType = $receiver.getCallComponents().getSamConversionTransformer().getFunctionTypeForPossibleSamType(originalExpectedType);
        if (unwrappedType == null) {
            return null;
        }
        UnwrappedType convertedTypeByOriginal = unwrappedType;
        UnwrappedType candidateExpectedType = ArgumentsUtilsKt.getExpectedType(argument, candidateParameter, $receiver.getCallComponents().getLanguageVersionSettings());
        UnwrappedType convertedTypeByCandidate = $receiver.getCallComponents().getSamConversionTransformer().getFunctionTypeForPossibleSamType(candidateExpectedType);
        boolean bl3 = bl = Intrinsics.areEqual(candidateExpectedType.getConstructor(), originalExpectedType.getConstructor()) && convertedTypeByCandidate != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "If original type is SAM type, then candidate should have same type constructor and corresponding function type\n" + "originalExpectType: " + originalExpectedType + ", candidateExpectType: " + candidateExpectedType + '\n' + "functionTypeByOriginal: " + convertedTypeByOriginal + ", functionTypeByCandidate: " + convertedTypeByCandidate;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        MutableResolvedCallAtom mutableResolvedCallAtom = $receiver.getResolvedCall();
        UnwrappedType unwrappedType2 = convertedTypeByCandidate;
        if (unwrappedType2 == null) {
            Intrinsics.throwNpe();
        }
        mutableResolvedCallAtom.registerArgumentWithSamConversion(argument, new SamConversionDescription(convertedTypeByOriginal, unwrappedType2));
        return convertedTypeByCandidate;
    }

    private static final boolean isSubtypeOfFunctionType(@NotNull UnwrappedType $receiver) {
        return NewKotlinTypeCheckerKt.anySuperTypeConstructor($receiver, isSubtypeOfFunctionType.1.INSTANCE);
    }

    public static final /* synthetic */ void access$resolveKotlinArgument(@NotNull KotlinResolutionCandidate $receiver, @NotNull KotlinCallArgument argument, @Nullable ParameterDescriptor candidateParameter, boolean isReceiver) {
        ResolutionPartsKt.resolveKotlinArgument($receiver, argument, candidateParameter, isReceiver);
    }
}

