/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/KotlinVersionStringAnnotationValueChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "extraCheck", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "version", "", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Companion", "frontend"})
public abstract class KotlinVersionStringAnnotationValueChecker
implements DeclarationChecker {
    private final FqName annotationFqName;
    @NotNull
    private static final Regex VERSION_REGEX;
    public static final Companion Companion;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(this.annotationFqName);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotation2 = annotationDescriptor;
        ConstantValue constantValue = (ConstantValue)CollectionsKt.singleOrNull((Iterable)annotation2.getAllValueArguments().values());
        Object object = constantValue != null ? constantValue.getValue() : null;
        if (!(object instanceof String)) {
            object = null;
        }
        String string2 = (String)object;
        if (string2 == null) {
            return;
        }
        String version = string2;
        CharSequence charSequence = version;
        Regex regex = VERSION_REGEX;
        if (!regex.matches(charSequence)) {
            BindingTrace bindingTrace = context.getTrace();
            PsiElement psiElement = KotlinSourceElementKt.getPsi(annotation2.getSource());
            if (psiElement == null) {
                psiElement = declaration;
            }
            bindingTrace.report(Errors.ILLEGAL_KOTLIN_VERSION_STRING_VALUE.on(psiElement, this.annotationFqName));
            return;
        }
        this.extraCheck(declaration, annotation2, version, context.getTrace(), context.getLanguageVersionSettings());
    }

    public void extraCheck(@NotNull KtDeclaration declaration, @NotNull AnnotationDescriptor annotation2, @NotNull String version, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        Intrinsics.checkParameterIsNotNull(version, "version");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
    }

    public KotlinVersionStringAnnotationValueChecker(@NotNull FqName annotationFqName) {
        Intrinsics.checkParameterIsNotNull(annotationFqName, "annotationFqName");
        this.annotationFqName = annotationFqName;
    }

    static {
        String string2;
        Companion = new Companion(null);
        String number = string2 = "(0|[1-9][0-9]*)";
        VERSION_REGEX = new Regex(number + "\\." + number + "(\\." + number + ")?");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/KotlinVersionStringAnnotationValueChecker$Companion;", "", "()V", "VERSION_REGEX", "Lkotlin/text/Regex;", "getVERSION_REGEX", "()Lkotlin/text/Regex;", "frontend"})
    public static final class Companion {
        @NotNull
        public final Regex getVERSION_REGEX() {
            return VERSION_REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

