/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\f*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\f*\u00020\u0010H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmFieldApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isInterfaceCompanionWithPublicJvmFieldProperties", "", "companionObject", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "hasBackingField", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasCustomAccessor", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isInsideCompanionObjectOfInterface", "Problem", "frontend.java"})
public final class JvmFieldApplicabilityChecker
implements DeclarationChecker {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Problem problem;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!(descriptor2 instanceof PropertyDescriptor)) return;
        if (!(declaration instanceof KtProperty)) {
            return;
        }
        AnnotationDescriptor annotationDescriptor = JvmAnnotationUtilKt.findJvmFieldAnnotation(descriptor2);
        if (annotationDescriptor == null) {
            FieldDescriptor fieldDescriptor = ((PropertyDescriptor)descriptor2).getDelegateField();
            Object object = fieldDescriptor;
            if (fieldDescriptor == null) return;
            Annotations annotations2 = object.getAnnotations();
            object = annotations2;
            if (annotations2 == null) return;
            FqName fqName2 = JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME");
            annotationDescriptor = object.findAnnotation(fqName2);
        }
        if (annotationDescriptor == null) return;
        AnnotationDescriptor annotation2 = annotationDescriptor;
        if (((KtProperty)declaration).hasDelegate()) {
            problem = Problem.DELEGATE;
        } else {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
            if (!this.hasBackingField(propertyDescriptor, bindingContext)) {
                return;
            }
            if (ModalityKt.isOverridable((CallableMemberDescriptor)descriptor2)) {
                problem = Problem.NOT_FINAL;
            } else if (Visibilities.isPrivate(((PropertyDescriptor)descriptor2).getVisibility())) {
                problem = Problem.PRIVATE;
            } else if (this.hasCustomAccessor((KtProperty)declaration)) {
                problem = Problem.CUSTOM_ACCESSOR;
            } else {
                Collection<? extends PropertyDescriptor> collection = ((PropertyDescriptor)descriptor2).getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, "descriptor.overriddenDescriptors");
                Collection<? extends PropertyDescriptor> collection2 = collection;
                if (!collection2.isEmpty()) {
                    problem = Problem.OVERRIDES;
                } else if (((PropertyDescriptor)descriptor2).isLateInit()) {
                    problem = Problem.LATEINIT;
                } else if (((PropertyDescriptor)descriptor2).isConst()) {
                    problem = Problem.CONST;
                } else if (this.isInsideCompanionObjectOfInterface((PropertyDescriptor)descriptor2)) {
                    if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmFieldInInterface)) {
                        problem = Problem.INSIDE_COMPANION_OF_INTERFACE;
                    } else {
                        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        if (this.isInterfaceCompanionWithPublicJvmFieldProperties((ClassDescriptor)declarationDescriptor)) return;
                        problem = Problem.NOT_PUBLIC_VAL_WITH_JVMFIELD;
                    }
                } else if (DescriptorUtils.isTopLevelDeclaration(descriptor2) && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration)) {
                    problem = Problem.TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
                } else {
                    KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getReturnType();
                    if (kotlinType == null) return;
                    if (!InlineClassManglingRulesKt.isInlineClassThatRequiresMangling(kotlinType)) return;
                    problem = Problem.RETURN_TYPE_IS_INLINE_CLASS;
                }
            }
        }
        Problem problem2 = problem;
        KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
        if (ktAnnotationEntry == null) return;
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        context.getTrace().report(ErrorsJvm.INAPPLICABLE_JVM_FIELD.on((KtAnnotationEntry)((PsiElement)annotationEntry), problem2.getErrorMessage()));
    }

    private final boolean isInterfaceCompanionWithPublicJvmFieldProperties(ClassDescriptor companionObject) {
        for (DeclarationDescriptor next : companionObject.getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.VARIABLES, MemberScope.Companion.getALL_NAME_FILTER())) {
            if (!(next instanceof PropertyDescriptor)) continue;
            if (Intrinsics.areEqual(((PropertyDescriptor)next).getVisibility(), Visibilities.PUBLIC) ^ true || ((PropertyDescriptor)next).isVar() || ((PropertyDescriptor)next).getModality() != Modality.FINAL) {
                return false;
            }
            if (JvmAbi.hasJvmFieldAnnotation((CallableMemberDescriptor)next)) continue;
            return false;
        }
        return true;
    }

    private final boolean hasCustomAccessor(@NotNull KtProperty $receiver) {
        return $receiver.getGetter() != null || $receiver.getSetter() != null;
    }

    private final boolean hasBackingField(@NotNull PropertyDescriptor $receiver, BindingContext bindingContext) {
        Boolean bl = (Boolean)bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, $receiver);
        return bl != null ? bl : false;
    }

    private final boolean isInsideCompanionObjectOfInterface(@NotNull PropertyDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor containingClass = classDescriptor2;
        if (!DescriptorUtils.isCompanionObject(containingClass)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = containingClass.getContainingDeclaration();
        if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
            declarationDescriptor2 = null;
        }
        ClassDescriptor classDescriptor3 = (ClassDescriptor)declarationDescriptor2;
        ClassKind outerClassKind = classDescriptor3 != null ? classDescriptor3.getKind() : null;
        return outerClassKind == ClassKind.INTERFACE || outerClassKind == ClassKind.ANNOTATION_CLASS;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmFieldApplicabilityChecker$Problem;", "", "errorMessage", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "NOT_FINAL", "PRIVATE", "CUSTOM_ACCESSOR", "OVERRIDES", "LATEINIT", "CONST", "INSIDE_COMPANION_OF_INTERFACE", "NOT_PUBLIC_VAL_WITH_JVMFIELD", "TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE", "DELEGATE", "RETURN_TYPE_IS_INLINE_CLASS", "frontend.java"})
    public static final class Problem
    extends Enum<Problem> {
        public static final /* enum */ Problem NOT_FINAL;
        public static final /* enum */ Problem PRIVATE;
        public static final /* enum */ Problem CUSTOM_ACCESSOR;
        public static final /* enum */ Problem OVERRIDES;
        public static final /* enum */ Problem LATEINIT;
        public static final /* enum */ Problem CONST;
        public static final /* enum */ Problem INSIDE_COMPANION_OF_INTERFACE;
        public static final /* enum */ Problem NOT_PUBLIC_VAL_WITH_JVMFIELD;
        public static final /* enum */ Problem TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
        public static final /* enum */ Problem DELEGATE;
        public static final /* enum */ Problem RETURN_TYPE_IS_INLINE_CLASS;
        private static final /* synthetic */ Problem[] $VALUES;
        @NotNull
        private final String errorMessage;

        static {
            Problem[] problemArray = new Problem[11];
            Problem[] problemArray2 = problemArray;
            problemArray[0] = NOT_FINAL = new Problem("JvmField can only be applied to final property");
            problemArray[1] = PRIVATE = new Problem("JvmField has no effect on a private property");
            problemArray[2] = CUSTOM_ACCESSOR = new Problem("JvmField cannot be applied to a property with a custom accessor");
            problemArray[3] = OVERRIDES = new Problem("JvmField cannot be applied to a property that overrides some other property");
            problemArray[4] = LATEINIT = new Problem("JvmField cannot be applied to lateinit property");
            problemArray[5] = CONST = new Problem("JvmField cannot be applied to const property");
            problemArray[6] = INSIDE_COMPANION_OF_INTERFACE = new Problem("JvmField cannot be applied to a property defined in companion object of interface");
            problemArray[7] = NOT_PUBLIC_VAL_WITH_JVMFIELD = new Problem("JvmField could be applied only if all interface companion properties are 'public final val' with '@JvmField' annotation");
            problemArray[8] = TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE = new Problem("JvmField cannot be applied to top level property of a file annotated with " + JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT());
            problemArray[9] = DELEGATE = new Problem("JvmField cannot be applied to delegated property");
            problemArray[10] = RETURN_TYPE_IS_INLINE_CLASS = new Problem("JvmField cannot be applied to a property of an inline class type");
            $VALUES = problemArray;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        protected Problem(@NotNull String errorMessage) {
            Intrinsics.checkParameterIsNotNull(errorMessage, "errorMessage");
            this.errorMessage = errorMessage;
        }

        public static Problem[] values() {
            return (Problem[])$VALUES.clone();
        }

        public static Problem valueOf(String string2) {
            return Enum.valueOf(Problem.class, string2);
        }
    }
}

