/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "()V", "CHARS", "", "", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkIdentifier", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "reportIfNeeded", "name", "", "reportOn", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiElement;", "frontend.java"})
public final class JvmSimpleNameBacktickChecker
implements IdentifierChecker {
    private static final Set<Character> CHARS;
    public static final JvmSimpleNameBacktickChecker INSTANCE;

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull(simpleNameExpression, "simpleNameExpression");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        this.reportIfNeeded(simpleNameExpression.getReferencedName(), (Function0<? extends PsiElement>)new Function0<PsiElement>(simpleNameExpression){
            final /* synthetic */ KtSimpleNameExpression $simpleNameExpression;

            @Nullable
            public final PsiElement invoke() {
                return this.$simpleNameExpression.getIdentifier();
            }
            {
                this.$simpleNameExpression = ktSimpleNameExpression;
                super(0);
            }
        }, diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        if (declaration instanceof KtDestructuringDeclaration) {
            List<KtDestructuringDeclarationEntry> list2 = ((KtDestructuringDeclaration)declaration).getEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, "declaration.entries");
            $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it = (KtDestructuringDeclarationEntry)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(ktDestructuringDeclarationEntry, "it");
                INSTANCE.checkNamed(ktDestructuringDeclarationEntry, diagnosticHolder);
            }
        }
        if (declaration instanceof KtCallableDeclaration) {
            List<KtParameter> list3 = ((KtCallableDeclaration)declaration).getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, "declaration.valueParameters");
            $receiver$iv = list3;
            for (Object element$iv : $receiver$iv) {
                ASTDelegatePsiElement aSTDelegatePsiElement = it = (KtParameter)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(aSTDelegatePsiElement, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)aSTDelegatePsiElement), diagnosticHolder);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> list4 = ((KtTypeParameterListOwner)declaration).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list4, "declaration.typeParameters");
            $receiver$iv = list4;
            for (Object element$iv : $receiver$iv) {
                ASTDelegatePsiElement aSTDelegatePsiElement = it = (KtTypeParameter)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(aSTDelegatePsiElement, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)aSTDelegatePsiElement), diagnosticHolder);
            }
        }
        if (declaration instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration, diagnosticHolder);
        }
    }

    private final void checkNamed(KtNamedDeclaration declaration, DiagnosticSink diagnosticHolder) {
        String string2 = declaration.getName();
        if (string2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(string2, "declaration.name ?: return");
        String name2 = string2;
        this.reportIfNeeded(name2, (Function0<? extends PsiElement>)new Function0<PsiElement>(declaration){
            final /* synthetic */ KtNamedDeclaration $declaration;

            @Nullable
            public final PsiElement invoke() {
                PsiElement psiElement = this.$declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = this.$declaration;
                }
                return psiElement;
            }
            {
                this.$declaration = ktNamedDeclaration;
                super(0);
            }
        }, diagnosticHolder);
    }

    private final void reportIfNeeded(String name2, Function0<? extends PsiElement> reportOn, DiagnosticSink diagnosticHolder) {
        String string2 = KtPsiUtil.unquoteIdentifier(name2);
        Intrinsics.checkExpressionValueIsNotNull(string2, "KtPsiUtil.unquoteIdentifier(name)");
        String text2 = string2;
        CharSequence charSequence = text2;
        if (charSequence.length() == 0) {
            PsiElement psiElement = reportOn.invoke();
            if (psiElement == null) {
                return;
            }
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "should not be empty"));
        } else {
            boolean bl;
            block6: {
                CharSequence $receiver$iv;
                CharSequence charSequence2 = $receiver$iv = (CharSequence)text2;
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv = charSequence2.charAt(i);
                    char it = element$iv;
                    if (!CHARS.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                PsiElement psiElement = reportOn.invoke();
                if (psiElement == null) {
                    return;
                }
                diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "contains illegal characters: " + CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)CHARS, (Iterable)StringsKt.toSet(text2)), "", null, null, 0, null, null, 62, null)));
            }
        }
    }

    private JvmSimpleNameBacktickChecker() {
    }

    static {
        JvmSimpleNameBacktickChecker jvmSimpleNameBacktickChecker;
        INSTANCE = jvmSimpleNameBacktickChecker = new JvmSimpleNameBacktickChecker();
        CHARS = SetsKt.setOf(Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\'));
    }
}

