/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.SuperCallReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisClassReceiver;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "frontend"})
public interface ExpressionReceiver
extends ReceiverValue {
    public static final Companion Companion = org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver$Companion.$$INSTANCE;

    @NotNull
    public KtExpression getExpression();

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "ExpressionReceiverImpl", "SuperExpressionReceiver", "ThisExpressionClassReceiver", "frontend"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final ExpressionReceiver create(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Intrinsics.checkParameterIsNotNull(type2, "type");
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            KtReferenceExpression referenceExpression = null;
            if (expression2 instanceof KtThisExpression) {
                referenceExpression = ((KtThisExpression)expression2).getInstanceReference();
            } else if (expression2 instanceof KtConstructorDelegationReferenceExpression) {
                referenceExpression = (KtReferenceExpression)expression2;
            }
            if (referenceExpression != null) {
                DeclarationDescriptor descriptor2 = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, referenceExpression);
                if (descriptor2 instanceof ClassDescriptor) {
                    ClassDescriptor classDescriptor2 = ((ClassDescriptor)descriptor2).getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "descriptor.original");
                    return new ThisExpressionClassReceiver(classDescriptor2, expression2, type2, null);
                }
            } else if (expression2 instanceof KtSuperExpression) {
                KotlinType kotlinType = (KotlinType)bindingContext.get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2);
                if (kotlinType != null) {
                    KotlinType kotlinType2;
                    KotlinType thisType = kotlinType2 = kotlinType;
                    return new SuperExpressionReceiver(thisType, expression2, type2, null);
                }
            }
            return new ExpressionReceiverImpl(expression2, type2, null);
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/AbstractReceiverValue;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "original", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "replaceType", "newType", "toString", "", "frontend"})
        private static class ExpressionReceiverImpl
        extends AbstractReceiverValue
        implements ExpressionReceiver {
            @NotNull
            private final KtExpression expression;

            @Override
            @NotNull
            public ExpressionReceiverImpl replaceType(@NotNull KotlinType newType) {
                Intrinsics.checkParameterIsNotNull(newType, "newType");
                return new ExpressionReceiverImpl(this.getExpression(), newType, this.getOriginal());
            }

            @NotNull
            public String toString() {
                return this.getType() + " {" + this.getExpression() + ": " + this.getExpression().getText() + '}';
            }

            @Override
            @NotNull
            public KtExpression getExpression() {
                return this.expression;
            }

            public ExpressionReceiverImpl(@NotNull KtExpression expression2, @NotNull KotlinType type2, @Nullable ReceiverValue original) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(type2, "type");
                super(type2, original);
                this.expression = expression2;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ThisExpressionClassReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ThisClassReceiver;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "original", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "replaceType", "newType", "frontend"})
        private static final class ThisExpressionClassReceiver
        extends ExpressionReceiverImpl
        implements ThisClassReceiver {
            @NotNull
            private final ClassDescriptor classDescriptor;

            @Override
            @NotNull
            public ThisExpressionClassReceiver replaceType(@NotNull KotlinType newType) {
                Intrinsics.checkParameterIsNotNull(newType, "newType");
                return new ThisExpressionClassReceiver(this.getClassDescriptor(), this.getExpression(), newType, this.getOriginal());
            }

            @Override
            @NotNull
            public ClassDescriptor getClassDescriptor() {
                return this.classDescriptor;
            }

            public ThisExpressionClassReceiver(@NotNull ClassDescriptor classDescriptor2, @NotNull KtExpression expression2, @NotNull KotlinType type2, @Nullable ReceiverValue original) {
                Intrinsics.checkParameterIsNotNull(classDescriptor2, "classDescriptor");
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(type2, "type");
                super(expression2, type2, original);
                this.classDescriptor = classDescriptor2;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$SuperExpressionReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/SuperCallReceiverValue;", "thisType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "original", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "getThisType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "replaceType", "newType", "frontend"})
        private static final class SuperExpressionReceiver
        extends ExpressionReceiverImpl
        implements SuperCallReceiverValue {
            @NotNull
            private final KotlinType thisType;

            @Override
            @NotNull
            public SuperExpressionReceiver replaceType(@NotNull KotlinType newType) {
                Intrinsics.checkParameterIsNotNull(newType, "newType");
                return new SuperExpressionReceiver(this.getThisType(), this.getExpression(), newType, this.getOriginal());
            }

            @Override
            @NotNull
            public KotlinType getThisType() {
                return this.thisType;
            }

            public SuperExpressionReceiver(@NotNull KotlinType thisType, @NotNull KtExpression expression2, @NotNull KotlinType type2, @Nullable ReceiverValue original) {
                Intrinsics.checkParameterIsNotNull(thisType, "thisType");
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Intrinsics.checkParameterIsNotNull(type2, "type");
                super(expression2, type2, original);
                this.thisType = thisType;
            }
        }
    }
}

