/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.UnsignedErrorValueTypeConstant;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.expressions.unqualifiedSuper.UnqualifiedSuperKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    private static final TokenSet BARE_TYPES_ALLOWED = TokenSet.create(KtTokens.AS_KEYWORD, KtTokens.AS_SAFE);
    private static final Pattern FP_LITERAL_PARTS = Pattern.compile("(?:([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*))[f]?");

    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    private static boolean isLValueOrUnsafeReceiver(@NotNull KtSimpleNameExpression expression2) {
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType(expression2, KtParenthesizedExpression.class);
        if (parent2 instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)parent2;
            return qualifiedExpression.getOperationSign() == KtTokens.DOT && qualifiedExpression.getReceiverExpression() == KtPsiUtil.deparenthesize(expression2);
        }
        if (parent2 instanceof KtBinaryExpression) {
            KtBinaryExpression binaryExpression = (KtBinaryExpression)parent2;
            if (!OperatorConventions.BINARY_OPERATION_NAMES.containsKey(binaryExpression.getOperationToken()) && !KtTokens.ALL_ASSIGNMENTS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            return PsiTreeUtil.isAncestor(binaryExpression.getLeft(), expression2, false);
        }
        return false;
    }

    private static boolean isDangerousWithNull(@NotNull KtSimpleNameExpression expression2, @NotNull ExpressionTypingContext context) {
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType(expression2, KtParenthesizedExpression.class);
        if (parent2 instanceof KtUnaryExpression) {
            KtUnaryExpression unaryExpression = (KtUnaryExpression)parent2;
            return unaryExpression.getOperationToken() == KtTokens.EXCLEXCL;
        }
        if (parent2 instanceof KtBinaryExpressionWithTypeRHS) {
            KtBinaryExpressionWithTypeRHS binaryExpression = (KtBinaryExpressionWithTypeRHS)parent2;
            KotlinType type2 = context.trace.get(BindingContext.TYPE, binaryExpression.getRight());
            return type2 != null && !type2.isMarkedNullable() && binaryExpression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
        }
        return false;
    }

    private void checkNull(@NotNull KtSimpleNameExpression expression2, @NotNull ExpressionTypingContext context, @Nullable KotlinType type2) {
        DataFlowValue dataFlowValue2;
        Nullability nullability;
        if (type2 != null && !KotlinTypeKt.isError(type2) && !BasicExpressionTypingVisitor.isLValueOrUnsafeReceiver(expression2) && !(nullability = context.dataFlowInfo.getStableNullability(dataFlowValue2 = this.components.dataFlowValueFactory.createDataFlowValue(expression2, type2, context))).canBeNonNull() && nullability.canBeNull()) {
            if (BasicExpressionTypingVisitor.isDangerousWithNull(expression2, context)) {
                context.trace.report(Errors.ALWAYS_NULL.on(expression2));
            } else {
                context.trace.record(BindingContext.SMARTCAST_NULL, expression2);
            }
        }
    }

    @Override
    public KotlinTypeInfo visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, ExpressionTypingContext context) {
        ReservedCheckingKt.checkReservedYield(expression2, context.trace);
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        KotlinTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression2, null, null, context);
        this.checkNull(expression2, context, typeInfo.getType());
        this.components.constantExpressionEvaluator.evaluateExpression(expression2, context.trace, context.expectedType);
        return this.components.dataFlowAnalyzer.checkType(typeInfo, (KtExpression)expression2, (ResolutionContext)context);
    }

    @Override
    public KotlinTypeInfo visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, ExpressionTypingContext context) {
        KtExpression innerExpression = expression2.getExpression();
        if (innerExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        KotlinTypeInfo result2 = this.facade.getTypeInfo(innerExpression, context);
        KotlinType resultType = result2.getType();
        if (resultType != null) {
            DataFlowValue innerValue = this.components.dataFlowValueFactory.createDataFlowValue(innerExpression, resultType, context);
            DataFlowValue resultValue = this.components.dataFlowValueFactory.createDataFlowValue(expression2, resultType, context);
            result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(resultValue, innerValue, this.components.languageVersionSettings));
        }
        return result2;
    }

    @Override
    public KotlinTypeInfo visitConstantExpression(@NotNull KtConstantExpression expression2, ExpressionTypingContext context) {
        ConstantValue constantValue;
        CompileTimeConstantChecker constantChecker;
        boolean hasError;
        CompileTimeConstant<?> compileTimeConstant;
        IElementType elementType = expression2.getNode().getElementType();
        if (elementType == KtNodeTypes.CHARACTER_CONSTANT || elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix(expression2, context);
        }
        if (elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            this.checkUnderscores(expression2, elementType, context);
        }
        if ((compileTimeConstant = this.components.constantExpressionEvaluator.evaluateExpression(expression2, context.trace, context.expectedType)) instanceof UnsignedErrorValueTypeConstant) {
            ErrorValue.ErrorValueWithMessage value2 = ((UnsignedErrorValueTypeConstant)compileTimeConstant).getErrorValue();
            context.trace.report(Errors.UNSIGNED_LITERAL_WITHOUT_DECLARATIONS_ON_CLASSPATH.on(expression2));
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)value2.getType(this.components.moduleDescriptor), context);
        }
        if (!(compileTimeConstant instanceof IntegerValueTypeConstant) && (hasError = (constantChecker = new CompileTimeConstantChecker(context, this.components.moduleDescriptor, false)).checkConstantExpressionType(constantValue = compileTimeConstant != null ? ((TypedCompileTimeConstant)compileTimeConstant).getConstantValue() : null, expression2, context.expectedType))) {
            return TypeInfoFactoryKt.createTypeInfo(constantValue != null ? constantValue.getType(this.components.moduleDescriptor) : this.getDefaultType(elementType), context);
        }
        assert (compileTimeConstant != null) : "CompileTimeConstant should be evaluated for constant expression or an error should be recorded " + expression2.getText();
        return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(compileTimeConstant, expression2, context);
    }

    private void checkUnderscores(@NotNull KtConstantExpression expression2, @NotNull IElementType elementType, @NotNull ExpressionTypingContext context) {
        List<String> parts;
        String text2 = expression2.getText().toLowerCase();
        if (!text2.contains("_")) {
            return;
        }
        if (!this.components.languageVersionSettings.supportsFeature(LanguageFeature.UnderscoresInNumericLiterals)) {
            context.trace.report(Errors.UNSUPPORTED_FEATURE.on(expression2, TuplesKt.to(LanguageFeature.UnderscoresInNumericLiterals, this.components.languageVersionSettings)));
            return;
        }
        if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
            int start = 0;
            int end = expression2.getText().length();
            if (text2.startsWith("0x") || text2.startsWith("0b")) {
                start += 2;
            }
            if (StringUtil.endsWithChar(text2, 'l')) {
                --end;
            }
            parts = Collections.singletonList(text2.substring(start, end));
        } else {
            Matcher matcher = FP_LITERAL_PARTS.matcher(text2);
            parts = new ArrayList<String>();
            if (matcher.matches()) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    parts.add(matcher.group(i + 1));
                }
            }
        }
        for (String part : parts) {
            if (part == null || !part.startsWith("_") && !part.endsWith("_")) continue;
            context.trace.report(Errors.ILLEGAL_UNDERSCORE.on(expression2));
            return;
        }
    }

    @NotNull
    public KotlinType getDefaultType(IElementType constantType) {
        KotlinBuiltIns builtIns = this.components.builtIns;
        if (constantType == KtNodeTypes.INTEGER_CONSTANT) {
            return builtIns.getIntType();
        }
        if (constantType == KtNodeTypes.FLOAT_CONSTANT) {
            return builtIns.getDoubleType();
        }
        if (constantType == KtNodeTypes.BOOLEAN_CONSTANT) {
            return builtIns.getBooleanType();
        }
        if (constantType == KtNodeTypes.CHARACTER_CONSTANT) {
            return builtIns.getCharType();
        }
        if (constantType == KtNodeTypes.NULL) {
            return builtIns.getNullableNothingType();
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    @Override
    public KotlinTypeInfo visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, ExpressionTypingContext context) {
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression left = expression2.getLeft();
        KtTypeReference right = expression2.getRight();
        if (right == null) {
            return this.facade.getTypeInfo(left, contextWithNoExpectedType).clearType();
        }
        IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
        boolean allowBareTypes = BARE_TYPES_ALLOWED.contains(operationType);
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context.scope, context.trace, true, allowBareTypes, context.isDebuggerContext);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, right);
        KotlinTypeInfo typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
        KotlinType subjectType = typeInfo.getType();
        KotlinType targetType = TypeReconstructionUtil.reconstructBareType(right, possiblyBareTarget, subjectType, context.trace, this.components.builtIns);
        if (subjectType != null) {
            this.checkBinaryWithTypeRHS(expression2, context, targetType, subjectType);
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (operationType == KtTokens.AS_KEYWORD) {
                DataFlowValue value2 = this.components.dataFlowValueFactory.createDataFlowValue(left, subjectType, context);
                typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo.establishSubtyping(value2, targetType, this.components.languageVersionSettings));
            }
        }
        KotlinType result2 = operationType == KtTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression2, (ResolutionContext)context);
        RttiExpressionInformation rttiInformation = new RttiExpressionInformation(expression2.getLeft(), subjectType, result2, operationType == KtTokens.AS_SAFE ? RttiOperation.SAFE_AS : RttiOperation.AS);
        for (RttiExpressionChecker checker : this.components.rttiExpressionCheckers) {
            checker.check(rttiInformation, expression2, context.trace);
        }
        return resultTypeInfo;
    }

    private void checkBinaryWithTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull ExpressionTypingContext context, @NotNull KotlinType targetType, @Nullable KotlinType actualType) {
        if (actualType == null) {
            return;
        }
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType != KtTokens.AS_KEYWORD && operationType != KtTokens.AS_SAFE) {
            context.trace.report(Errors.UNSUPPORTED.on(operationSign, "binary operation with type RHS"));
            return;
        }
        this.checkForCastImpossibilityOrRedundancy(expression2, actualType, targetType, context);
    }

    private void checkForCastImpossibilityOrRedundancy(KtBinaryExpressionWithTypeRHS expression2, KotlinType actualType, KotlinType targetType, ExpressionTypingContext context) {
        if (actualType == null || TypeUtils.noExpectedType(targetType) || KotlinTypeKt.isError(targetType)) {
            return;
        }
        if (Boolean.TRUE.equals(context.trace.get(BindingContext.CAST_TYPE_USED_AS_EXPECTED_TYPE, expression2))) {
            return;
        }
        if (DynamicTypesKt.isDynamic(targetType)) {
            KtTypeReference right = expression2.getRight();
            assert (right != null) : "We know target is dynamic, but RHS is missing";
            context.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(right));
            return;
        }
        if (!CastDiagnosticsUtil.isCastPossible(actualType, targetType, this.components.platformToKotlinClassMap)) {
            context.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression2.getOperationReference()));
            return;
        }
        if (CastDiagnosticsUtil.INSTANCE.castIsUseless(expression2, context, targetType, actualType)) {
            context.trace.report(Errors.USELESS_CAST.on(expression2));
            return;
        }
        if (CastDiagnosticsUtil.isCastErased(actualType, targetType, KotlinTypeChecker.DEFAULT)) {
            context.trace.report(Errors.UNCHECKED_CAST.on(expression2, actualType, targetType));
        }
    }

    @Override
    public KotlinTypeInfo visitThisExpression(@NotNull KtThisExpression expression2, ExpressionTypingContext context) {
        KotlinType result2 = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context.trace.report(Errors.NO_THIS.on(expression2));
                break;
            }
            case SUCCESS: {
                result2 = resolutionResult.getReceiverParameterDescriptor().getType();
                context.trace.recordType(expression2.getInstanceReference(), result2);
            }
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context, expression2);
    }

    @Override
    public KotlinTypeInfo visitSuperExpression(@NotNull KtSuperExpression expression2, ExpressionTypingContext context) {
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context, true);
        if (!KtPsiUtil.isLHSOfDot(expression2)) {
            context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression2, expression2.getText()));
            return this.errorInSuper(expression2, context);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return this.errorInSuper(expression2, context);
            }
            case NO_THIS: {
                context.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression2));
                return this.errorInSuper(expression2, context);
            }
            case SUCCESS: {
                KotlinType result2 = this.checkPossiblyQualifiedSuper(expression2, context, resolutionResult.getReceiverParameterDescriptor());
                if (result2 != null) {
                    context.trace.recordType(expression2.getInstanceReference(), result2);
                }
                return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context, expression2);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private KotlinTypeInfo errorInSuper(KtSuperExpression expression2, ExpressionTypingContext context) {
        KtTypeReference superTypeQualifier = expression2.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
        }
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    private KotlinType checkPossiblyQualifiedSuper(KtSuperExpression expression2, ExpressionTypingContext context, ReceiverParameterDescriptor thisReceiver2) {
        KtTypeReference superTypeQualifier;
        KotlinType thisType;
        KotlinType result2;
        block22: {
            TypeSubstitutor substitutor2;
            Collection<KotlinType> supertypes2;
            block19: {
                boolean validType;
                KtTypeArgumentList redundantTypeArguments;
                KotlinType supertype;
                ClassifierDescriptor classifierCandidate;
                block21: {
                    block20: {
                        result2 = null;
                        thisType = thisReceiver2.getType();
                        supertypes2 = thisType.getConstructor().getSupertypes();
                        substitutor2 = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression2.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block19;
                        KtTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof KtUserType) {
                            KtUserType userType = (KtUserType)typeElement;
                            if (userType.getTypeArguments().isEmpty()) {
                                classifierCandidate = this.components.typeResolver.resolveClass(context.scope, userType, context.trace, context.isDebuggerContext);
                            } else {
                                supertype = this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
                                redundantTypeArguments = userType.getTypeArgumentList();
                            }
                        } else {
                            supertype = this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
                        }
                        if (classifierCandidate instanceof TypeAliasDescriptor) {
                            classifierCandidate = ((TypeAliasDescriptor)classifierCandidate).getClassDescriptor();
                        }
                        if (supertype == null) break block20;
                        if (!supertypes2.contains(supertype)) break block21;
                        result2 = supertype;
                        break block21;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassifierDescriptor superclass = classifierCandidate;
                        for (KotlinType declaredSupertype : supertypes2) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result2 = substitutor2.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype != null && !KotlinTypeKt.isError(supertype);
                if (result2 == null && (validClassifier || validType)) {
                    context.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on(redundantTypeArguments));
                }
                if (result2 != null && (validClassifier || validType)) {
                    BasicExpressionTypingVisitor.checkResolvedExplicitlyQualifiedSupertype(context.trace, result2, supertypes2, superTypeQualifier);
                }
                break block22;
            }
            if (UnqualifiedSuperKt.isPossiblyAmbiguousUnqualifiedSuper(expression2, supertypes2)) {
                Collection<KotlinType> supertypesResolvedFromContext = UnqualifiedSuperKt.resolveUnqualifiedSuperFromExpressionContext(expression2, supertypes2, this.components.builtIns.getAnyType());
                if (supertypesResolvedFromContext.size() == 1) {
                    KotlinType singleResolvedType = supertypesResolvedFromContext.iterator().next();
                    result2 = substitutor2.substitute(singleResolvedType, Variance.INVARIANT);
                } else if (supertypesResolvedFromContext.isEmpty()) {
                    result2 = this.components.builtIns.getAnyType();
                } else {
                    context.trace.report(Errors.AMBIGUOUS_SUPER.on(expression2));
                }
            } else {
                KotlinType type2 = supertypes2.isEmpty() ? this.components.builtIns.getAnyType() : supertypes2.iterator().next();
                result2 = substitutor2.substitute(type2, Variance.INVARIANT);
            }
        }
        if (result2 != null) {
            if (DescriptorUtils.isInterface(thisType.getConstructor().getDeclarationDescriptor()) && DescriptorUtils.isClass(result2.getConstructor().getDeclarationDescriptor())) {
                context.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE.on(expression2));
            }
            context.trace.recordType(expression2.getInstanceReference(), result2);
            context.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getConstructor().getDeclarationDescriptor());
            context.trace.record(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2, thisType);
        }
        BindingContextUtilsKt.recordScope(context.trace, context.scope, superTypeQualifier);
        return result2;
    }

    private static void checkResolvedExplicitlyQualifiedSupertype(@NotNull BindingTrace trace, @NotNull KotlinType result2, @NotNull Collection<KotlinType> supertypes2, @NotNull KtTypeReference superTypeQualifier) {
        if (supertypes2.size() > 1) {
            ClassifierDescriptor resultClassifierDescriptor = result2.getConstructor().getDeclarationDescriptor();
            for (KotlinType otherSupertype : supertypes2) {
                ClassifierDescriptor otherSupertypeClassifierDescriptor = otherSupertype.getConstructor().getDeclarationDescriptor();
                if (otherSupertypeClassifierDescriptor == resultClassifierDescriptor || !KotlinTypeChecker.DEFAULT.isSubtypeOf(otherSupertype, result2)) continue;
                trace.report(Errors.QUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE.on(superTypeQualifier, otherSupertype));
                break;
            }
        }
    }

    @NotNull
    private LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(KtInstanceExpressionWithLabel expression2, ExpressionTypingContext context, boolean onlyClassReceivers) {
        Name labelName = expression2.getLabelNameAsName();
        if (labelName != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = LabelResolver.INSTANCE.resolveThisOrSuperLabel(expression2, context, labelName);
            if (resolutionResult.success()) {
                ReceiverParameterDescriptor receiverParameterDescriptor = resolutionResult.getReceiverParameterDescriptor();
                this.recordThisOrSuperCallInTraceAndCallExtension(context, receiverParameterDescriptor, expression2);
                if (onlyClassReceivers && !BasicExpressionTypingVisitor.isDeclaredInClass(receiverParameterDescriptor)) {
                    return LabelResolver.LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(null);
                }
            }
            return resolutionResult;
        }
        ReceiverParameterDescriptor result2 = null;
        List<ReceiverParameterDescriptor> receivers = ScopeUtilsKt.getImplicitReceiversHierarchy(context.scope);
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result2 = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result2 = receivers.get(0);
        }
        if (result2 != null) {
            context.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getContainingDeclaration());
            this.recordThisOrSuperCallInTraceAndCallExtension(context, result2, expression2);
        }
        return LabelResolver.LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(result2);
    }

    private void recordThisOrSuperCallInTraceAndCallExtension(ExpressionTypingContext context, ReceiverParameterDescriptor descriptor2, KtExpression expression2) {
        BindingTrace trace = context.trace;
        Call call2 = CallMaker.makeCall(expression2, null, null, expression2, Collections.emptyList());
        ResolutionCandidate<ReceiverParameterDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
        ResolvedCallImpl<ReceiverParameterDescriptor> resolvedCall2 = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(trace, "Fake trace for fake 'this' or 'super' resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(context.dataFlowInfo, call2));
        resolvedCall2.markCallAsCompleted();
        trace.record(BindingContext.RESOLVED_CALL, call2, resolvedCall2);
        trace.record(BindingContext.CALL, expression2, call2);
        if (context.trace.wantsDiagnostics()) {
            CallCheckerContext callCheckerContext = this.createCallCheckerContext(context);
            for (CallChecker checker : this.components.callCheckers) {
                checker.check(resolvedCall2, expression2, callCheckerContext);
            }
        }
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public KotlinTypeInfo visitBlockExpression(@NotNull KtBlockExpression expression2, ExpressionTypingContext context) {
        return this.components.expressionTypingServices.getBlockReturnedType(expression2, context, false);
    }

    @Override
    public KotlinTypeInfo visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, ExpressionTypingContext c) {
        return this.components.doubleColonExpressionResolver.visitClassLiteralExpression(expression2, c);
    }

    @Override
    public KotlinTypeInfo visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, ExpressionTypingContext c) {
        return this.components.doubleColonExpressionResolver.visitCallableReferenceExpression(expression2, c);
    }

    @Override
    public KotlinTypeInfo visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, ExpressionTypingContext context) {
        KotlinType[] result2 = new KotlinType[1];
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve object literal expression", expression2);
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, (slice, declaration, descriptor2) -> {
            if (slice == BindingContext.CLASS && declaration == expression2.getObjectDeclaration()) {
                result2[0] = this.components.wrappedTypeFactory.createRecursionIntolerantDeferredType(context.trace, descriptor2::getDefaultType);
            }
        });
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceBindingTrace(traceAdapter)).replaceContextDependency(ContextDependency.INDEPENDENT), context.scope.getOwnerDescriptor(), expression2.getObjectDeclaration());
        temporaryTrace.commit();
        DataFlowInfo resultFlowInfo = context.dataFlowInfo;
        for (KtSuperTypeListEntry specifier : expression2.getObjectDeclaration().getSuperTypeListEntries()) {
            KtSuperTypeCallEntry delegator;
            KotlinTypeInfo delegatorTypeInfo;
            if (!(specifier instanceof KtSuperTypeCallEntry) || (delegatorTypeInfo = context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, (delegator = (KtSuperTypeCallEntry)specifier).getCalleeExpression())) == null) continue;
            resultFlowInfo = resultFlowInfo.and(delegatorTypeInfo.getDataFlowInfo());
        }
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(TypeInfoFactoryKt.createTypeInfo(result2[0], resultFlowInfo), (KtExpression)expression2, (ResolutionContext)context);
        context.trace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, resultTypeInfo);
        context.trace.record(BindingContext.PROCESSED, expression2);
        return resultTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitQualifiedExpression(@NotNull KtQualifiedExpression expression2, ExpressionTypingContext context) {
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression2, context);
    }

    @Override
    public KotlinTypeInfo visitCallExpression(@NotNull KtCallExpression expression2, ExpressionTypingContext context) {
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getCallExpressionTypeInfo(expression2, context);
    }

    @Override
    public KotlinTypeInfo visitUnaryExpression(@NotNull KtUnaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinType result2;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        ExpressionTypingContext context = ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression2, context);
        }
        KotlinTypeInfo typeInfo = this.facade.safeGetTypeInfo(baseExpression, context);
        KotlinType type2 = ExpressionTypingUtils.safeGetType(typeInfo);
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(baseExpression, type2, context.trace.getBindingContext());
        Call call2 = CallMaker.makeCall((ReceiverValue)receiver, expression2);
        Name name2 = (Name)OperatorConventions.UNARY_OPERATION_NAMES.get(operationType);
        if (name2 == null) {
            context.trace.report(Errors.UNSUPPORTED.on(operationSign, "visitUnaryExpression"));
            return typeInfo.clearType();
        }
        if ((operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && baseExpression instanceof KtArrayAccessExpression) {
            KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "e", type2);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve array access set method for unary expression", expression2);
            ExpressionTypingContext newContext = (ExpressionTypingContext)context.replaceBindingTrace(temporaryBindingTrace);
            this.resolveImplicitArrayAccessSetMethod((KtArrayAccessExpression)baseExpression, stubExpression, newContext, context.trace);
        }
        if (!(resolutionResults = this.components.callResolver.resolveCallWithGivenName(context, call2, expression2.getOperationReference(), name2)).isSuccess()) {
            return typeInfo.clearType();
        }
        KotlinType returnType2 = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) {
            assert (returnType2 != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (KotlinBuiltIns.isUnit(returnType2)) {
                result2 = ErrorUtils.createErrorType(this.components.builtIns.getUnit().getName().asString());
                context.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                KotlinType receiverType = receiver.getType();
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType2, receiverType)) {
                    context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name2.asString(), receiverType, returnType2));
                } else {
                    context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression2);
                    KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "e", type2);
                    this.checkLValue(context.trace, context, baseExpression, stubExpression, expression2);
                }
                DataFlowValue receiverValue = this.components.dataFlowValueFactory.createDataFlowValue((ReceiverValue)call2.getExplicitReceiver(), contextWithExpectedType);
                if (expression2 instanceof KtPrefixExpression) {
                    result2 = returnType2;
                } else {
                    result2 = receiverType;
                    DataFlowValue returnValue = this.components.dataFlowValueFactory.createDataFlowValue(expression2, receiverType, contextWithExpectedType);
                    typeInfo = typeInfo.replaceDataFlowInfo(typeInfo.getDataFlowInfo().assign(returnValue, receiverValue, this.components.languageVersionSettings));
                }
            }
        } else {
            result2 = returnType2;
        }
        CompileTimeConstant<?> value2 = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value2 != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType.replaceDataFlowInfo(typeInfo.getDataFlowInfo()));
    }

    private KotlinTypeInfo visitExclExclExpression(@NotNull KtUnaryExpression expression2, @NotNull ExpressionTypingContext context) {
        KotlinType resultingType;
        KtExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null);
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == KtTokens.EXCLEXCL);
        Call call2 = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Collections.singletonList(baseExpression));
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call2, ControlStructureTypingUtils.ResolveConstruct.EXCL_EXCL, Collections.singletonList("baseExpr"), Collections.singletonList(true), context, null);
        KotlinTypeInfo baseTypeInfo = BindingContextUtils.getRecordedTypeInfo(baseExpression, context.trace.getBindingContext());
        boolean isFunctionLiteral = ArgumentTypeResolver.isFunctionLiteralArgument(baseExpression, context);
        boolean isCallableReference = ArgumentTypeResolver.isCallableReferenceArgument(baseExpression, context);
        if (isFunctionLiteral || isCallableReference) {
            DiagnosticFactory0<PsiElement> diagnosticFactory = isFunctionLiteral ? Errors.NOT_NULL_ASSERTION_ON_LAMBDA_EXPRESSION : Errors.NOT_NULL_ASSERTION_ON_CALLABLE_REFERENCE;
            context.trace.report(diagnosticFactory.on(operationSign));
            if (baseTypeInfo == null) {
                return TypeInfoFactoryKt.createTypeInfo((KotlinType)ErrorUtils.createErrorType("Unresolved lambda expression"), context);
            }
            return baseTypeInfo;
        }
        assert (baseTypeInfo != null) : "Base expression was not processed: " + expression2;
        KotlinType baseType = baseTypeInfo.getType();
        if (baseType == null) {
            return baseTypeInfo;
        }
        DataFlowInfo dataFlowInfo = baseTypeInfo.getDataFlowInfo();
        if (this.isKnownToBeNotNull(baseExpression, baseType, context)) {
            context.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(operationSign, TypeUtils.makeNotNullable(baseType)));
        } else {
            DataFlowValue value2 = this.components.dataFlowValueFactory.createDataFlowValue(baseExpression, baseType, context);
            baseTypeInfo = baseTypeInfo.replaceDataFlowInfo(dataFlowInfo.disequate(value2, DataFlowValue.nullValue(this.components.builtIns), this.components.languageVersionSettings));
        }
        KotlinType kotlinType = resultingType = this.components.languageVersionSettings.supportsFeature(LanguageFeature.NewInference) ? resolvedCall2.getResultingDescriptor().getReturnType() : TypeUtils.makeNotNullable(baseType);
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            return baseTypeInfo.replaceType(resultingType);
        }
        return this.components.dataFlowAnalyzer.checkType(baseTypeInfo.replaceType(resultingType), (KtExpression)expression2, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
    }

    @Override
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, ExpressionTypingContext context) {
        return this.visitLabeledExpression(expression2, context, false);
    }

    @NotNull
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, @NotNull ExpressionTypingContext context, boolean isStatement) {
        KtExpression baseExpression;
        KtSimpleNameExpression labelExpression = expression2.getTargetLabel();
        ReservedCheckingKt.checkReservedYield(labelExpression, context.trace);
        if (labelExpression != null) {
            PsiElement labelIdentifier = labelExpression.getIdentifier();
            UnderscoreChecker.INSTANCE.checkIdentifier(labelIdentifier, context.trace, this.components.languageVersionSettings);
        }
        if ((baseExpression = expression2.getBaseExpression()) == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        return this.facade.getTypeInfo(baseExpression, context, isStatement);
    }

    private boolean isKnownToBeNotNull(@NotNull KtExpression expression2, @Nullable KotlinType ktType, @NotNull ExpressionTypingContext context) {
        if (ktType == null) {
            return false;
        }
        if (KotlinTypeKt.isError(ktType) && !ErrorUtils.isUninferredParameter(ktType)) {
            return false;
        }
        if (!TypeUtils.isNullableType(ktType)) {
            return true;
        }
        DataFlowValue dataFlowValue2 = this.components.dataFlowValueFactory.createDataFlowValue(expression2, ktType, context);
        return context.dataFlowInfo.getStableNullability(dataFlowValue2) == Nullability.NOT_NULL;
    }

    public boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context, @NotNull KtExpression expressionWithParenthesis, @Nullable KtExpression rightHandSide, @NotNull KtOperationExpression operationExpression) {
        KtExpression selector;
        KtExpression reportOn;
        KtExpression expression2 = KtPsiUtil.deparenthesize(expressionWithParenthesis);
        if (expression2 instanceof KtArrayAccessExpression) {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)expression2;
            KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression == null || rightHandSide == null) {
                return false;
            }
            TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(trace, "Trace for checking set function");
            ExpressionTypingContext findSetterContext = (ExpressionTypingContext)context.replaceBindingTrace(ignoreReportsTrace);
            KotlinTypeInfo info = this.resolveArrayAccessSetMethod(arrayAccessExpression, rightHandSide, findSetterContext, ignoreReportsTrace);
            IElementType operationType = operationExpression.getOperationReference().getReferencedNameElementType();
            if ((KtTokens.AUGMENTED_ASSIGNMENTS.contains(operationType) || operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && (resolvedCall2 = ignoreReportsTrace.get(BindingContext.INDEXED_LVALUE_SET, expression2)) != null && trace.wantsDiagnostics()) {
                CallCheckerContext callCheckerContext = new CallCheckerContext(context, this.components.deprecationResolver, this.components.moduleDescriptor, trace);
                for (CallChecker checker : this.components.callCheckers) {
                    checker.check(resolvedCall2, expression2, callCheckerContext);
                }
            }
            return info.getType() != null;
        }
        VariableDescriptor variable2 = BindingContextUtils.extractVariableDescriptorFromReference(trace.getBindingContext(), expression2);
        boolean result2 = true;
        KtExpression ktExpression = reportOn = expression2 != null ? expression2 : expressionWithParenthesis;
        if (reportOn instanceof KtQualifiedExpression && (selector = ((KtQualifiedExpression)reportOn).getSelectorExpression()) != null) {
            reportOn = selector;
        }
        if (variable2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variable2;
            PropertySetterDescriptor setter2 = propertyDescriptor.getSetter();
            if (propertyDescriptor.isSetterProjectedOut()) {
                trace.report(Errors.SETTER_PROJECTED_OUT.on(reportOn, propertyDescriptor));
                result2 = false;
            } else if (setter2 != null) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(expressionWithParenthesis, context.trace.getBindingContext());
                assert (resolvedCall3 != null) : "Call is not resolved for property setter: " + PsiUtilsKt.getElementTextWithContext(expressionWithParenthesis);
                this.checkPropertySetterCall((ExpressionTypingContext)context.replaceBindingTrace(trace), setter2, resolvedCall3, reportOn);
            }
        }
        if (variable2 == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(reportOn));
            result2 = false;
        } else if (!variable2.isVar()) {
            result2 = false;
        }
        return result2;
    }

    private void checkPropertySetterCall(@NotNull ExpressionTypingContext context, @NotNull PropertySetterDescriptor descriptor2, @NotNull ResolvedCall<?> propertyResolvedCall, @NotNull KtExpression expression2) {
        Call call2 = propertyResolvedCall.getCall();
        ResolutionCandidate<PropertySetterDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, descriptor2, propertyResolvedCall.getDispatchReceiver(), propertyResolvedCall.getExplicitReceiverKind(), null);
        ResolvedCallImpl<PropertySetterDescriptor> resolvedCall2 = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(context.trace, "Trace for fake property setter resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(propertyResolvedCall.getDataFlowInfoForArguments().getResultInfo(), call2));
        resolvedCall2.markCallAsCompleted();
        if (context.trace.wantsDiagnostics()) {
            CallCheckerContext callCheckerContext = this.createCallCheckerContext(context);
            for (CallChecker checker : this.components.callCheckers) {
                checker.check(resolvedCall2, expression2, callCheckerContext);
            }
        }
    }

    @NotNull
    private CallCheckerContext createCallCheckerContext(@NotNull ExpressionTypingContext context) {
        return new CallCheckerContext(context, this.components.deprecationResolver, this.components.moduleDescriptor);
    }

    @Override
    public KotlinTypeInfo visitBinaryExpression(@NotNull KtBinaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinTypeInfo result2;
        Name referencedName;
        ExpressionTypingContext context = ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtOperationReferenceExpression operationSign = expression2.getOperationReference();
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.IDENTIFIER) {
            referencedName = operationSign.getReferencedNameAsName();
            result2 = this.getTypeInfoForBinaryCall(referencedName, context, expression2);
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType)) {
            referencedName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(operationType);
            result2 = this.getTypeInfoForBinaryCall(referencedName, context, expression2);
        } else {
            if (operationType == KtTokens.ELVIS) {
                return this.visitElvisExpression(expression2, context);
            }
            if (operationType == KtTokens.EQ) {
                result2 = this.visitAssignment(expression2, context);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitAssignmentOperation(expression2, context);
            } else if (OperatorConventions.COMPARISON_OPERATIONS.contains(operationType)) {
                result2 = this.visitComparison(expression2, context, operationSign);
            } else if (OperatorConventions.EQUALS_OPERATIONS.contains(operationType)) {
                result2 = this.visitEquality(expression2, context, operationSign, left, right);
            } else if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains(operationType)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, context);
                result2 = TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getBooleanType(), context);
                BasicExpressionTypingVisitor.checkIdentityOnPrimitiveOrInlineClassTypes(expression2, context);
            } else if (OperatorConventions.IN_OPERATIONS.contains(operationType)) {
                ValueArgument leftArgument = CallMaker.makeValueArgument(left, left != null ? left : operationSign);
                result2 = this.checkInExpression(expression2, operationSign, leftArgument, right, context);
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitBooleanOperationExpression(operationType, left, right, context);
            } else {
                context.trace.report(Errors.UNSUPPORTED.on(operationSign, "Unknown operation"));
                result2 = TypeInfoFactoryKt.noTypeInfo(context);
            }
        }
        CompileTimeConstant<?> value2 = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value2 != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    private static void checkIdentityOnPrimitiveOrInlineClassTypes(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext context) {
        if (expression2.getLeft() == null || expression2.getRight() == null) {
            return;
        }
        KotlinType leftType = context.trace.getType(expression2.getLeft());
        KotlinType rightType = context.trace.getType(expression2.getRight());
        if (leftType == null || rightType == null) {
            return;
        }
        if (KotlinTypeChecker.DEFAULT.equalTypes(leftType, rightType)) {
            if (KotlinBuiltIns.isPrimitiveType(leftType)) {
                context.trace.report(Errors.DEPRECATED_IDENTITY_EQUALS.on(expression2, leftType, rightType));
            } else if (InlineClassesUtilsKt.isInlineClassType(leftType)) {
                context.trace.report(Errors.FORBIDDEN_IDENTITY_EQUALS.on(expression2, leftType, rightType));
            }
        } else if (BasicExpressionTypingVisitor.isIdentityComparedWithImplicitBoxing(leftType, rightType) || BasicExpressionTypingVisitor.isIdentityComparedWithImplicitBoxing(rightType, leftType)) {
            context.trace.report(Errors.IMPLICIT_BOXING_IN_IDENTITY_EQUALS.on(expression2, leftType, rightType));
        }
    }

    private static boolean isIdentityComparedWithImplicitBoxing(KotlinType leftType, KotlinType rightType) {
        return KotlinBuiltIns.isPrimitiveType(leftType) && !KotlinBuiltIns.isPrimitiveType(rightType) && KotlinTypeChecker.DEFAULT.isSubtypeOf(leftType, rightType);
    }

    private KotlinTypeInfo visitEquality(KtBinaryExpression expression2, ExpressionTypingContext context, KtSimpleNameExpression operationSign, KtExpression left, KtExpression right) {
        if (right == null || left == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(right, context, this.facade);
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getBooleanType(), context);
        }
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        ExpressionReceiver receiver = this.createReceiverForEquals(left, contextWithDataFlow);
        List<FunctionDescriptor> equalsFunctions = this.findEqualsWithNullableAnyParameter(receiver, expression2);
        Call call2 = CallMaker.makeCallWithExpressions(expression2, receiver, null, operationSign, Collections.singletonList(right), Call.CallType.DEFAULT, true);
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = this.components.callResolver.resolveEqualsCallWithGivenDescriptors(contextWithDataFlow, operationSign, receiver, call2, equalsFunctions);
        if (resolutionResults.isSuccess()) {
            FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
            if (this.ensureBooleanResult(operationSign, OperatorNameConventions.EQUALS, equals.getReturnType(), contextWithDataFlow)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, contextWithDataFlow);
            }
        } else if (resolutionResults.isAmbiguity()) {
            context.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(operationSign, resolutionResults.getResultingCalls()));
        } else {
            context.trace.report(Errors.EQUALS_MISSING.on(operationSign));
        }
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithDataFlow);
        return rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
    }

    private ExpressionReceiver createReceiverForEquals(KtExpression left, ExpressionTypingContext context) {
        KotlinType leftType = ExpressionTypingUtils.safeGetType(this.facade.safeGetTypeInfo(left, context));
        KotlinType receiverType = KotlinBuiltIns.isNothingOrNullableNothing(leftType) ? this.components.builtIns.getNullableAnyType() : leftType;
        return ExpressionReceiver.Companion.create(left, receiverType, context.trace.getBindingContext());
    }

    private List<FunctionDescriptor> findEqualsWithNullableAnyParameter(@NotNull ExpressionReceiver receiver, @NotNull KtBinaryExpression expression2) {
        KotlinType refinedType = KotlinBuiltIns.isNothingOrNullableNothing(receiver.getType()) ? this.components.builtIns.getNullableAnyType() : receiver.getType();
        Collection<SimpleFunctionDescriptor> equalsMembers = refinedType.getMemberScope().getContributedFunctions(OperatorNameConventions.EQUALS, new KotlinLookupLocation(expression2.getOperationReference()));
        return CollectionsKt.filter(equalsMembers, descriptor2 -> {
            if (ErrorUtils.isError(descriptor2)) {
                return true;
            }
            if (descriptor2.getValueParameters().size() != 1) {
                return false;
            }
            ValueParameterDescriptor valueParameter = descriptor2.getValueParameters().get(0);
            return KotlinBuiltIns.isNullableAny(valueParameter.getType());
        });
    }

    @NotNull
    private KotlinTypeInfo visitComparison(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext context, @NotNull KtSimpleNameExpression operationSign) {
        KotlinTypeInfo typeInfo = this.getTypeInfoForBinaryCall(OperatorNameConventions.COMPARE_TO, context, expression2);
        KotlinType compareToReturnType = typeInfo.getType();
        SimpleType type2 = null;
        if (compareToReturnType != null && !KotlinTypeKt.isError(compareToReturnType)) {
            if (KotlinTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getIntType(), compareToReturnType)) {
                type2 = this.components.builtIns.getBooleanType();
            } else {
                context.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
            }
        }
        return typeInfo.replaceType(type2);
    }

    @NotNull
    private KotlinTypeInfo visitBooleanOperationExpression(@Nullable IElementType operationType, @Nullable KtExpression left, @Nullable KtExpression right, @NotNull ExpressionTypingContext context) {
        SimpleType booleanType = this.components.builtIns.getBooleanType();
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, (ExpressionTypingContext)context.replaceExpectedType(booleanType), this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        LexicalWritableScope leftScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.LEFT_BOOLEAN_EXPRESSION, this.facade.getComponents().overloadChecker);
        boolean isAnd = operationType == KtTokens.ANDAND;
        DataFlowInfo flowInfoLeft = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(left, isAnd, context).and(dataFlowInfo);
        LexicalWritableScope rightScope = isAnd ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.RIGHT_BOOLEAN_EXPRESSION, this.facade.getComponents().overloadChecker);
        ExpressionTypingContext contextForRightExpr = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope)).replaceExpectedType(booleanType);
        if (right != null) {
            this.facade.getTypeInfo(right, contextForRightExpr);
        }
        return leftTypeInfo.replaceType(booleanType);
    }

    @NotNull
    private KotlinTypeInfo visitElvisExpression(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType) {
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        if (left == null || right == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        Call call2 = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Lists.newArrayList(left, right));
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call2, ControlStructureTypingUtils.ResolveConstruct.ELVIS, Lists.newArrayList("left", "right"), Lists.newArrayList(true, false), contextWithExpectedType, null);
        KotlinTypeInfo leftTypeInfo = BindingContextUtils.getRecordedTypeInfo(left, context.trace.getBindingContext());
        boolean isLeftFunctionLiteral = ArgumentTypeResolver.isFunctionLiteralArgument(left, context);
        boolean isLeftCallableReference = ArgumentTypeResolver.isCallableReferenceArgument(left, context);
        if (leftTypeInfo == null && (isLeftFunctionLiteral || isLeftCallableReference)) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        assert (leftTypeInfo != null) : "Left expression was not processed: " + expression2;
        KotlinType leftType = leftTypeInfo.getType();
        KotlinTypeInfo rightTypeInfo = BindingContextUtils.getRecordedTypeInfo(right, context.trace.getBindingContext());
        if (rightTypeInfo == null && ArgumentTypeResolver.isFunctionLiteralOrCallableReference(right, context)) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        assert (rightTypeInfo != null) : "Right expression was not processed: " + expression2;
        boolean loopBreakContinuePossible = leftTypeInfo.getJumpOutPossible() || rightTypeInfo.getJumpOutPossible();
        KotlinType rightType = rightTypeInfo.getType();
        DataFlowInfo dataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getInfo(call2.getValueArguments().get(1));
        KotlinType type2 = resolvedCall2.getResultingDescriptor().getReturnType();
        if (type2 == null || rightType == null || leftType == null && KotlinBuiltIns.isNothing(rightType)) {
            return TypeInfoFactoryKt.noTypeInfo(dataFlowInfo);
        }
        if (leftType != null) {
            DataFlowValue leftValue = this.components.dataFlowValueFactory.createDataFlowValue(left, leftType, context);
            DataFlowInfo rightDataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            boolean jumpInRight = KotlinBuiltIns.isNothing(rightType);
            DataFlowValue nullValue = DataFlowValue.nullValue(this.components.builtIns);
            if (jumpInRight || !rightDataFlowInfo.getStableNullability(leftValue).canBeNull()) {
                dataFlowInfo = dataFlowInfo.disequate(leftValue, nullValue, this.components.languageVersionSettings);
                if (left instanceof KtBinaryExpressionWithTypeRHS) {
                    dataFlowInfo = this.establishSubtypingForTypeRHS((KtBinaryExpressionWithTypeRHS)left, dataFlowInfo, context, this.components.languageVersionSettings);
                }
            }
            DataFlowValue resultValue = this.components.dataFlowValueFactory.createDataFlowValue(expression2, type2, context);
            dataFlowInfo = dataFlowInfo.assign(resultValue, leftValue, this.components.languageVersionSettings).disequate(resultValue, nullValue, this.components.languageVersionSettings);
            if (!jumpInRight) {
                DataFlowValue rightValue = this.components.dataFlowValueFactory.createDataFlowValue(right, rightType, context);
                rightDataFlowInfo = rightDataFlowInfo.assign(resultValue, rightValue, this.components.languageVersionSettings);
                dataFlowInfo = dataFlowInfo.or(rightDataFlowInfo);
            }
        }
        if (!TypeUtils.isNullableType(rightType) && TypeUtils.isNullableType(type2)) {
            type2 = TypeUtils.makeNotNullable(type2);
        }
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            return TypeInfoFactoryKt.createTypeInfo(type2, dataFlowInfo);
        }
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkType(type2, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType), dataFlowInfo, loopBreakContinuePossible, context.dataFlowInfo);
    }

    @NotNull
    private DataFlowInfo establishSubtypingForTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS left, @NotNull DataFlowInfo dataFlowInfo, @NotNull ExpressionTypingContext context, @NotNull LanguageVersionSettings languageVersionSettings) {
        KtExpression underSafeAs;
        KotlinType underSafeAsType;
        IElementType operationType = left.getOperationReference().getReferencedNameElementType();
        if (operationType == KtTokens.AS_SAFE && (underSafeAsType = context.trace.getType(underSafeAs = left.getLeft())) != null) {
            DataFlowValue underSafeAsValue = this.components.dataFlowValueFactory.createDataFlowValue(underSafeAs, underSafeAsType, context);
            KotlinType targetType = context.trace.get(BindingContext.TYPE, left.getRight());
            if (targetType != null) {
                return dataFlowInfo.establishSubtyping(underSafeAsValue, targetType, languageVersionSettings);
            }
        }
        return dataFlowInfo;
    }

    @NotNull
    public KotlinTypeInfo checkInExpression(@NotNull KtElement callElement, @NotNull KtSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable KtExpression right, @NotNull ExpressionTypingContext context) {
        KtExpression left = leftArgument.getArgumentExpression();
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (right == null) {
            if (left != null) {
                this.facade.getTypeInfo(left, contextWithNoExpectedType);
            }
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType);
        DataFlowInfo dataFlowInfo = rightTypeInfo.getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = this.components.callResolver.resolveCallWithGivenName(contextWithDataFlow, CallMaker.makeCall(callElement, receiver, null, operationSign, Collections.singletonList(leftArgument)), operationSign, OperatorNameConventions.CONTAINS);
        KotlinType containsType = OverloadResolutionResultsUtil.getResultingType(resolutionResult, context);
        this.ensureBooleanResult(operationSign, OperatorNameConventions.CONTAINS, containsType, context);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
            rightTypeInfo = rightTypeInfo.replaceDataFlowInfo(dataFlowInfo);
        }
        if (resolutionResult.isSuccess()) {
            return rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
        }
        return rightTypeInfo.clearType();
    }

    private boolean ensureBooleanResult(KtExpression operationSign, Name name2, KotlinType resultType, ExpressionTypingContext context) {
        return this.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name2 + "'", context);
    }

    private boolean ensureBooleanResultWithCustomSubject(KtExpression operationSign, KotlinType resultType, String subjectName, ExpressionTypingContext context) {
        if (resultType != null && !this.components.builtIns.isBooleanOrSubtype(resultType)) {
            context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, this.components.builtIns.getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    private void ensureNonemptyIntersectionOfOperandTypes(KtBinaryExpression expression2, ExpressionTypingContext context) {
        KotlinType rightType;
        KtExpression left = expression2.getLeft();
        if (left == null) {
            return;
        }
        KtExpression right = expression2.getRight();
        KotlinType leftType = this.facade.getTypeInfo(left, context).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context).getType()) != null) {
            if (TypeIntersector.isIntersectionEmpty(leftType, rightType)) {
                context.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression2, expression2.getOperationReference(), leftType, rightType));
            } else if (TypeIntersector.isIncompatibleEnums(leftType, rightType)) {
                context.trace.report(Errors.INCOMPATIBLE_ENUM_COMPARISON.on(expression2, leftType, rightType));
            }
            SenselessComparisonChecker.checkSenselessComparisonWithNull(expression2, left, right, context, expr -> this.facade.getTypeInfo((KtExpression)expr, context).getType(), context.dataFlowInfo::getStableNullability);
        }
    }

    @NotNull
    private KotlinTypeInfo visitAssignmentOperation(KtBinaryExpression expression2, ExpressionTypingContext context) {
        return this.assignmentIsNotAnExpressionError(expression2, context);
    }

    @NotNull
    private KotlinTypeInfo visitAssignment(KtBinaryExpression expression2, ExpressionTypingContext context) {
        return this.assignmentIsNotAnExpressionError(expression2, context);
    }

    @NotNull
    private KotlinTypeInfo assignmentIsNotAnExpressionError(KtBinaryExpression expression2, ExpressionTypingContext context) {
        this.facade.checkStatementType(expression2, context);
        context.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression2));
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @Override
    public KotlinTypeInfo visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, ExpressionTypingContext context) {
        return this.components.dataFlowAnalyzer.checkType(this.resolveArrayAccessGetMethod(expression2, context), (KtExpression)expression2, (ResolutionContext)context);
    }

    @Override
    public KotlinTypeInfo visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, ExpressionTypingContext context) {
        return this.components.collectionLiteralResolver.resolveCollectionLiteral(expression2, context);
    }

    @Override
    public KotlinTypeInfo visitClass(@NotNull KtClass klass2, ExpressionTypingContext context) {
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)context.replaceContextDependency(ContextDependency.INDEPENDENT), context.scope.getOwnerDescriptor(), klass2);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(klass2, context);
    }

    @NotNull
    private static KotlinTypeInfo declarationInIllegalContext(@NotNull KtDeclaration declaration, @NotNull ExpressionTypingContext context) {
        context.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(declaration));
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @Override
    public KotlinTypeInfo visitProperty(@NotNull KtProperty property, ExpressionTypingContext context) {
        this.components.localVariableResolver.process(property, context, context.scope, this.facade);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(property, context);
    }

    @NotNull
    private KotlinTypeInfo getTypeInfoForBinaryCall(@NotNull Name name2, @NotNull ExpressionTypingContext context, @NotNull KtBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        KtExpression left = binaryExpression.getLeft();
        KotlinTypeInfo typeInfo = left != null ? this.facade.getTypeInfo(left, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)) : TypeInfoFactoryKt.noTypeInfo(context);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context);
            resolutionResults = this.components.callResolver.resolveBinaryCall(contextWithDataFlow, receiver, binaryExpression, name2);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        if (resolutionResults.isSingleResult()) {
            typeInfo = typeInfo.replaceDataFlowInfo(resolutionResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo());
        }
        return typeInfo.replaceType(OverloadResolutionResultsUtil.getResultingType(resolutionResults, context));
    }

    @Override
    public KotlinTypeInfo visitDeclaration(@NotNull KtDeclaration dcl, ExpressionTypingContext context) {
        return BasicExpressionTypingVisitor.declarationInIllegalContext(dcl, context);
    }

    @Override
    public KotlinTypeInfo visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        final ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix(expression2, context);
        class StringTemplateVisitor
        extends KtVisitorVoid {
            private KotlinTypeInfo typeInfo;

            StringTemplateVisitor() {
                this.typeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            }

            @Override
            public void visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry) {
                KtExpression entryExpression = entry.getExpression();
                if (entryExpression != null) {
                    this.typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context.replaceDataFlowInfo(this.typeInfo.getDataFlowInfo()));
                }
            }

            @Override
            public void visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry) {
                CompileTimeConstantChecker.CharacterWithDiagnostic value2 = CompileTimeConstantChecker.escapedStringToCharacter(entry.getText(), entry);
                Diagnostic diagnostic = value2.getDiagnostic();
                if (diagnostic != null) {
                    context.trace.report(diagnostic);
                }
            }
        }
        StringTemplateVisitor visitor2 = new StringTemplateVisitor();
        for (KtStringTemplateEntry entry : expression2.getEntries()) {
            entry.accept(visitor2);
        }
        this.components.constantExpressionEvaluator.evaluateExpression(expression2, context.trace, contextWithExpectedType.expectedType);
        return this.components.dataFlowAnalyzer.checkType(visitor2.typeInfo.replaceType(this.components.builtIns.getStringType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    private static void checkLiteralPrefixAndSuffix(@NotNull PsiElement expression2, ExpressionTypingContext context) {
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.prevLeaf(expression2), context);
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.nextLeaf(expression2), context);
    }

    private static void checkLiteralPrefixOrSuffix(PsiElement prefixOrSuffix, ExpressionTypingContext context) {
        if (BasicExpressionTypingVisitor.illegalLiteralPrefixOrSuffix(prefixOrSuffix)) {
            context.trace.report(Errors.UNSUPPORTED.on(prefixOrSuffix, "literal prefixes and suffixes"));
        }
    }

    private static boolean illegalLiteralPrefixOrSuffix(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        IElementType elementType = element.getNode().getElementType();
        return elementType == KtTokens.IDENTIFIER || elementType == KtTokens.INTEGER_LITERAL || elementType == KtTokens.FLOAT_LITERAL || elementType instanceof KtKeywordToken;
    }

    @Override
    public KotlinTypeInfo visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, ExpressionTypingContext context) {
        return this.visitAnnotatedExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitAnnotatedExpression(KtAnnotatedExpression expression2, ExpressionTypingContext context, boolean isStatement) {
        this.resolveAnnotationsOnExpression(expression2, context);
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        return this.facade.getTypeInfo(baseExpression, context, isStatement);
    }

    protected void resolveAnnotationsOnExpression(KtAnnotatedExpression expression2, ExpressionTypingContext context) {
        if (BasicExpressionTypingVisitor.isAnnotatedExpressionInBlockLevelBinary(expression2)) {
            context.trace.report(Errors.ANNOTATIONS_ON_BLOCK_LEVEL_EXPRESSION_ON_THE_SAME_LINE.on(expression2));
        }
        if (!(expression2.getBaseExpression() instanceof KtObjectLiteralExpression)) {
            this.components.annotationResolver.resolveAnnotationsWithArguments(context.scope, expression2.getAnnotationEntries(), context.trace);
        }
    }

    private static boolean isAnnotatedExpressionInBlockLevelBinary(KtAnnotatedExpression annotatedExpression) {
        PsiElement current = annotatedExpression;
        PsiElement parent2 = current.getParent();
        if (!(parent2 instanceof KtBinaryExpression)) {
            return false;
        }
        while (parent2 instanceof KtBinaryExpression) {
            if (((KtBinaryExpression)parent2).getLeft() != current) {
                return false;
            }
            current = parent2;
            parent2 = parent2.getParent();
        }
        return KtPsiUtil.isStatementContainer(parent2);
    }

    @Override
    public KotlinTypeInfo visitKtElement(@NotNull KtElement element, ExpressionTypingContext context) {
        context.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false, false);
    }

    @NotNull
    KotlinTypeInfo resolveImplicitArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false, true);
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessGetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context, context.trace, true, false);
    }

    @NotNull
    private KotlinTypeInfo resolveArrayAccessSpecialMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @Nullable KtExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet, boolean isImplicit) {
        KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (arrayExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(oldContext);
        }
        KotlinTypeInfo arrayTypeInfo = this.facade.safeGetTypeInfo(arrayExpression, (ExpressionTypingContext)((ExpressionTypingContext)oldContext.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        KotlinType arrayType = ExpressionTypingUtils.safeGetType(arrayTypeInfo);
        ExpressionTypingContext context = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(arrayTypeInfo.getDataFlowInfo());
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(arrayExpression, arrayType, context.trace.getBindingContext());
        if (!isGet) assert (rightHandSide != null);
        Call call2 = isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide, Call.CallType.ARRAY_SET_METHOD);
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.components.callResolver.resolveCallWithGivenName(context, call2, arrayAccessExpression, isGet ? OperatorNameConventions.GET : OperatorNameConventions.SET);
        List<KtExpression> indices = arrayAccessExpression.getIndexExpressions();
        KotlinTypeInfo resultTypeInfo = arrayTypeInfo;
        if (!indices.isEmpty()) {
            resultTypeInfo = this.facade.getTypeInfo(indices.get(indices.size() - 1), context);
        }
        if (!isGet) {
            resultTypeInfo = this.facade.getTypeInfo(rightHandSide, context);
        }
        if (isImplicit && !functionResults.isSuccess() || !functionResults.isSingleResult()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            return resultTypeInfo.clearType();
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        return resultTypeInfo.replaceType(functionResults.getResultingDescriptor().getReturnType());
    }
}

