/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class ControlStructureTypingUtils {
    private static final Logger LOG = Logger.getInstance(ControlStructureTypingUtils.class);
    private final CallResolver callResolver;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final ModuleDescriptor moduleDescriptor;

    public ControlStructureTypingUtils(@NotNull CallResolver callResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull ModuleDescriptor moduleDescriptor) {
        this.callResolver = callResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.moduleDescriptor = moduleDescriptor;
    }

    ResolvedCall<FunctionDescriptor> resolveSpecialConstructionAsCall(@NotNull Call call2, @NotNull ResolveConstruct construct, @NotNull List<String> argumentNames, @NotNull List<Boolean> isArgumentNullable, @NotNull ExpressionTypingContext context, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        SimpleFunctionDescriptorImpl function2 = this.createFunctionDescriptorForSpecialConstruction(construct, argumentNames, isArgumentNullable);
        TracingStrategy tracing = this.createTracingForSpecialConstruction(call2, construct.getName(), context);
        TypeSubstitutor knownTypeParameterSubstitutor = ControlStructureTypingUtils.createKnownTypeParameterSubstitutorForSpecialCall(construct, function2, context.expectedType, context.languageVersionSettings);
        ResolutionCandidate<FunctionDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, function2, knownTypeParameterSubstitutor);
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveCallWithKnownCandidate(call2, tracing, context, resolutionCandidate, dataFlowInfoForArguments);
        assert (results.isSingleResult()) : "Not single result after resolving one known candidate";
        return results.getResultingCall();
    }

    @Nullable
    private static TypeSubstitutor createKnownTypeParameterSubstitutorForSpecialCall(@NotNull ResolveConstruct construct, @NotNull SimpleFunctionDescriptorImpl function2, @NotNull KotlinType expectedType, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (languageVersionSettings.supportsFeature(LanguageFeature.NewInference) || construct == ResolveConstruct.ELVIS || TypeUtils.noExpectedType(expectedType) || TypeUtils.isDontCarePlaceholder(expectedType) || KotlinBuiltIns.isUnitOrNullableUnit(expectedType) || KotlinBuiltIns.isAnyOrNullableAny(expectedType)) {
            return null;
        }
        TypeConstructor typeParameterConstructor = function2.getTypeParameters().get(0).getTypeConstructor();
        TypeProjectionImpl typeProjection = new TypeProjectionImpl(expectedType);
        return TypeSubstitutor.create(ImmutableMap.of(typeParameterConstructor, typeProjection));
    }

    private SimpleFunctionDescriptorImpl createFunctionDescriptorForSpecialConstruction(@NotNull ResolveConstruct construct, @NotNull List<String> argumentNames, @NotNull List<Boolean> isArgumentNullable) {
        assert (argumentNames.size() == isArgumentNullable.size());
        SimpleFunctionDescriptorImpl function2 = SimpleFunctionDescriptorImpl.create(this.moduleDescriptor, Annotations.Companion.getEMPTY(), construct.getSpecialFunctionName(), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE);
        TypeParameterDescriptor typeParameter = TypeParameterDescriptorImpl.createWithDefaultBound(function2, Annotations.Companion.getEMPTY(), false, Variance.INVARIANT, construct.getSpecialTypeParameterName(), 0);
        SimpleType type2 = typeParameter.getDefaultType();
        KotlinType nullableType = TypeUtils.makeNullable(type2);
        ArrayList<ValueParameterDescriptorImpl> valueParameters2 = new ArrayList<ValueParameterDescriptorImpl>(argumentNames.size());
        for (int i = 0; i < argumentNames.size(); ++i) {
            KotlinType argumentType = isArgumentNullable.get(i) != false ? nullableType : type2;
            ValueParameterDescriptorImpl valueParameter = new ValueParameterDescriptorImpl(function2, null, i, Annotations.Companion.getEMPTY(), Name.identifier(argumentNames.get(i)), argumentType, false, false, false, null, SourceElement.NO_SOURCE);
            valueParameters2.add(valueParameter);
        }
        SimpleType returnType2 = construct != ResolveConstruct.ELVIS ? type2 : TypeUtilsKt.replaceAnnotations(type2, AnnotationsForResolveKt.getExactInAnnotations());
        function2.initialize((ReceiverParameterDescriptor)null, (ReceiverParameterDescriptor)null, Lists.newArrayList(typeParameter), valueParameters2, (KotlinType)returnType2, Modality.FINAL, Visibilities.PUBLIC);
        return function2;
    }

    private static MutableDataFlowInfoForArguments createIndependentDataFlowInfoForArgumentsForCall(@NotNull DataFlowInfo initialDataFlowInfo, @NotNull Map<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap) {
        return new ControlStructureDataFlowInfo(initialDataFlowInfo, dataFlowInfoForArgumentsMap);
    }

    public static MutableDataFlowInfoForArguments createDataFlowInfoForArgumentsForIfCall(@NotNull Call callForIf, @NotNull DataFlowInfo conditionInfo, @NotNull DataFlowInfo thenInfo, @NotNull DataFlowInfo elseInfo) {
        HashMap<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap = new HashMap<ValueArgument, DataFlowInfo>();
        dataFlowInfoForArgumentsMap.put(callForIf.getValueArguments().get(0), thenInfo);
        dataFlowInfoForArgumentsMap.put(callForIf.getValueArguments().get(1), elseInfo);
        return ControlStructureTypingUtils.createIndependentDataFlowInfoForArgumentsForCall(conditionInfo, dataFlowInfoForArgumentsMap);
    }

    public static MutableDataFlowInfoForArguments createDataFlowInfoForArgumentsOfWhenCall(@NotNull Call callForWhen, @NotNull DataFlowInfo subjectDataFlowInfo, @NotNull List<DataFlowInfo> entryDataFlowInfos) {
        HashMap<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap = new HashMap<ValueArgument, DataFlowInfo>();
        int i = 0;
        for (ValueArgument valueArgument : callForWhen.getValueArguments()) {
            DataFlowInfo entryDataFlowInfo = entryDataFlowInfos.get(i++);
            dataFlowInfoForArgumentsMap.put(valueArgument, entryDataFlowInfo);
        }
        return ControlStructureTypingUtils.createIndependentDataFlowInfoForArgumentsForCall(subjectDataFlowInfo, dataFlowInfoForArgumentsMap);
    }

    static Call createCallForSpecialConstruction(final @NotNull KtExpression expression2, final @NotNull KtExpression calleeExpression, @NotNull List<? extends KtExpression> arguments2) {
        final ArrayList<ValueArgument> valueArguments = Lists.newArrayList();
        for (KtExpression ktExpression : arguments2) {
            valueArguments.add(CallMaker.makeValueArgument(ktExpression));
        }
        return new Call(){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return expression2.getNode();
            }

            @Override
            @Nullable
            public ReceiverValue getExplicitReceiver() {
                return null;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return calleeExpression;
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                return valueArguments;
            }

            @NotNull
            public List<LambdaArgument> getFunctionLiteralArguments() {
                return Collections.emptyList();
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                return expression2;
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                return Call.CallType.DEFAULT;
            }
        };
    }

    @NotNull
    private TracingStrategy createTracingForSpecialConstruction(final @NotNull Call call2, @NotNull String constructionName, final @NotNull ExpressionTypingContext context) {
        class CheckTypeContext {
            public BindingTrace trace;
            public KotlinType expectedType;

            CheckTypeContext(@NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
                this.trace = trace;
                this.expectedType = expectedType;
            }

            CheckTypeContext makeTypeNullable() {
                if (TypeUtils.noExpectedType(this.expectedType)) {
                    return this;
                }
                return new CheckTypeContext(this.trace, TypeUtils.makeNullable(this.expectedType));
            }
        }
        final KtVisitor<Boolean, CheckTypeContext> checkTypeVisitor = new KtVisitor<Boolean, CheckTypeContext>(){

            private boolean checkExpressionType(@NotNull KtExpression expression2, CheckTypeContext c) {
                KotlinTypeInfo typeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, c.trace.getBindingContext());
                if (typeInfo == null) {
                    return false;
                }
                Ref<Boolean> hasError = Ref.create();
                ControlStructureTypingUtils.this.dataFlowAnalyzer.checkType(typeInfo.getType(), expression2, (ResolutionContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(c.expectedType)).replaceDataFlowInfo(typeInfo.getDataFlowInfo())).replaceBindingTrace(c.trace), hasError, true);
                return hasError.get();
            }

            private boolean checkExpressionTypeRecursively(@Nullable KtExpression expression2, CheckTypeContext c) {
                if (expression2 == null) {
                    return false;
                }
                return expression2.accept(this, c);
            }

            private boolean checkSubExpressions(KtExpression firstSub, KtExpression secondSub, KtExpression expression2, CheckTypeContext firstContext, CheckTypeContext secondContext, CheckTypeContext context2) {
                boolean errorWasReported = this.checkExpressionTypeRecursively(firstSub, firstContext);
                return (errorWasReported |= this.checkExpressionTypeRecursively(secondSub, secondContext)) || this.checkExpressionType(expression2, context2);
            }

            @Override
            public Boolean visitWhenExpression(@NotNull KtWhenExpression whenExpression, CheckTypeContext c) {
                boolean errorWasReported = false;
                for (KtWhenEntry whenEntry : whenExpression.getEntries()) {
                    KtExpression entryExpression = whenEntry.getExpression();
                    if (entryExpression == null) continue;
                    errorWasReported |= this.checkExpressionTypeRecursively(entryExpression, c);
                }
                return errorWasReported |= this.checkExpressionType(whenExpression, c);
            }

            @Override
            public Boolean visitIfExpression(@NotNull KtIfExpression ifExpression, CheckTypeContext c) {
                KtExpression thenBranch = ifExpression.getThen();
                KtExpression elseBranch = ifExpression.getElse();
                if (thenBranch == null || elseBranch == null) {
                    return this.checkExpressionType(ifExpression, c);
                }
                return this.checkSubExpressions(thenBranch, elseBranch, ifExpression, c, c, c);
            }

            @Override
            public Boolean visitBlockExpression(@NotNull KtBlockExpression expression2, CheckTypeContext c) {
                if (expression2.getStatements().isEmpty()) {
                    return this.checkExpressionType(expression2, c);
                }
                KtExpression lastStatement = KtPsiUtil.getLastStatementInABlock(expression2);
                if (lastStatement != null) {
                    return this.checkExpressionTypeRecursively(lastStatement, c);
                }
                return false;
            }

            @Override
            public Boolean visitPostfixExpression(@NotNull KtPostfixExpression expression2, CheckTypeContext c) {
                if (expression2.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL) {
                    return this.checkExpressionTypeRecursively(expression2.getBaseExpression(), c.makeTypeNullable());
                }
                return (Boolean)super.visitPostfixExpression(expression2, c);
            }

            @Override
            public Boolean visitBinaryExpression(@NotNull KtBinaryExpression expression2, CheckTypeContext c) {
                if (expression2.getOperationReference().getReferencedNameElementType() == KtTokens.ELVIS) {
                    return this.checkSubExpressions(expression2.getLeft(), expression2.getRight(), expression2, c.makeTypeNullable(), c, c);
                }
                return (Boolean)super.visitBinaryExpression(expression2, c);
            }

            @Override
            public Boolean visitExpression(@NotNull KtExpression expression2, CheckTypeContext c) {
                return this.checkExpressionType(expression2, c);
            }
        };
        return new ThrowingOnErrorTracingStrategy("resolve " + constructionName + " as a call"){

            @Override
            public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
            }

            @Override
            public void bindCall(@NotNull BindingTrace trace, @NotNull Call call22) {
                trace.record(BindingContext.CALL, call22.getCalleeExpression(), call22);
            }

            @Override
            public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
                trace.record(BindingContext.RESOLVED_CALL, call2, resolvedCall2);
            }

            @Override
            public void typeInferenceFailed(@NotNull ResolutionContext<?> context, @NotNull InferenceErrorData data2) {
                ConstraintSystem constraintSystem = data2.constraintSystem;
                ConstraintSystemStatus status2 = constraintSystem.getStatus();
                assert (!status2.isSuccessful()) : "Report error only for not successful constraint system";
                if (status2.hasErrorInConstrainingTypes() || status2.hasUnknownParameters()) {
                    return;
                }
                KtExpression expression2 = (KtExpression)call2.getCallElement();
                if (status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION) || status2.hasConflictingConstraints() || status2.hasTypeInferenceIncorporationError()) {
                    KtExpression calleeExpression;
                    if (this.noTypeCheckingErrorsInExpression(expression2, context.trace, data2.expectedType) && ((calleeExpression = call2.getCalleeExpression()) instanceof KtWhenExpression || calleeExpression instanceof KtIfExpression) && (status2.hasConflictingConstraints() || status2.hasTypeInferenceIncorporationError())) {
                        context.trace.report(Errors.TYPE_INFERENCE_FAILED_ON_SPECIAL_CONSTRUCT.on(expression2));
                    }
                    return;
                }
                KtDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)expression2, KtNamedDeclaration.class);
                this.logError("Expression: " + (parentDeclaration != null ? parentDeclaration.getText() : expression2.getText()) + "\nConstraint system status: \n" + ConstraintsUtil.getDebugMessageForStatus(status2));
            }

            private boolean noTypeCheckingErrorsInExpression(KtExpression expression2, @NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
                return Boolean.TRUE != expression2.accept(checkTypeVisitor, new CheckTypeContext(trace, expectedType));
            }
        };
    }

    private static abstract class ThrowingOnErrorTracingStrategy
    implements TracingStrategy {
        private final String debugName;

        protected ThrowingOnErrorTracingStrategy(String debugName) {
            this.debugName = debugName;
        }

        private void logError() {
            this.logError(null);
        }

        protected void logError(@Nullable String additionalInformation) {
            String errorMessage = "Resolution error of this type shouldn't occur for " + this.debugName;
            if (additionalInformation != null) {
                errorMessage = errorMessage + ".\n" + additionalInformation;
            }
            LOG.error(errorMessage);
        }

        @Override
        public void unresolvedReference(@NotNull BindingTrace trace) {
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
            this.logError();
        }

        @Override
        public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
            this.logError();
        }

        @Override
        public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, @NotNull ResolutionContext<?> c) {
            this.logError();
        }

        @Override
        public void noReceiverAllowed(@NotNull BindingTrace trace) {
            this.logError();
        }

        @Override
        public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
            this.logError();
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount, @NotNull CallableDescriptor descriptor2) {
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
            this.logError();
        }

        @Override
        public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
            this.logError();
        }

        @Override
        public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
            this.logError();
        }

        @Override
        public void abstractSuperCall(@NotNull BindingTrace trace) {
            this.logError();
        }

        @Override
        public void nestedClassAccessViaInstanceReference(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor2, @NotNull ExplicitReceiverKind explicitReceiverKind) {
            this.logError();
        }

        @Override
        public void unsafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, boolean isCallForImplicitInvoke) {
            this.logError();
        }

        @Override
        public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor2) {
            this.logError();
        }

        @Override
        public void typeInferenceFailed(@NotNull ResolutionContext<?> context, @NotNull InferenceErrorData inferenceErrorData) {
            this.logError();
        }
    }

    public static class ControlStructureDataFlowInfo
    extends MutableDataFlowInfoForArguments {
        public final Map<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap;

        ControlStructureDataFlowInfo(@NotNull DataFlowInfo initialDataFlowInfo, @NotNull Map<ValueArgument, DataFlowInfo> map2) {
            super(initialDataFlowInfo);
            this.dataFlowInfoForArgumentsMap = map2;
        }

        @Override
        public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
            this.dataFlowInfoForArgumentsMap.put(valueArgument, dataFlowInfo);
        }

        @Override
        public void updateResultInfo(@NotNull DataFlowInfo dataFlowInfo) {
        }

        @Override
        @NotNull
        public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
            return this.dataFlowInfoForArgumentsMap.get(valueArgument);
        }
    }

    public static enum ResolveConstruct {
        IF("if"),
        ELVIS("elvis"),
        EXCL_EXCL("ExclExcl"),
        WHEN("when");

        private final String name;
        private final Name specialFunctionName;
        private final Name specialTypeParameterName;

        private ResolveConstruct(String name2) {
            this.name = name2;
            this.specialFunctionName = Name.identifier("<SPECIAL-FUNCTION-FOR-" + name2.toUpperCase() + "-RESOLVE>");
            this.specialTypeParameterName = Name.identifier("<TYPE-PARAMETER-FOR-" + name2.toUpperCase() + "-RESOLVE>");
        }

        public String getName() {
            return this.name;
        }

        public Name getSpecialFunctionName() {
            return this.specialFunctionName;
        }

        public Name getSpecialTypeParameterName() {
            return this.specialTypeParameterName;
        }
    }
}

