/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequenceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0002\u001a\u00020\u0001\u001a&\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u000b\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0002\u001a\u00020\u0001\u001a)\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u0011*\b\u0012\u0004\u0012\u0002H\u00100\u00122\b\u0010\u0013\u001a\u0004\u0018\u0001H\u0010\u00a2\u0006\u0002\u0010\u0014\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0016\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u0017\u001a@\u0010\u0018\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u00192\u0006\u0010\u001a\u001a\u0002H\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001cH\u0086\b\u00a2\u0006\u0002\u0010\u001d\u001a6\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u0010\"\u000e\b\u0001\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u00100 *\u0002H\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001cH\u0086\b\u00a2\u0006\u0002\u0010\"\u001aB\u0010\u001e\u001a\u0002H#\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0014\b\u0002\u0010#*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060$*\u0002H#2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\u001cH\u0086\b\u00a2\u0006\u0002\u0010%\u001a>\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00100&\"\u0004\b\u0000\u0010\u0010*\n\u0012\u0006\b\u0001\u0012\u0002H\u00100&2\u0014\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00100&0\u001cH\u0086\b\u00a2\u0006\u0002\u0010'\u001a2\u0010(\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u00162\u0006\u0010)\u001a\u00020\u00012\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020,0+\u001a<\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060$\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00050.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060+\u001aB\u00100\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060$\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010\u0006*\u00020\u0011*\b\u0012\u0004\u0012\u0002H\u00050.2\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u00060+\u001a\"\u00101\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00010$\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050.\u001a/\u00102\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u0011*\b\u0012\u0004\u0012\u0002H\u0010032\b\u0010\u0013\u001a\u0004\u0018\u0001H\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00065"}, d2={"capacity", "", "expectedSize", "newHashMapWithExpectedSize", "Ljava/util/HashMap;", "K", "V", "newHashSetWithExpectedSize", "Ljava/util/HashSet;", "E", "newLinkedHashMapWithExpectedSize", "Ljava/util/LinkedHashMap;", "newLinkedHashSetWithExpectedSize", "Ljava/util/LinkedHashSet;", "addIfNotNull", "", "T", "", "", "t", "(Ljava/util/Collection;Ljava/lang/Object;)V", "compact", "", "Ljava/util/ArrayList;", "getOrPutNullable", "", "key", "defaultValue", "Lkotlin/Function0;", "(Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ifEmpty", "C", "", "body", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function0;)Ljava/util/Collection;", "M", "", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;)Ljava/util/Map;", "", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)[Ljava/lang/Object;", "indexOfFirst", "startFrom", "predicate", "Lkotlin/Function1;", "", "keysToMap", "", "value", "keysToMapExceptNulls", "mapToIndex", "yieldIfNotNull", "Lkotlin/sequences/SequenceScope;", "(Lkotlin/sequences/SequenceScope;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "util.runtime"})
public final class CollectionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> keysToMap(@NotNull Iterable<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value2) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        Iterable<? extends K> $receiver$iv = $receiver;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        Iterable<? extends K> iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator2.next();
            Map map2 = destination$iv$iv;
            void var13_10 = it;
            map2.put(var13_10, value2.invoke(element$iv$iv));
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(@NotNull Iterable<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value2) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (K k : $receiver) {
            V v2 = value2.invoke(k);
            if (v2 == null) continue;
            Map map3 = map2;
            V v3 = v2;
            map3.put(k, v3);
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(@NotNull Iterable<? extends K> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        LinkedHashMap map2 = new LinkedHashMap();
        boolean bl = false;
        for (K k : $receiver) {
            void index2;
            Map map3 = map2;
            Integer n = (int)index2;
            map3.put(k, n);
            ++index2;
        }
        return map2;
    }

    public static final <K, V> V getOrPutNullable(@NotNull Map<K, V> $receiver, K key, @NotNull Function0<? extends V> defaultValue) {
        V v2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(defaultValue, "defaultValue");
        if (!$receiver.containsKey(key)) {
            V answer = defaultValue.invoke();
            $receiver.put(key, answer);
            v2 = answer;
        } else {
            v2 = $receiver.get(key);
        }
        return v2;
    }

    @NotNull
    public static final <T, C extends Collection<? extends T>> C ifEmpty(@NotNull C $receiver, @NotNull Function0<? extends C> body) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(body, "body");
        return (C)($receiver.isEmpty() ? (Collection)body.invoke() : $receiver);
    }

    @NotNull
    public static final <K, V, M extends Map<K, ? extends V>> M ifEmpty(@NotNull M $receiver, @NotNull Function0<? extends M> body) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(body, "body");
        return (M)($receiver.isEmpty() ? (Map)body.invoke() : $receiver);
    }

    @NotNull
    public static final <T> T[] ifEmpty(@NotNull T[] $receiver, @NotNull Function0<? extends T[]> body) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(body, "body");
        T[] TArray = $receiver;
        return TArray.length == 0 ? body.invoke() : $receiver;
    }

    public static final <T> void addIfNotNull(@NotNull Collection<T> $receiver, @Nullable T t) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        if (t != null) {
            $receiver.add(t);
        }
    }

    @Nullable
    public static final <T> Object yieldIfNotNull(@NotNull SequenceScope<? super T> $receiver, @Nullable T t, @NotNull Continuation<? super Unit> continuation2) {
        if (t != null) {
            return $receiver.yield(t, continuation2);
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(CollectionsKt.capacity(expectedSize));
    }

    private static final int capacity(int expectedSize) {
        return expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1;
    }

    @NotNull
    public static final <T> List<T> compact(@NotNull ArrayList<T> $receiver) {
        List list2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        switch ($receiver.size()) {
            case 0: {
                list2 = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list2 = kotlin.collections.CollectionsKt.listOf(kotlin.collections.CollectionsKt.first((List)$receiver));
                break;
            }
            default: {
                ArrayList<T> arrayList;
                ArrayList<T> $receiver2 = arrayList = $receiver;
                $receiver2.trimToSize();
                list2 = arrayList;
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> int indexOfFirst(@NotNull List<? extends T> $receiver, int startFrom, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        int n = startFrom;
        int n2 = kotlin.collections.CollectionsKt.getLastIndex($receiver);
        if (n <= n2) {
            while (true) {
                void index2;
                if (predicate.invoke($receiver.get((int)index2)).booleanValue()) {
                    return (int)index2;
                }
                if (index2 == n2) break;
                ++index2;
            }
        }
        return -1;
    }
}

