/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.commons;

import java.util.Stack;
import org.jetbrains.org.objectweb.asm.commons.Remapper;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

public class SignatureRemapper
extends SignatureVisitor {
    private final SignatureVisitor v;
    private final Remapper remapper;
    private Stack<String> classNames = new Stack();

    public SignatureRemapper(SignatureVisitor v2, Remapper remapper2) {
        this(393216, v2, remapper2);
    }

    protected SignatureRemapper(int api, SignatureVisitor v2, Remapper remapper2) {
        super(api);
        this.v = v2;
        this.remapper = remapper2;
    }

    public void visitClassType(String name2) {
        this.classNames.push(name2);
        this.v.visitClassType(this.remapper.mapType(name2));
    }

    public void visitInnerClassType(String name2) {
        String outerClassName = this.classNames.pop();
        String className2 = outerClassName + '$' + name2;
        this.classNames.push(className2);
        String remappedOuter = this.remapper.mapType(outerClassName) + '$';
        String remappedName = this.remapper.mapType(className2);
        int index2 = remappedName.startsWith(remappedOuter) ? remappedOuter.length() : remappedName.lastIndexOf(36) + 1;
        this.v.visitInnerClassType(remappedName.substring(index2));
    }

    public void visitFormalTypeParameter(String name2) {
        this.v.visitFormalTypeParameter(name2);
    }

    public void visitTypeVariable(String name2) {
        this.v.visitTypeVariable(name2);
    }

    public SignatureVisitor visitArrayType() {
        this.v.visitArrayType();
        return this;
    }

    public void visitBaseType(char descriptor2) {
        this.v.visitBaseType(descriptor2);
    }

    public SignatureVisitor visitClassBound() {
        this.v.visitClassBound();
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.v.visitExceptionType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.v.visitInterface();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.v.visitInterfaceBound();
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.v.visitParameterType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.v.visitReturnType();
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.v.visitSuperclass();
        return this;
    }

    public void visitTypeArgument() {
        this.v.visitTypeArgument();
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        this.v.visitTypeArgument(wildcard);
        return this;
    }

    public void visitEnd() {
        this.v.visitEnd();
        this.classNames.pop();
    }
}

