/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public List<Object> values;

    public AnnotationNode(String desc) {
        this(393216, desc);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }

    public AnnotationNode(int api, String desc) {
        super(api);
        this.desc = desc;
    }

    AnnotationNode(List<Object> values2) {
        super(393216);
        this.values = values2;
    }

    @Override
    public void visit(String name2, Object value2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        if (value2 instanceof byte[]) {
            byte[] v2 = (byte[])value2;
            ArrayList<Byte> l = new ArrayList<Byte>(v2.length);
            for (byte b : v2) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value2 instanceof boolean[]) {
            boolean[] v3 = (boolean[])value2;
            ArrayList<Boolean> l = new ArrayList<Boolean>(v3.length);
            for (boolean b : v3) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value2 instanceof short[]) {
            short[] v4 = (short[])value2;
            ArrayList<Short> l = new ArrayList<Short>(v4.length);
            for (short s : v4) {
                l.add(s);
            }
            this.values.add(l);
        } else if (value2 instanceof char[]) {
            char[] v5 = (char[])value2;
            ArrayList<Character> l = new ArrayList<Character>(v5.length);
            for (char c : v5) {
                l.add(Character.valueOf(c));
            }
            this.values.add(l);
        } else if (value2 instanceof int[]) {
            int[] v6 = (int[])value2;
            ArrayList<Integer> l = new ArrayList<Integer>(v6.length);
            for (int i : v6) {
                l.add(i);
            }
            this.values.add(l);
        } else if (value2 instanceof long[]) {
            long[] v7 = (long[])value2;
            ArrayList<Long> l = new ArrayList<Long>(v7.length);
            for (long lng : v7) {
                l.add(lng);
            }
            this.values.add(l);
        } else if (value2 instanceof float[]) {
            float[] v8 = (float[])value2;
            ArrayList<Float> l = new ArrayList<Float>(v8.length);
            for (float f : v8) {
                l.add(Float.valueOf(f));
            }
            this.values.add(l);
        } else if (value2 instanceof double[]) {
            double[] v9 = (double[])value2;
            ArrayList<Double> l = new ArrayList<Double>(v9.length);
            for (double d : v9) {
                l.add(d);
            }
            this.values.add(l);
        } else {
            this.values.add(value2);
        }
    }

    @Override
    public void visitEnum(String name2, String desc, String value2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        this.values.add(new String[]{desc, value2});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name2, String desc) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        AnnotationNode annotation2 = new AnnotationNode(desc);
        this.values.add(annotation2);
        return annotation2;
    }

    @Override
    public AnnotationVisitor visitArray(String name2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        ArrayList<Object> array2 = new ArrayList<Object>();
        this.values.add(array2);
        return new AnnotationNode(array2);
    }

    @Override
    public void visitEnd() {
    }

    public void check(int api) {
    }

    public void accept(AnnotationVisitor av) {
        if (av != null) {
            if (this.values != null) {
                for (int i = 0; i < this.values.size(); i += 2) {
                    String name2 = (String)this.values.get(i);
                    Object value2 = this.values.get(i + 1);
                    AnnotationNode.accept(av, name2, value2);
                }
            }
            av.visitEnd();
        }
    }

    static void accept(AnnotationVisitor av, String name2, Object value2) {
        if (av != null) {
            if (value2 instanceof String[]) {
                String[] typeconst = (String[])value2;
                av.visitEnum(name2, typeconst[0], typeconst[1]);
            } else if (value2 instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)value2;
                an.accept(av.visitAnnotation(name2, an.desc));
            } else if (value2 instanceof List) {
                AnnotationVisitor v2 = av.visitArray(name2);
                if (v2 != null) {
                    List array2 = (List)value2;
                    for (int j = 0; j < array2.size(); ++j) {
                        AnnotationNode.accept(v2, null, array2.get(j));
                    }
                    v2.visitEnd();
                }
            } else {
                av.visit(name2, value2);
            }
        }
    }
}

