/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.lang.reflect.Proxy;
import java.util.Objects;
import org.jline.utils.Log;

public final class Signals {
    public static Object register(String name2, Runnable handler2) {
        Objects.requireNonNull(handler2);
        return Signals.register(name2, handler2, handler2.getClass().getClassLoader());
    }

    public static Object register(String name2, Runnable handler2, ClassLoader loader) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            Object signalHandler = Proxy.newProxyInstance(loader, new Class[]{signalHandlerClass}, (proxy2, method, args) -> {
                if (method.getDeclaringClass() == Object.class) {
                    if ("toString".equals(method.getName())) {
                        return handler2.toString();
                    }
                } else if (method.getDeclaringClass() == signalHandlerClass) {
                    Log.trace(() -> "Calling handler " + Signals.toString(handler2) + " for signal " + name2);
                    handler2.run();
                }
                return null;
            });
            return Signals.doRegister(name2, signalHandler);
        }
        catch (Exception e) {
            Log.debug("Error registering handler for signal ", name2, e);
            return null;
        }
    }

    public static Object registerDefault(String name2) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            return Signals.doRegister(name2, signalHandlerClass.getField("SIG_DFL").get(null));
        }
        catch (Exception e) {
            Log.debug("Error registering default handler for signal ", name2, e);
            return null;
        }
    }

    public static void unregister(String name2, Object previous) {
        try {
            if (previous != null) {
                Signals.doRegister(name2, previous);
            }
        }
        catch (Exception e) {
            Log.debug("Error unregistering handler for signal ", name2, e);
        }
    }

    private static Object doRegister(String name2, Object handler2) throws Exception {
        Log.trace(() -> "Registering signal " + name2 + " with handler " + Signals.toString(handler2));
        if ("QUIT".equals(name2) || "INFO".equals(name2) && "9".equals(System.getProperty("java.specification.version"))) {
            Log.trace(() -> "Ignoring unsupported signal " + name2);
            return null;
        }
        Class<?> signalClass = Class.forName("sun.misc.Signal");
        Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
        Object signal = signalClass.getConstructor(String.class).newInstance(name2);
        return signalClass.getMethod("handle", signalClass, signalHandlerClass).invoke(null, signal, handler2);
    }

    private static String toString(Object handler2) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            if (handler2 == signalHandlerClass.getField("SIG_DFL").get(null)) {
                return "SIG_DFL";
            }
            if (handler2 == signalHandlerClass.getField("SIG_IGN").get(null)) {
                return "SIG_IGN";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return handler2 != null ? handler2.toString() : "null";
    }
}

