/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.framework;

import com.jetbrains.rider.framework.AbstractBuffer;
import com.jetbrains.rider.framework.ISerializer;
import com.jetbrains.rider.framework.SerializationCtx;
import com.jetbrains.rider.util.reactive.RdFault;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0004\n\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J)\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0000\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00050\u0007H\u0086\bJ\u000b\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\t\u0082\u0001\u0003\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/framework/RdTaskResult;", "T", "", "()V", "map", "R", "transform", "Lkotlin/Function1;", "unwrap", "()Ljava/lang/Object;", "Cancelled", "Companion", "Fault", "Success", "Lcom/jetbrains/rider/framework/RdTaskResult$Success;", "Lcom/jetbrains/rider/framework/RdTaskResult$Cancelled;", "Lcom/jetbrains/rider/framework/RdTaskResult$Fault;", "rd-framework"})
public abstract class RdTaskResult<T> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final <R> RdTaskResult<R> map(@NotNull Function1<? super T, ? extends R> transform) {
        RdTaskResult rdTaskResult;
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        RdTaskResult rdTaskResult2 = this;
        if (rdTaskResult2 instanceof Success) {
            rdTaskResult = new Success<Object>(transform.invoke(((Success)this).getValue()));
        } else if (rdTaskResult2 instanceof Cancelled) {
            rdTaskResult = new Cancelled();
        } else if (rdTaskResult2 instanceof Fault) {
            rdTaskResult = new Fault((Throwable)((Fault)this).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rdTaskResult;
    }

    public final T unwrap() {
        RdTaskResult rdTaskResult = this;
        if (!(rdTaskResult instanceof Success)) {
            if (rdTaskResult instanceof Cancelled) {
                throw (Throwable)new CancellationException("Task finished in Cancelled state");
            }
            if (rdTaskResult instanceof Fault) {
                throw (Throwable)((Fault)this).getError();
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((Success)this).getValue();
    }

    private RdTaskResult() {
    }

    public /* synthetic */ RdTaskResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/framework/RdTaskResult$Success;", "T", "Lcom/jetbrains/rider/framework/RdTaskResult;", "value", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "rd-framework"})
    public static final class Success<T>
    extends RdTaskResult<T> {
        private final T value;

        public final T getValue() {
            return this.value;
        }

        public Success(T value2) {
            super(null);
            this.value = value2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/rider/framework/RdTaskResult$Cancelled;", "T", "Lcom/jetbrains/rider/framework/RdTaskResult;", "()V", "rd-framework"})
    public static final class Cancelled<T>
    extends RdTaskResult<T> {
        public Cancelled() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/framework/RdTaskResult$Fault;", "T", "Lcom/jetbrains/rider/framework/RdTaskResult;", "e", "", "(Ljava/lang/Throwable;)V", "error", "Lcom/jetbrains/rider/util/reactive/RdFault;", "(Lcom/jetbrains/rider/util/reactive/RdFault;)V", "getError", "()Lcom/jetbrains/rider/util/reactive/RdFault;", "rd-framework"})
    public static final class Fault<T>
    extends RdTaskResult<T> {
        @NotNull
        private final RdFault error;

        @NotNull
        public final RdFault getError() {
            return this.error;
        }

        private Fault(RdFault error) {
            super(null);
            this.error = error;
        }

        public Fault(@NotNull Throwable e) {
            RdFault rdFault;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Throwable throwable = e;
            if (!(throwable instanceof RdFault)) {
                throwable = null;
            }
            if ((rdFault = (RdFault)throwable) == null) {
                rdFault = new RdFault(e);
            }
            this(rdFault);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000bJ8\u0010\f\u001a\u00020\r\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/framework/RdTaskResult$Companion;", "", "()V", "read", "Lcom/jetbrains/rider/framework/RdTaskResult;", "T", "ctx", "Lcom/jetbrains/rider/framework/SerializationCtx;", "buffer", "Lcom/jetbrains/rider/framework/AbstractBuffer;", "serializer", "Lcom/jetbrains/rider/framework/ISerializer;", "write", "", "value", "rd-framework"})
    public static final class Companion {
        @NotNull
        public final <T> RdTaskResult<T> read(@NotNull SerializationCtx ctx, @NotNull AbstractBuffer buffer, @NotNull ISerializer<T> serializer) {
            RdTaskResult rdTaskResult;
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
            int kind = buffer.readInt();
            switch (kind) {
                case 0: {
                    rdTaskResult = new Success<T>(serializer.read(ctx, buffer));
                    break;
                }
                case 1: {
                    rdTaskResult = new Cancelled();
                    break;
                }
                case 2: {
                    String reasonTypeFqn = buffer.readString();
                    String reasonMessage = buffer.readString();
                    String reasonAsText = buffer.readString();
                    rdTaskResult = new Fault((Throwable)new RdFault(reasonTypeFqn, reasonMessage, reasonAsText, null, 8, null));
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException(String.valueOf(kind));
                }
            }
            return rdTaskResult;
        }

        public final <T> void write(@NotNull SerializationCtx ctx, @NotNull AbstractBuffer buffer, @NotNull RdTaskResult<? extends T> value2, @NotNull ISerializer<T> serializer) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull(value2, (String)"value");
            Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
            RdTaskResult<? extends T> rdTaskResult = value2;
            if (rdTaskResult instanceof Success) {
                buffer.writeInt(0);
                serializer.write(ctx, buffer, ((Success)value2).getValue());
            } else if (rdTaskResult instanceof Cancelled) {
                buffer.writeInt(1);
            } else if (rdTaskResult instanceof Fault) {
                buffer.writeInt(2);
                buffer.writeString(((Fault)value2).getError().getReasonTypeFqn());
                buffer.writeString(((Fault)value2).getError().getReasonMessage());
                buffer.writeString(((Fault)value2).getError().getReasonAsText());
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

