/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.VectorDrawablesOptions;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import java.util.Objects;
import java.util.Set;

public final class IdeVectorDrawablesOptions
extends IdeModel
implements VectorDrawablesOptions {
    private static final long serialVersionUID = 1L;
    private final Set<String> myGeneratedDensities;
    private final Boolean myUseSupportLibrary;
    private final int myHashCode;

    public IdeVectorDrawablesOptions(VectorDrawablesOptions options, ModelCache modelCache) {
        super(options, modelCache);
        this.myGeneratedDensities = IdeVectorDrawablesOptions.copy(options.getGeneratedDensities());
        this.myUseSupportLibrary = options.getUseSupportLibrary();
        this.myHashCode = this.calculateHashCode();
    }

    public Set<String> getGeneratedDensities() {
        return this.myGeneratedDensities;
    }

    public Boolean getUseSupportLibrary() {
        return this.myUseSupportLibrary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeVectorDrawablesOptions)) {
            return false;
        }
        IdeVectorDrawablesOptions options = (IdeVectorDrawablesOptions)o;
        return Objects.equals(this.myGeneratedDensities, options.myGeneratedDensities) && Objects.equals(this.myUseSupportLibrary, options.myUseSupportLibrary);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myGeneratedDensities, this.myUseSupportLibrary);
    }

    public String toString() {
        return "IdeVectorDrawablesOptions{myGeneratedDensities=" + this.myGeneratedDensities + ", myUseSupportLibrary=" + this.myUseSupportLibrary + "}";
    }
}

