/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class ResourceNameKeyedMap<T>
extends ForwardingMap<String, T> {
    private final Map<String, T> myDelegate;
    private final Set<String> myKeys;

    protected ResourceNameKeyedMap(Map<String, T> delegate, Set<String> keySet) {
        this.myDelegate = delegate;
        this.myKeys = keySet;
    }

    public ResourceNameKeyedMap() {
        this(Maps.newHashMap(), Sets.newHashSet());
    }

    private static boolean isInvalidResourceNameCharacter(char c) {
        return c == ':' || c == '.' || c == '-';
    }

    @VisibleForTesting
    static String flattenKey(String key) {
        if (key == null) {
            return null;
        }
        int n = key.length();
        for (int i = 0; i < n; ++i) {
            char c = key.charAt(i);
            if (!ResourceNameKeyedMap.isInvalidResourceNameCharacter(c)) continue;
            char[] buffer = new char[key.length()];
            key.getChars(0, i, buffer, 0);
            buffer[i] = 95;
            for (int j = i + 1; j < n; ++j) {
                c = key.charAt(j);
                buffer[j] = ResourceNameKeyedMap.isInvalidResourceNameCharacter(c) ? 95 : (int)c;
            }
            return new String(buffer);
        }
        return key;
    }

    protected Map<String, T> delegate() {
        return this.myDelegate;
    }

    public T put(String key, T value) {
        assert (key != null) : "ResourceValueMap does not support null keys";
        this.myKeys.add(key);
        return (T)super.put((Object)ResourceNameKeyedMap.flattenKey(key), value);
    }

    public T get(Object key) {
        assert (key != null) : "ResourceValueMap does not support null keys";
        return (T)super.get((Object)ResourceNameKeyedMap.flattenKey((String)key));
    }

    public boolean containsKey(Object key) {
        assert (key != null) : "ResourceValueMap does not support null keys";
        return super.containsKey((Object)ResourceNameKeyedMap.flattenKey((String)key));
    }

    public T remove(Object key) {
        assert (key != null) : "ResourceValueMap does not support null keys";
        this.myKeys.remove((String)key);
        return (T)super.remove((Object)ResourceNameKeyedMap.flattenKey((String)key));
    }

    public Set<String> keySet() {
        return this.myKeys;
    }
}

