/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.context;

import com.microsoft.alm.plugin.context.RepositoryContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryContextManager {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryContextManager.class);
    private Map<String, RepositoryContext> contextMap = new HashMap<String, RepositoryContext>();

    protected RepositoryContextManager() {
    }

    public static RepositoryContextManager getInstance() {
        return Holder.INSTANCE;
    }

    public synchronized void add(RepositoryContext context) {
        if (context != null) {
            String key = context.getLocalRootFolder();
            this.contextMap.put(key, context);
        }
    }

    public synchronized RepositoryContext get(String localRootFolder) {
        if (!StringUtils.isEmpty((String)localRootFolder)) {
            RepositoryContext context = this.contextMap.get(localRootFolder);
            return context;
        }
        return null;
    }

    public synchronized void remove(String localRootFolder) {
        if (StringUtils.isEmpty((String)localRootFolder)) {
            return;
        }
        this.contextMap.remove(localRootFolder);
    }

    private static class Holder {
        private static final RepositoryContextManager INSTANCE = new RepositoryContextManager();

        private Holder() {
        }
    }
}

