/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.context;

import com.microsoft.alm.build.webapi.BuildHttpClient;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.core.webapi.model.TeamProjectCollectionReference;
import com.microsoft.alm.core.webapi.model.TeamProjectReference;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.RestClientHelper;
import com.microsoft.alm.plugin.context.rest.GitHttpClientEx;
import com.microsoft.alm.plugin.context.rest.TfvcHttpClientEx;
import com.microsoft.alm.plugin.context.soap.SoapServices;
import com.microsoft.alm.plugin.context.soap.SoapServicesImpl;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRepository;
import com.microsoft.alm.workitemtracking.webapi.WorkItemTrackingHttpClient;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.glassfish.jersey.SslConfigurator;

public class ServerContext {
    private final Type type;
    private final AuthenticationInfo authenticationInfo;
    private final UUID userId;
    private final URI uri;
    private final URI serverUri;
    private CloseableHttpClient httpClient;
    private Client client;
    private SoapServices soapServices;
    private final TeamProjectCollectionReference teamProjectCollectionReference;
    private final TeamProjectReference teamProjectReference;
    private final GitRepository gitRepository;
    private boolean disposed = false;

    public static String getKey(URI uri) {
        String key = uri != null ? uri.getSchemeSpecificPart().toLowerCase() : "";
        return key;
    }

    public static String getKey(String uri) {
        ArgumentHelper.checkNotNull((Object)uri, (String)"uri");
        return ServerContext.getKey(UrlHelper.createUri((String)uri));
    }

    protected ServerContext(Type type, AuthenticationInfo authenticationInfo, UUID userId, URI uri, URI serverUri, Client client, TeamProjectCollectionReference teamProjectCollectionReference, TeamProjectReference teamProjectReference, GitRepository gitRepository) {
        ArgumentHelper.checkNotNull((Object)((Object)type), (String)"type");
        this.type = type;
        this.authenticationInfo = authenticationInfo;
        this.userId = userId;
        this.uri = uri;
        this.serverUri = serverUri;
        this.client = client;
        this.teamProjectCollectionReference = teamProjectCollectionReference;
        this.teamProjectReference = teamProjectReference;
        this.gitRepository = gitRepository;
    }

    public String getKey() {
        return ServerContext.getKey(this.uri);
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public String getUsableGitUrl() {
        GitRepository repo = this.getGitRepository();
        if (repo != null && repo.getRemoteUrl() != null) {
            return UrlHelper.getCmdLineFriendlyUrl((String)this.getGitRepository().getRemoteUrl());
        }
        return null;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public Type getType() {
        return this.type;
    }

    public synchronized boolean hasClient() {
        return this.client != null;
    }

    public synchronized Client getClient() {
        if (!this.hasClient()) {
            this.client = RestClientHelper.getClient(this.getType(), this.getAuthenticationInfo());
        }
        return this.client;
    }

    public synchronized HttpClient getHttpClient() {
        this.checkDisposed();
        if (this.httpClient == null && this.authenticationInfo != null) {
            Credentials credentials = AuthHelper.getCredentials(this.type, this.authenticationInfo);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, credentials);
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            if (RestClientHelper.isSSLEnabledOnPrem(Type.TFS, this.authenticationInfo.getServerUri())) {
                SslConfigurator sslConfigurator = RestClientHelper.getSslConfigurator();
                SSLContext sslContext = sslConfigurator.createSSLContext();
                httpClientBuilder.setSslcontext(sslContext);
            }
            this.httpClient = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        }
        return this.httpClient;
    }

    public synchronized GitHttpClientEx getGitHttpClient() {
        URI collectionUri = this.getCollectionURI();
        if (collectionUri != null) {
            GitHttpClientEx gitClient = new GitHttpClientEx(this.getClient(), collectionUri);
            return gitClient;
        }
        return null;
    }

    public synchronized WorkItemTrackingHttpClient getWitHttpClient() {
        URI collectionUri = this.getCollectionURI();
        if (collectionUri != null) {
            WorkItemTrackingHttpClient witClient = new WorkItemTrackingHttpClient(this.getClient(), collectionUri);
            return witClient;
        }
        return null;
    }

    public synchronized BuildHttpClient getBuildHttpClient() {
        URI collectionUri = this.getCollectionURI();
        if (collectionUri != null) {
            BuildHttpClient buildClient = new BuildHttpClient(this.getClient(), collectionUri);
            return buildClient;
        }
        return null;
    }

    public synchronized TfvcHttpClientEx getTfvcHttpClient() {
        URI collectionUri = this.getCollectionURI();
        if (collectionUri != null) {
            TfvcHttpClientEx tfvcHttpClient = new TfvcHttpClientEx(this.getClient(), collectionUri);
            return tfvcHttpClient;
        }
        return null;
    }

    public synchronized SoapServices getSoapServices() {
        this.checkDisposed();
        if (this.soapServices == null) {
            this.soapServices = new SoapServicesImpl(this);
        }
        return this.soapServices;
    }

    public TeamProjectCollectionReference getTeamProjectCollectionReference() {
        return this.teamProjectCollectionReference;
    }

    public TeamProjectReference getTeamProjectReference() {
        return this.teamProjectReference;
    }

    public GitRepository getGitRepository() {
        return this.gitRepository;
    }

    public URI getCollectionURI() {
        if (this.teamProjectCollectionReference != null) {
            URI collectionURI = UrlHelper.getCollectionURI((URI)this.serverUri, (String)this.teamProjectCollectionReference.getName());
            return collectionURI;
        }
        return null;
    }

    public URI getTeamProjectURI() {
        if (this.teamProjectCollectionReference != null && this.teamProjectReference != null) {
            URI teamProjectURI = UrlHelper.getTeamProjectURI((URI)this.serverUri, (String)this.teamProjectCollectionReference.getName(), (String)this.teamProjectReference.getName());
            return teamProjectURI;
        }
        return null;
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            throw new RuntimeException(this.getClass().getName() + " disposed.");
        }
    }

    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.httpClient = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        this.disposed = true;
    }

    public static enum Type {
        VSO_DEPLOYMENT,
        VSO,
        TFS;

    }
}

