/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.context;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.core.webapi.CoreHttpClient;
import com.microsoft.alm.core.webapi.model.TeamProjectCollection;
import com.microsoft.alm.core.webapi.model.TeamProjectCollectionReference;
import com.microsoft.alm.core.webapi.model.TeamProjectReference;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.authentication.TfsAuthenticationProvider;
import com.microsoft.alm.plugin.authentication.VsoAuthenticationProvider;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.context.rest.ConnectionData;
import com.microsoft.alm.plugin.context.rest.ServiceDefinition;
import com.microsoft.alm.plugin.context.rest.VstsHttpClient;
import com.microsoft.alm.plugin.context.rest.VstsInfo;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import com.microsoft.alm.plugin.services.ServerContextStore;
import com.microsoft.alm.sourcecontrol.webapi.GitHttpClient;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRepository;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.client.Client;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContextManager {
    private static final Logger logger = LoggerFactory.getLogger(ServerContextManager.class);
    private final String CONNECTION_DATA_REST_API_PATH = "/_apis/connectionData?connectOptions=IncludeServices&lastChangeId=-1&lastChangeId64=-1&api-version=1.0";
    private final String TFS2015_NEW_SERVICE = "distributedtask";
    private Map<String, ServerContext> contextMap = new HashMap<String, ServerContext>();

    protected ServerContextManager() {
        this(false);
    }

    private ServerContextManager(boolean restore) {
        if (!restore) {
            return;
        }
        try {
            this.restoreFromSavedState();
        }
        catch (Throwable t) {
            logger.error("constructor", t);
        }
    }

    public static ServerContextManager getInstance() {
        return Holder.INSTANCE;
    }

    public synchronized ServerContext getLastUsedContext() {
        ServerContext context = this.get(this.getLastUsedContextKey());
        return context;
    }

    private void setLastUsedContextKey(String key) {
        PluginServiceProvider.getInstance().getPropertyService().setProperty("lastContextKey", key);
    }

    private String getLastUsedContextKey() {
        return PluginServiceProvider.getInstance().getPropertyService().getProperty("lastContextKey");
    }

    public synchronized void clearLastUsedContext() {
        this.setLastUsedContextKey(null);
    }

    public synchronized boolean lastUsedContextIsEmpty() {
        ServerContext lastUsed = this.getLastUsedContext();
        return lastUsed == null;
    }

    public synchronized boolean lastUsedContextIsTFS() {
        ServerContext lastUsed = this.getLastUsedContext();
        return lastUsed != null && lastUsed.getType() == ServerContext.Type.TFS;
    }

    public synchronized void add(ServerContext context) {
        this.add(context, true);
    }

    public synchronized void add(ServerContext context, boolean updateLastUsedContext) {
        if (context != null) {
            String key = context.getKey();
            this.contextMap.put(key, context);
            if (this.shouldBeSaved(context)) {
                this.getStore().saveServerContext(context);
            }
            if (updateLastUsedContext) {
                this.setLastUsedContextKey(key);
            }
        }
    }

    private boolean shouldBeSaved(ServerContext context) {
        boolean shouldBeSaved;
        boolean bl = shouldBeSaved = context != null;
        if (shouldBeSaved && context.getAuthenticationInfo() != null && AuthenticationInfo.CredsType.AccessToken.equals((Object)context.getAuthenticationInfo().getType())) {
            shouldBeSaved = false;
        }
        return shouldBeSaved;
    }

    public synchronized ServerContext get(String uri) {
        if (!StringUtils.isEmpty((String)uri)) {
            ServerContext context = this.contextMap.get(ServerContext.getKey(uri));
            return context;
        }
        return null;
    }

    public synchronized void remove(String serverUri) {
        if (StringUtils.isEmpty((String)serverUri)) {
            return;
        }
        String key = ServerContext.getKey(serverUri);
        ServerContext context = this.get(key);
        if (context != null) {
            this.getStore().forgetServerContext(key);
            this.contextMap.remove(key);
            if (StringUtils.equalsIgnoreCase((String)key, (String)this.getLastUsedContextKey())) {
                this.clearLastUsedContext();
            }
        }
    }

    public synchronized Collection<ServerContext> getAllServerContexts() {
        return Collections.unmodifiableCollection(new ArrayList<ServerContext>(this.contextMap.values()));
    }

    private ServerContextStore getStore() {
        return PluginServiceProvider.getInstance().getServerContextStore();
    }

    private synchronized void restoreFromSavedState() {
        List<ServerContext> contexts = this.getStore().restoreServerContexts();
        for (ServerContext sc : contexts) {
            this.add(sc, false);
        }
    }

    public ServerContext validateServerConnection(ServerContext context) {
        Validator validator = new Validator(context);
        return this.validateServerConnection(context, validator);
    }

    protected ServerContext validateServerConnection(ServerContext context, Validator validator) {
        ServerContext contextToValidate = context;
        if (UrlHelper.isGitRemoteUrl((String)context.getUri().toString())) {
            if (context.getServerUri() == null || context.getTeamProjectCollectionReference() == null || context.getGitRepository() == null) {
                contextToValidate = validator.validateGitUrl(context.getUri().toString()) ? new ServerContextBuilder(context).serverUri(validator.getServerUrl()).collection((TeamProjectCollectionReference)validator.getCollection()).repository(validator.getRepository()).build() : null;
            }
        } else if (context.getTeamProjectReference() != null) {
            String collectionName;
            String string = collectionName = context.getTeamProjectCollectionReference() == null ? "" : context.getTeamProjectCollectionReference().getName();
            if (validator.validateTfvcUrl(context.getUri().toString(), context.getTeamProjectReference().getName(), collectionName)) {
                contextToValidate = new ServerContextBuilder(context).serverUri(validator.getServerUrl()).collection((TeamProjectCollectionReference)validator.getCollection()).teamProject(validator.getProject()).build();
            }
        }
        if (context.getType() == ServerContext.Type.TFS) {
            return this.checkTfsVersionAndConnection(contextToValidate);
        }
        return this.checkVstsConnection(contextToValidate);
    }

    private ServerContext checkVstsConnection(ServerContext context) throws TeamServicesException {
        String CONNECTION_DATA_REST_API_PATH = "/_apis/connectionData?connectOptions=lastChangeId=-1&lastChangeId64=-1&api-version=1.0";
        if (context == null || context.getServerUri() == null) {
            throw new TeamServicesException(TeamServicesException.KEY_VSO_AUTH_FAILED);
        }
        ConnectionData data = VstsHttpClient.sendRequest(context.getClient(), context.getServerUri().toString().concat("/_apis/connectionData?connectOptions=lastChangeId=-1&lastChangeId64=-1&api-version=1.0"), ConnectionData.class);
        if (data == null || data.getAuthenticatedUser() == null) {
            throw new TeamServicesException(TeamServicesException.KEY_VSO_AUTH_FAILED);
        }
        ServerContext contextWithUserId = new ServerContextBuilder(context).userId(data.getAuthenticatedUser().getId()).build();
        this.add(contextWithUserId);
        return contextWithUserId;
    }

    private ServerContext checkTfsVersionAndConnection(ServerContext context) throws TeamServicesException {
        if (context == null || context.getServerUri() == null) {
            throw new TeamServicesException(TeamServicesException.KEY_TFS_AUTH_FAILED);
        }
        try {
            String urlForConnectionData = context.getCollectionURI() != null ? context.getCollectionURI().toString() : context.getServerUri().toString();
            ConnectionData data = VstsHttpClient.sendRequest(context.getClient(), urlForConnectionData.concat("/_apis/connectionData?connectOptions=IncludeServices&lastChangeId=-1&lastChangeId64=-1&api-version=1.0"), ConnectionData.class);
            if (data == null || data.getAuthenticatedUser() == null) {
                throw new TeamServicesException(TeamServicesException.KEY_TFS_AUTH_FAILED);
            }
            if (data.getLocationServiceData() != null && data.getLocationServiceData().getServiceDefinitions() != null) {
                for (ServiceDefinition s : data.getLocationServiceData().getServiceDefinitions()) {
                    if (!StringUtils.equalsIgnoreCase((String)s.getServiceType(), (String)"distributedtask")) continue;
                    ServerContext contextWithUserId = new ServerContextBuilder(context).userId(data.getAuthenticatedUser().getId()).build();
                    this.add(contextWithUserId);
                    ServerContext lastUsedTfsContext = new ServerContextBuilder(contextWithUserId).uri("http://_TFS_LAST_USED_URL_").build();
                    this.add(lastUsedTfsContext);
                    return contextWithUserId;
                }
                logger.warn("checkTfsVersionAndConnection: Detected an attempt to connect to a TFS 2013 server");
                throw new TeamServicesException(TeamServicesException.KEY_TFS_UNSUPPORTED_VERSION);
            }
        }
        catch (VstsHttpClient.VstsHttpClientException e) {
            if (e.getStatusCode() == 404) {
                logger.warn("checkTfsVersionAndConnection: 404 while trying to connect to server so either bad url or unsupported server version");
                throw new TeamServicesException(TeamServicesException.KEY_TFS_UNSUPPORTED_VERSION);
            }
            throw new RuntimeException((Throwable)((Object)e));
        }
        logger.warn("checkTfsVersionAndConnection: Didn't match TFS 2015 or later, TFS 2013 or TFS 2012 or older server check: {}", (Object)context.getUri());
        throw new TeamServicesException(TeamServicesException.KEY_TFS_AUTH_FAILED);
    }

    public ServerContext getAuthenticatedContext(String gitRemoteUrl, boolean setAsActiveContext) {
        try {
            ServerContext context = this.createContextFromGitRemoteUrl(gitRemoteUrl);
            if (context == null || setAsActiveContext) {
                // empty if block
            }
            return context;
        }
        catch (Throwable t) {
            logger.warn("getAuthenticatedContext unexpected exception", t);
            return null;
        }
    }

    public ServerContext createContextFromGitRemoteUrl(String gitRemoteUrl) {
        return this.createContextFromGitRemoteUrl(gitRemoteUrl, true);
    }

    public ServerContext createContextFromGitRemoteUrl(String gitRemoteUrl, boolean prompt) {
        AuthenticationInfo authenticationInfo;
        ArgumentHelper.checkNotEmptyString((String)gitRemoteUrl, (String)"gitRemoteUrl");
        String httpsGitRemoteUrl = UrlHelper.getHttpsGitUrlFromSshUrl((String)gitRemoteUrl);
        ServerContext context = this.get(httpsGitRemoteUrl);
        if (context == null || context.getGitRepository() == null || context.getServerUri() == null || !StringUtils.equalsIgnoreCase((String)context.getUsableGitUrl(), (String)httpsGitRemoteUrl)) {
            context = null;
        }
        if (context == null && (authenticationInfo = this.getAuthenticationInfo(httpsGitRemoteUrl, prompt)) != null) {
            ServerContext.Type type = UrlHelper.isTeamServicesUrl((String)httpsGitRemoteUrl) ? ServerContext.Type.VSO : ServerContext.Type.TFS;
            ServerContext contextToValidate = new ServerContextBuilder().type(type).uri(httpsGitRemoteUrl).authentication(authenticationInfo).build();
            try {
                context = this.validateServerConnection(contextToValidate);
            }
            catch (TeamServicesException e) {
                logger.warn("Invalid server connection was found:", (Throwable)e);
            }
        }
        if (context != null && context.getUserId() == null) {
            context = this.validateServerConnection(context);
        }
        return context;
    }

    public ServerContext createContextFromTfvcServerUrl(String tfvcServerUrl, String teamProjectName, boolean prompt) {
        ServerContext context;
        block8: {
            ArgumentHelper.checkNotEmptyString((String)tfvcServerUrl, (String)"tfvcServerUrl");
            ArgumentHelper.checkNotEmptyString((String)teamProjectName, (String)"teamProjectName");
            context = this.get(tfvcServerUrl);
            logger.info("createContextFromTfvcServerUrl context exists: " + (context != null));
            if (context == null || context.getServerUri() == null || context.getTeamProjectCollectionReference() == null || context.getTeamProjectCollectionReference().getName() == null || context.getTeamProjectReference() == null || context.getTeamProjectReference().getId() == null || !StringUtils.equalsIgnoreCase((String)context.getTeamProjectReference().getName(), (String)teamProjectName)) {
                context = null;
                logger.info("createContextFromTfvcServerUrl context fully populated: " + (context != null));
            }
            if (context == null) {
                AuthenticationInfo authenticationInfo = this.getAuthenticationInfo(tfvcServerUrl, prompt);
                if (authenticationInfo != null) {
                    ServerContext.Type type = UrlHelper.isTeamServicesUrl((String)tfvcServerUrl) ? ServerContext.Type.VSO : ServerContext.Type.TFS;
                    ServerContext contextToValidate = new ServerContextBuilder().type(type).uri(tfvcServerUrl).authentication(authenticationInfo).teamProject(teamProjectName).build();
                    logger.info("type = " + (Object)((Object)type) + ", uri = " + tfvcServerUrl + ", projectName = " + teamProjectName);
                    try {
                        context = this.validateServerConnection(contextToValidate);
                    }
                    catch (NotAuthorizedException e) {
                        logger.warn("createContextFromTfvcServerUrl: NotAuthorizedException occurred");
                        if (prompt) {
                            logger.info("createContextFromTfvcServerUrl: refreshing creds");
                            this.updateAuthenticationInfo(tfvcServerUrl);
                            AuthenticationInfo authenticationInfoRefreshed = this.getAuthenticationInfo(tfvcServerUrl, prompt);
                            ServerContext contextToValidateRefreshed = new ServerContextBuilder().type(type).uri(tfvcServerUrl).authentication(authenticationInfoRefreshed).teamProject(teamProjectName).build();
                            context = this.validateServerConnection(contextToValidateRefreshed);
                            break block8;
                        }
                        logger.info("createContextFromTfvcServerUrl: Stale creds detected but feature does not allow prompting for refresh");
                    }
                } else {
                    logger.warn("createContextFromTfvcServerUrl: authentication info returned null");
                }
            }
        }
        if (context != null && context.getUserId() == null) {
            context = this.validateServerConnection(context);
        }
        return context;
    }

    public AuthenticationInfo getBestAuthenticationInfo(String url, boolean prompt) {
        ServerContext context = this.get(url);
        AuthenticationInfo info = context != null ? context.getAuthenticationInfo() : this.getAuthenticationInfo(url, prompt);
        return info;
    }

    public AuthenticationInfo getAuthenticationInfo(String gitRemoteUrl, boolean prompt) {
        AuthenticationInfo authenticationInfo = null;
        URI remoteUri = UrlHelper.createUri((String)gitRemoteUrl);
        for (ServerContext context : this.getAllServerContexts()) {
            if (!UrlHelper.haveSameAccount((URI)remoteUri, (URI)context.getUri())) continue;
            logger.info("AuthenticatedInfo found for url " + gitRemoteUrl);
            authenticationInfo = context.getAuthenticationInfo();
            break;
        }
        if (authenticationInfo == null && prompt) {
            logger.info("Prompting for credentials");
            AuthenticationProvider authenticationProvider = this.getAuthenticationProvider(gitRemoteUrl);
            authenticationInfo = AuthHelper.getAuthenticationInfoSynchronously(authenticationProvider, gitRemoteUrl);
        }
        return authenticationInfo;
    }

    public void updateServerContextsAuthInfo(List<ServerContext> contexts) {
        logger.info("updateServerContextsAuthInfo: starting with context count: " + contexts.size() + ", contextMap size: " + this.contextMap.size());
        HashMap<AuthenticationInfo, AuthenticationInfo> authInfoMap = new HashMap<AuthenticationInfo, AuthenticationInfo>(contexts.size());
        for (ServerContext context : contexts) {
            authInfoMap.put(context.getAuthenticationInfo(), this.getNewAuthInfo(context));
        }
        this.refreshAuthInfo(authInfoMap);
        logger.info("updateServerContextsAuthInfo: ending with contextMap size: " + this.contextMap.size());
    }

    private void refreshAuthInfo(HashMap<AuthenticationInfo, AuthenticationInfo> authInfoMap) {
        logger.info("refreshAuthInfo: refreshing auth info");
        for (ServerContext context : this.getAllServerContexts()) {
            AuthenticationInfo contextAuthInfo = context.getAuthenticationInfo();
            if (!authInfoMap.containsKey(contextAuthInfo)) continue;
            logger.info("refreshAuthInfo: Refreshing context auth info for: " + context.getKey());
            this.remove(context.getKey());
            this.add(new ServerContextBuilder(context).authentication(authInfoMap.get(contextAuthInfo)).build());
        }
    }

    private AuthenticationInfo getNewAuthInfo(ServerContext context) {
        String url;
        logger.info("Updating context auth info");
        AuthenticationProvider authenticationProvider = ServerContext.Type.TFS.equals((Object)context.getType()) ? TfsAuthenticationProvider.getInstance() : VsoAuthenticationProvider.getInstance();
        String string = url = context.getUsableGitUrl() == null ? context.getUri().toString() : context.getUsableGitUrl();
        if (StringUtils.equals((String)url, (String)"http://_TFS_LAST_USED_URL_") && context.getAuthenticationInfo() != null) {
            url = context.getAuthenticationInfo().getServerUri();
        }
        logger.info("Updating auth info with url: " + url);
        return AuthHelper.getAuthenticationInfoSynchronously(authenticationProvider, url);
    }

    public ServerContext getUpdatedContext(String remoteUrl, boolean setAsActiveContext) {
        ServerContext context = this.getAuthenticatedContext(remoteUrl, setAsActiveContext);
        if (context != null) {
            logger.info("getUpdatedContext found/created context on first attempt");
            return context;
        }
        context = this.updateAuthenticationInfo(remoteUrl);
        logger.info("getUpdatedContext updated auth info and found a context: " + (context == null ? "false" : "true"));
        return context == null ? this.getAuthenticatedContext(remoteUrl, setAsActiveContext) : context;
    }

    public ServerContext updateAuthenticationInfo(String remoteUrl) {
        logger.info("Updating auth info for url " + remoteUrl);
        AuthenticationInfo newAuthenticationInfo = null;
        boolean promptUser = true;
        URI remoteUri = UrlHelper.createUri((String)remoteUrl);
        ServerContext matchingContext = null;
        for (ServerContext context : this.getAllServerContexts()) {
            logger.info("auth info updateAuthenticationInfo compare " + context.getUri().getPath());
            if (!UrlHelper.haveSameAccount((URI)remoteUri, (URI)context.getUri())) continue;
            this.remove(context.getKey());
            logger.info("auth info updateAuthenticationInfo removed");
            if (promptUser) {
                logger.info("auth info updateAuthenticationInfo prompting");
                AuthenticationProvider authenticationProvider = this.getAuthenticationProvider(remoteUrl);
                authenticationProvider.clearAuthenticationDetails(context.getServerUri().toString());
                newAuthenticationInfo = AuthHelper.getAuthenticationInfoSynchronously(authenticationProvider, remoteUrl);
                promptUser = false;
            }
            if (newAuthenticationInfo == null) continue;
            logger.info("auth info updateAuthenticationInfo not null");
            ServerContextBuilder builder = new ServerContextBuilder(context);
            builder.authentication(newAuthenticationInfo);
            ServerContext newContext = builder.build();
            logger.info(context.getUri().toString() + "       " + remoteUrl);
            if (StringUtils.equalsIgnoreCase((String)context.getUri().toString(), (String)remoteUrl)) {
                logger.info("The updated auth info created a context that matches the remote url");
                this.add(newContext, true);
                matchingContext = newContext;
                continue;
            }
            logger.info("The updated auth info created a context that has a different remote url");
            this.add(newContext, false);
        }
        logger.info("auth info updateAuthenticationInfo returning an updated context: " + (matchingContext == null ? "false" : "true"));
        return matchingContext;
    }

    public AuthenticationProvider getAuthenticationProvider(String url) {
        if (UrlHelper.isTeamServicesUrl((String)url)) {
            return VsoAuthenticationProvider.getInstance();
        }
        return TfsAuthenticationProvider.getInstance();
    }

    protected static class Validator
    implements UrlHelper.ParseResultValidator {
        private static final String TFVC_BRANCHES_URL_PATH = "/_apis/tfvc/branches";
        private static final String REPO_INFO_URL_PATH = "/vsts/info";
        private String serverUrl;
        private final ServerContext context;
        private GitRepository repository;
        private TeamProjectCollection collection;
        private TeamProjectReference project;

        public Validator(ServerContext context) {
            this.context = context;
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public GitRepository getRepository() {
            return this.repository;
        }

        public TeamProjectCollection getCollection() {
            return this.collection;
        }

        public TeamProjectReference getProject() {
            return this.project;
        }

        protected GitHttpClient getGitHttpClient(Client jaxrsClient, URI baseUrl) {
            return new GitHttpClient(jaxrsClient, baseUrl);
        }

        protected CoreHttpClient getCoreHttpClient(Client jaxrsClient, URI baseUrl) {
            return new CoreHttpClient(jaxrsClient, baseUrl);
        }

        protected TeamProjectCollection getCollectionFromServer(ServerContext context, String collectionName) {
            TeamProjectCollectionReference ref = context.getSoapServices().getCatalogService().getProjectCollection(collectionName);
            TeamProjectCollection collection = new TeamProjectCollection();
            collection.setId(ref.getId());
            collection.setName(ref.getName());
            collection.setUrl(ref.getUrl());
            return collection;
        }

        protected TeamProjectReference getProjectFromServer(ServerContext context, URI collectionURI, String teamProjectName) {
            CoreHttpClient client = new CoreHttpClient(context.getClient(), collectionURI);
            for (TeamProjectReference ref : client.getProjects()) {
                if (!StringUtils.equalsIgnoreCase((String)ref.getName(), (String)teamProjectName)) continue;
                return ref;
            }
            return null;
        }

        public boolean validateGitUrl(String gitRemoteUrl) {
            try {
                String gitUrlToParse = UrlHelper.isSshGitRemoteUrl((String)gitRemoteUrl) ? UrlHelper.getHttpsGitUrlFromSshUrl((String)gitRemoteUrl) : gitRemoteUrl;
                if (this.getVstsInfoForGit(gitUrlToParse)) {
                    return true;
                }
                UrlHelper.ParseResult uriParseResult = UrlHelper.tryParse((String)gitUrlToParse, (UrlHelper.ParseResultValidator)this);
                if (uriParseResult.isSuccess()) {
                    return true;
                }
            }
            catch (Throwable t) {
                logger.warn("validate: {} of git remote url failed", (Object)gitRemoteUrl);
                logger.warn("validate: unexpected exception ", t);
            }
            logger.info("validateGitUrl: failed to get VSTS repo, project and collection info");
            return false;
        }

        private boolean getVstsInfoForGit(String gitRemoteUrl) {
            try {
                VstsInfo vstsInfo = VstsHttpClient.sendRequest(this.context.getClient(), gitRemoteUrl.concat(REPO_INFO_URL_PATH), VstsInfo.class);
                if (vstsInfo == null || vstsInfo.getCollectionReference() == null || vstsInfo.getRepository() == null || vstsInfo.getRepository().getProjectReference() == null) {
                    return false;
                }
                this.serverUrl = vstsInfo.getServerUrl();
                if (UrlHelper.isOrganizationUrl((String)this.serverUrl)) {
                    this.serverUrl = this.serverUrl + "/" + UrlHelper.getAccountFromOrganization((String)vstsInfo.getRepository().getRemoteUrl());
                }
                this.collection = new TeamProjectCollection();
                this.collection.setId(vstsInfo.getCollectionReference().getId());
                this.collection.setName(vstsInfo.getCollectionReference().getName());
                this.collection.setUrl(vstsInfo.getCollectionReference().getUrl());
                this.repository = vstsInfo.getRepository();
                return true;
            }
            catch (Throwable throwable) {
                logger.warn("validate: failed for Git remote url: {}", (Object)gitRemoteUrl);
                logger.warn("validate", throwable);
                if (AuthHelper.isNotAuthorizedError(throwable)) {
                    throw new TeamServicesException(TeamServicesException.KEY_VSO_AUTH_FAILED, throwable);
                }
                return false;
            }
        }

        public boolean validateTfvcUrl(String collectionUrl, String teamProjectName, String possibleCollectionName) {
            try {
                String collectionName;
                String serverUrl;
                if (UrlHelper.isTeamServicesUrl((String)collectionUrl)) {
                    if (UrlHelper.isOrganizationUrl((String)collectionUrl)) {
                        serverUrl = collectionUrl;
                        collectionName = UrlHelper.getAccountFromOrganization((String)serverUrl);
                    } else {
                        String accountName = UrlHelper.getVSOAccountName((URI)UrlHelper.createUri((String)collectionUrl));
                        serverUrl = UrlHelper.getVSOAccountURI((String)accountName).toString();
                        collectionName = accountName;
                    }
                    if (!this.validateTfvcCollectionUrl(serverUrl)) {
                        return false;
                    }
                } else if (this.validateTfvcCollectionUrl(collectionUrl)) {
                    String[] parts = this.splitTfvcCollectionUrl(collectionUrl);
                    serverUrl = parts[0];
                    collectionName = parts[1];
                } else if (StringUtils.isNotEmpty((String)possibleCollectionName) && this.validateTfvcCollectionUrl(UrlHelper.getCollectionURI((URI)UrlHelper.createUri((String)collectionUrl), (String)possibleCollectionName).toString())) {
                    serverUrl = collectionUrl;
                    collectionName = possibleCollectionName;
                } else {
                    serverUrl = collectionUrl;
                    collectionName = "DefaultCollection";
                    if (!this.validateTfvcCollectionUrl(UrlHelper.getCollectionURI((URI)UrlHelper.createUri((String)serverUrl), (String)collectionName).toString())) {
                        return false;
                    }
                }
                this.serverUrl = serverUrl;
                if (UrlHelper.isTeamServicesUrl((String)serverUrl)) {
                    CoreHttpClient coreClient = this.getCoreHttpClient(this.context.getClient(), UrlHelper.createUri((String)serverUrl));
                    this.collection = coreClient.getProjectCollection(collectionName);
                } else {
                    ServerContext contextToValidate = new ServerContextBuilder(this.context).serverUri(serverUrl).build();
                    this.collection = this.getCollectionFromServer(contextToValidate, collectionName);
                }
                this.project = this.getProjectFromServer(this.context, UrlHelper.getCollectionURI((URI)UrlHelper.createUri((String)serverUrl), (String)collectionName), teamProjectName);
                return true;
            }
            catch (VstsHttpClient.VstsHttpClientException e) {
                logger.warn("validate: unexpected VstsHttpClientException ", (Throwable)((Object)e));
                if (e.getStatusCode() == 401) {
                    throw new NotAuthorizedException("Unauthorized user", (Object)e, new Object[0]);
                }
            }
            catch (Throwable t) {
                logger.warn("validate: {} of server url failed", (Object)collectionUrl);
                logger.warn("validate: unexpected exception ", t);
            }
            logger.info("validateTfvcUrl: failed to get collection info");
            return false;
        }

        private String[] splitTfvcCollectionUrl(String collectionUrl) {
            String[] result = new String[2];
            if (StringUtils.isEmpty((String)collectionUrl)) {
                return result;
            }
            String trimmedUrl = UrlHelper.trimTrailingSeparators((String)collectionUrl);
            int index = trimmedUrl.lastIndexOf("/");
            if (index >= 0) {
                result[0] = trimmedUrl.substring(0, index + 1);
                result[1] = trimmedUrl.substring(index + 1);
            } else {
                result[0] = collectionUrl;
                result[1] = "";
            }
            return result;
        }

        private boolean validateTfvcCollectionUrl(String collectionUrl) {
            try {
                VstsHttpClient.sendRequest(this.context.getClient(), UrlHelper.combine((String[])new String[]{collectionUrl, TFVC_BRANCHES_URL_PATH}), String.class);
                logger.info("validateTfvcCollectionUrl: validated url: " + collectionUrl);
                return true;
            }
            catch (VstsHttpClient.VstsHttpClientException e) {
                if (e.getStatusCode() == 404) {
                    logger.info("validateTfvcCollectionUrl: found 404 for url: " + collectionUrl);
                    return false;
                }
                logger.warn("validateTfvcCollectionUrl failed", (Throwable)((Object)e));
                throw e;
            }
        }

        public boolean validate(UrlHelper.ParseResult parseResult) {
            try {
                this.serverUrl = parseResult.getServerUrl();
                URI collectionUri = UrlHelper.createUri((String)parseResult.getCollectionUrl());
                GitHttpClient gitClient = this.getGitHttpClient(this.context.getClient(), collectionUri);
                this.repository = gitClient.getRepository(parseResult.getProjectName(), parseResult.getRepoName());
                URI serverUri = UrlHelper.createUri((String)parseResult.getServerUrl());
                if (UrlHelper.isTeamServicesUrl((String)parseResult.getServerUrl())) {
                    CoreHttpClient coreClient = this.getCoreHttpClient(this.context.getClient(), serverUri);
                    this.collection = coreClient.getProjectCollection(parseResult.getCollectionName());
                } else {
                    ServerContext contextToValidate = new ServerContextBuilder(this.context).serverUri(this.serverUrl).build();
                    this.collection = this.getCollectionFromServer(contextToValidate, parseResult.getCollectionName());
                }
            }
            catch (Throwable throwable) {
                logger.error("validate: failed for parseResult " + parseResult.toString());
                logger.warn("validate", throwable);
                return false;
            }
            return true;
        }
    }

    private static class Holder {
        private static final ServerContextManager INSTANCE = new ServerContextManager(true);

        private Holder() {
        }
    }
}

