/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.events;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.events.ServerEvent;
import com.microsoft.alm.plugin.events.ServerEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEventManager {
    private static final Logger logger = LoggerFactory.getLogger(ServerEventManager.class);
    private final List<ServerEventListener> listeners = new ArrayList<ServerEventListener>(5);

    public static ServerEventManager getInstance() {
        return Holder.INSTANCE;
    }

    protected ServerEventManager() {
        logger.info("ServerEventManager created");
    }

    protected int getListenerCount() {
        return this.listeners.size();
    }

    public void triggerAllEvents(Map<String, Object> contextMap) {
        logger.info("triggering ALL events");
        this.triggerEvent(ServerEvent.BUILDS_CHANGED, contextMap);
        this.triggerEvent(ServerEvent.PULL_REQUESTS_CHANGED, contextMap);
        this.triggerEvent(ServerEvent.WORK_ITEMS_CHANGED, contextMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerEvent(ServerEvent event, Map<String, Object> contextMap) {
        ServerEventListener[] localListeners;
        ArgumentHelper.checkNotNull((Object)((Object)event), (String)"event");
        logger.info("triggering event: " + event.name());
        List<ServerEventListener> list = this.listeners;
        synchronized (list) {
            localListeners = this.listeners.toArray(new ServerEventListener[this.listeners.size()]);
        }
        for (int i = localListeners.length - 1; i >= 0; --i) {
            HashMap<String, Object> localContext = contextMap != null ? new HashMap<String, Object>(contextMap) : new HashMap();
            localListeners[i].serverChanged(event, localContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ServerEventListener listener) {
        logger.info("listener added");
        List<ServerEventListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ServerEventListener listener) {
        logger.info("remove listener called");
        List<ServerEventListener> list = this.listeners;
        synchronized (list) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                if (this.listeners.get(i) != listener) continue;
                this.listeners.remove(i);
                break;
            }
        }
    }

    private static class Holder {
        private static final ServerEventManager INSTANCE = new ServerEventManager();

        private Holder() {
        }
    }
}

