/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLabelCommand
extends Command<String> {
    public static final Logger logger = LoggerFactory.getLogger(CreateLabelCommand.class);
    public static final String LABEL_CREATED = "CREATED";
    public static final String LABEL_UPDATED = "UPDATED";
    private static final String CREATED_LABEL_PREFIX = "Created label ";
    private static final String UPDATED_LABEL_PREFIX = "Updated label ";
    private final String workingFolder;
    private final String name;
    private final String comment;
    private final boolean recursive;
    private final List<String> itemSpecs;

    public CreateLabelCommand(ServerContext context, String workingFolder, String name, String comment, boolean recursive, List<String> itemSpecs) {
        super("label", context);
        ArgumentHelper.checkNotEmptyString((String)workingFolder, (String)"workingFolder");
        ArgumentHelper.checkNotEmptyString((String)name, (String)"name");
        ArgumentHelper.checkNotNullOrEmpty(itemSpecs, (String)"itemSpecs");
        this.workingFolder = workingFolder;
        this.name = name;
        this.comment = comment;
        this.recursive = recursive;
        this.itemSpecs = itemSpecs;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().setWorkingDirectory(this.workingFolder).add(this.name);
        if (this.recursive) {
            builder.addSwitch("recursive");
        }
        if (StringUtils.isNotEmpty((String)this.comment)) {
            builder.addSwitch("comment", this.comment);
        }
        for (String item : this.itemSpecs) {
            builder.add(item);
        }
        return builder;
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        this.throwIfError(stderr);
        int prefixIndex = StringUtils.indexOf((String)stdout, (String)CREATED_LABEL_PREFIX);
        if (prefixIndex >= 0) {
            return LABEL_CREATED;
        }
        prefixIndex = StringUtils.indexOf((String)stdout, (String)UPDATED_LABEL_PREFIX);
        if (prefixIndex >= 0) {
            return LABEL_UPDATED;
        }
        throw new RuntimeException("Unable to parse output: " + stdout);
    }
}

