/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.Conflict;
import com.microsoft.alm.plugin.external.models.ConflictResults;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class FindConflictsCommand
extends Command<ConflictResults> {
    public static final String WARNING_PREFIX = "Warning";
    public static final String BOTH_CONFLICTS_SUFFIX = "The item name and content have changed";
    public static final String RENAME_CONFLICT_SUFFIX = "The item name has changed";
    public static final String MERGE_CONFLICT_SUFFIX = "The source and target both have changes";
    public static final String DELETE_CONFLICT_SUFFIX = "The item has already been deleted";
    public static final String MERGE_DELETE_SOURCE_CONFLICT_SUFFIX = "The item has been deleted in the source branch";
    public static final String MERGE_DELETE_TARGET_CONFLICT_SUFFIX = "The item has been deleted in the target branch";
    private final String basePath;
    private final String workingFolder;

    public FindConflictsCommand(ServerContext context, String basePath) {
        this(context, null, basePath);
    }

    public FindConflictsCommand(ServerContext context, String workingFolder, String basePath) {
        super("resolve", context);
        ArgumentHelper.checkNotNull((Object)basePath, (String)"basePath");
        this.basePath = basePath;
        this.workingFolder = workingFolder;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().setWorkingDirectory(this.workingFolder);
        builder.add(this.basePath);
        builder.addSwitch("recursive");
        builder.addSwitch("preview");
        return builder;
    }

    @Override
    public ConflictResults parseOutput(String stdout, String stderr) {
        String[] lines;
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        for (String line : lines = this.getLines(stderr)) {
            int index = line.lastIndexOf(":");
            if (index == -1) continue;
            String localPath = line.substring(0, index);
            if (StringUtils.endsWith((String)line, (String)BOTH_CONFLICTS_SUFFIX)) {
                conflicts.add(this.createNameAndContentConflict(localPath));
                continue;
            }
            if (StringUtils.endsWith((String)line, (String)RENAME_CONFLICT_SUFFIX)) {
                conflicts.add(this.createRenameConflict(localPath));
                continue;
            }
            if (StringUtils.endsWith((String)line, (String)MERGE_CONFLICT_SUFFIX)) {
                conflicts.add(this.createMergeConflict(localPath));
                continue;
            }
            if (StringUtils.endsWith((String)line, (String)DELETE_CONFLICT_SUFFIX) || StringUtils.endsWith((String)line, (String)MERGE_DELETE_SOURCE_CONFLICT_SUFFIX)) {
                conflicts.add(this.createDeleteConflict(localPath, false));
                continue;
            }
            if (StringUtils.endsWith((String)line, (String)MERGE_DELETE_TARGET_CONFLICT_SUFFIX)) {
                conflicts.add(this.createDeleteConflict(localPath, true));
                continue;
            }
            conflicts.add(this.createContentConflict(localPath));
        }
        return new ConflictResults(conflicts);
    }

    private Conflict createRenameConflict(String localPath) {
        return new Conflict(localPath, Conflict.ConflictType.RENAME);
    }

    private Conflict createContentConflict(String localPath) {
        return new Conflict(localPath, Conflict.ConflictType.CONTENT);
    }

    private Conflict createNameAndContentConflict(String localPath) {
        return new Conflict(localPath, Conflict.ConflictType.NAME_AND_CONTENT);
    }

    private Conflict createMergeConflict(String localPath) {
        return new Conflict(localPath, Conflict.ConflictType.MERGE);
    }

    private Conflict createDeleteConflict(String localPath, boolean targetDeleted) {
        return new Conflict(localPath, targetDeleted ? Conflict.ConflictType.DELETE_TARGET : Conflict.ConflictType.DELETE);
    }

    @Override
    public int interpretReturnCode(int returnCode) {
        return returnCode == 1 ? 0 : returnCode;
    }
}

