/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.Server;
import com.microsoft.alm.plugin.external.models.Workspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GetAllWorkspacesCommand
extends Command<List<Server>> {
    private static final String COLLECTION_PREFIX = "Collection: ";
    private final AuthenticationInfo authInfo;
    private final String serverUrl;

    public GetAllWorkspacesCommand() {
        this(null);
    }

    public GetAllWorkspacesCommand(ServerContext context) {
        super("workspaces", context);
        this.authInfo = null;
        this.serverUrl = "";
    }

    public GetAllWorkspacesCommand(AuthenticationInfo authInfo, String serverUrl) {
        super("workspaces", null);
        ArgumentHelper.checkNotNull((Object)authInfo, (String)"authInfo");
        ArgumentHelper.checkNotEmptyString((String)serverUrl, (String)"serverUrl");
        this.authInfo = authInfo;
        this.serverUrl = serverUrl;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        if (this.authInfo != null && StringUtils.isNotEmpty((String)this.serverUrl)) {
            builder.addAuthInfo(this.authInfo);
            builder.addSwitch("collection", this.serverUrl);
        }
        return builder;
    }

    @Override
    public List<Server> parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        String[] output = this.getLines(stdout);
        ArrayList<Server> servers = new ArrayList<Server>();
        for (int count = 0; count < output.length; ++count) {
            if (!StringUtils.startsWith((String)output[count], (String)COLLECTION_PREFIX)) continue;
            ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
            String serverName = StringUtils.removeStart((String)output[count], (String)COLLECTION_PREFIX);
            if ((count += 2) >= output.length) break;
            String[] dashes = StringUtils.split((String)output[count], (String)" ");
            int lastIndexName = dashes.length > 0 ? dashes[0].length() : 0;
            int lastIndexOwner = dashes.length > 1 ? lastIndexName + dashes[1].length() + 1 : 0;
            int lastIndexComputer = dashes.length > 2 ? lastIndexOwner + dashes[2].length() + 1 : 0;
            ++count;
            while (count < output.length && !StringUtils.isEmpty((String)output[count])) {
                Workspace workspace = new Workspace(serverName, StringUtils.substring((String)output[count], (int)0, (int)lastIndexName).trim(), StringUtils.substring((String)output[count], (int)lastIndexOwner, (int)lastIndexComputer).trim(), StringUtils.substring((String)output[count], (int)lastIndexName, (int)lastIndexOwner).trim(), StringUtils.substring((String)output[count], (int)lastIndexComputer).trim(), Collections.<Workspace.Mapping>emptyList());
                workspaces.add(workspace);
                ++count;
            }
            servers.add(new Server(serverName, workspaces));
        }
        return servers;
    }
}

