/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.Workspace;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class GetDetailedWorkspaceCommand
extends Command<Workspace> {
    public static final String WORKSPACE_PREFIX = "Workspace:";
    public static final String OWNER_PREFIX = "Owner:";
    public static final String COMPUTER_PREFIX = "Computer:";
    public static final String COMMENT_PREFIX = "Comment:";
    public static final String COLLECTION_PREFIX = "Collection:";
    public static final String LOCATION_PREFIX = "Location:";
    public static final String MAPPING_PREFIX = "Working folders:";
    private final String workspaceName;
    private final String collection;
    private final AuthenticationInfo authInfo;

    public GetDetailedWorkspaceCommand(String collection, String workspace, AuthenticationInfo authInfo) {
        super("workspaces", null);
        ArgumentHelper.checkNotEmptyString((String)workspace, (String)"workspace");
        ArgumentHelper.checkNotNull((Object)authInfo, (String)"authInfo");
        this.collection = collection;
        this.workspaceName = workspace;
        this.authInfo = authInfo;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        builder.addSwitch("format", "detailed");
        builder.add(this.workspaceName);
        builder.addAuthInfo(this.authInfo);
        if (StringUtils.isNotEmpty((String)this.collection)) {
            builder.addSwitch("collection", this.collection);
        }
        return builder;
    }

    @Override
    public Workspace parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        if (StringUtils.isEmpty((String)stdout)) {
            return null;
        }
        String[] output = this.getLines(stdout);
        String workspace = "";
        String owner = "";
        String computer = "";
        String comment = "";
        String location = "";
        String collection = "";
        ArrayList<Workspace.Mapping> mappings = new ArrayList<Workspace.Mapping>();
        for (int count = 0; count < output.length; ++count) {
            if (StringUtils.startsWith((String)output[count], (String)WORKSPACE_PREFIX)) {
                workspace = StringUtils.removeStart((String)output[count], (String)WORKSPACE_PREFIX).trim();
                continue;
            }
            if (StringUtils.startsWith((String)output[count], (String)OWNER_PREFIX)) {
                owner = StringUtils.removeStart((String)output[count], (String)OWNER_PREFIX).trim();
                continue;
            }
            if (StringUtils.startsWith((String)output[count], (String)COMPUTER_PREFIX)) {
                computer = StringUtils.removeStart((String)output[count], (String)COMPUTER_PREFIX).trim();
                continue;
            }
            if (StringUtils.startsWith((String)output[count], (String)COMMENT_PREFIX)) {
                comment = StringUtils.removeStart((String)output[count], (String)COMMENT_PREFIX).trim();
                continue;
            }
            if (StringUtils.startsWith((String)output[count], (String)COLLECTION_PREFIX)) {
                collection = StringUtils.removeStart((String)output[count], (String)COLLECTION_PREFIX).trim();
                continue;
            }
            if (StringUtils.startsWith((String)output[count], (String)LOCATION_PREFIX)) {
                location = StringUtils.removeStart((String)output[count], (String)LOCATION_PREFIX).trim();
                continue;
            }
            if (!StringUtils.startsWith((String)output[count], (String)MAPPING_PREFIX)) continue;
            count += 2;
            while (count < output.length && StringUtils.isNotEmpty((String)output[count])) {
                Workspace.Mapping mapping = this.getMapping(output[count]);
                if (mapping != null) {
                    mappings.add(mapping);
                }
                ++count;
            }
        }
        return new Workspace(collection, workspace, computer, owner, comment, mappings, Workspace.Location.fromString(location));
    }
}

