/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.exceptions.SyncException;
import com.microsoft.alm.plugin.external.models.SyncResults;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncCommand
extends Command<SyncResults> {
    private static final Logger logger = LoggerFactory.getLogger(SyncCommand.class);
    private static final String UP_TO_DATE_MSG = "All files up to date.";
    private static final String WARNING_PREFIX = "Warning";
    private static final String CONFLICT_MESSAGE = "you have a conflicting";
    private static final String SUMMARY_PREFIX = "---- Summary:";
    private static final String NEW_FILE_PREFIX = "Getting ";
    private static final String UPDATED_FILE_PREFIX = "Replacing ";
    private static final String DELETED_FILE_PREFIX = "Deleting ";
    private final List<String> updatePaths;
    private final boolean recursive;
    private final boolean shouldThrowBadExitCode;
    private final boolean force;

    public SyncCommand(ServerContext context, List<String> updatePaths, boolean recursive) {
        this(context, updatePaths, recursive, false);
    }

    public SyncCommand(ServerContext context, List<String> updatePaths, boolean recursive, boolean shouldThrowBadExitCode) {
        this(context, updatePaths, recursive, shouldThrowBadExitCode, false);
    }

    public SyncCommand(ServerContext context, List<String> updatePaths, boolean recursive, boolean shouldThrowBadExitCode, boolean force) {
        super("get", context);
        ArgumentHelper.checkNotNullOrEmpty(updatePaths, (String)"updatePaths");
        this.updatePaths = updatePaths;
        this.recursive = recursive;
        this.force = force;
        this.shouldThrowBadExitCode = shouldThrowBadExitCode;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        for (String file : this.updatePaths) {
            builder.add(file);
        }
        if (this.recursive) {
            builder.addSwitch("recursive");
        }
        if (this.force) {
            builder.addSwitch("force");
        }
        return builder;
    }

    @Override
    public SyncResults parseOutput(String stdout, String stderr) {
        ArrayList<String> updatedFiles = new ArrayList<String>();
        ArrayList<String> newFiles = new ArrayList<String>();
        ArrayList<String> deletedFiles = new ArrayList<String>();
        ArrayList<SyncException> exceptions = new ArrayList<SyncException>();
        if (StringUtils.contains((String)stdout, (String)UP_TO_DATE_MSG)) {
            return new SyncResults();
        }
        boolean conflictsExist = StringUtils.contains((String)stderr, (String)CONFLICT_MESSAGE);
        exceptions.addAll(this.parseException(stderr));
        String[] lines = this.getLines(stdout);
        String path = "";
        for (String line : lines) {
            if (!StringUtils.isNotEmpty((String)line) && !StringUtils.startsWith((String)line, (String)SUMMARY_PREFIX)) continue;
            if (this.isFilePath(line)) {
                path = this.getFilePath(line, "", "");
                continue;
            }
            if (StringUtils.startsWith((String)line, (String)NEW_FILE_PREFIX)) {
                newFiles.add(new File(path, line.replaceFirst(NEW_FILE_PREFIX, "")).getPath());
                continue;
            }
            if (StringUtils.startsWith((String)line, (String)UPDATED_FILE_PREFIX)) {
                updatedFiles.add(new File(path, line.replaceFirst(UPDATED_FILE_PREFIX, "")).getPath());
                continue;
            }
            if (StringUtils.startsWith((String)line, (String)DELETED_FILE_PREFIX)) {
                deletedFiles.add(new File(path, line.replaceFirst(DELETED_FILE_PREFIX, "")).getPath());
                continue;
            }
            logger.warn("Unknown response from 'tf get' command: " + line);
        }
        return new SyncResults(conflictsExist, updatedFiles, newFiles, deletedFiles, exceptions);
    }

    private List<SyncException> parseException(String stderr) {
        ArrayList<SyncException> exceptions = new ArrayList<SyncException>();
        String[] exceptionLines = this.getLines(stderr);
        for (int i = exceptionLines.length / 2; i < exceptionLines.length; ++i) {
            if (!StringUtils.isNotEmpty((String)exceptionLines[i]) || StringUtils.contains((String)exceptionLines[i], (String)CONFLICT_MESSAGE)) continue;
            SyncException exception = new SyncException(exceptionLines[i], StringUtils.startsWith((String)exceptionLines[i], (String)WARNING_PREFIX));
            exceptions.add(exception);
        }
        return exceptions;
    }

    @Override
    public int interpretReturnCode(int returnCode) {
        return returnCode == 1 ? 0 : returnCode;
    }

    @Override
    protected boolean shouldThrowBadExitCode() {
        return this.shouldThrowBadExitCode;
    }
}

