/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.VsoAuthenticationProvider;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.operations.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountLookupOperation
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(AccountLookupOperation.class);
    private static final String ACCOUNT_ENDPOINT = "/_apis/Accounts?memberid=%s&api-version=%s&properties=%s";
    private static final String TFS_API_VERSION = "5.0-preview.1";
    private static final String TFS_SERVICE_URL_PROPERTY_NAME = "Microsoft.VisualStudio.Services.Account.ServiceUrl.00025394-6065-48CA-87D9-7F5672854EF7";

    protected AccountLookupOperation() {
    }

    public AccountLookupResults castResults(Operation.Results results) {
        return (AccountLookupResults)results;
    }

    @Override
    public void doWork(Operation.Inputs inputs) {
        this.onLookupStarted();
        try {
            if (this.isCancelled()) {
                return;
            }
            ServerContext vsoDeploymentContext = ServerContextManager.getInstance().get("https://app.vssps.visualstudio.com");
            if (!VsoAuthenticationProvider.getInstance().isAuthenticated("https://app.vssps.visualstudio.com") || vsoDeploymentContext == null || vsoDeploymentContext.getType() == ServerContext.Type.TFS) {
                logger.warn("doWork unexpected server context, expected type VSO or VSO_DEPLOYMENT. Found: {}", (Object)vsoDeploymentContext);
                throw new TeamServicesException(TeamServicesException.KEY_VSO_AUTH_FAILED);
            }
            List<String> accountUris = this.getAccountUris(vsoDeploymentContext);
            AccountLookupResults results = new AccountLookupResults();
            for (String accountUri : accountUris) {
                ServerContext accountContext = new ServerContextBuilder().type(ServerContext.Type.VSO).accountUri(accountUri).authentication(VsoAuthenticationProvider.getInstance().getAuthenticationInfo("https://app.vssps.visualstudio.com")).userId(vsoDeploymentContext.getUserId()).build();
                results.serverContexts.add(accountContext);
            }
            this.onLookupResults(results);
            this.onLookupCompleted();
        }
        catch (Throwable ex) {
            if (AuthHelper.isNotAuthorizedError(ex)) {
                ServerContext context = ServerContextManager.getInstance().updateAuthenticationInfo("https://app.vssps.visualstudio.com");
                if (context == null) {
                    this.terminate(ex);
                } else {
                    this.doWork(inputs);
                }
            }
            this.terminate(ex);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        AccountLookupResults results = new AccountLookupResults();
        results.isCancelled = true;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    @Override
    protected void terminate(Throwable throwable) {
        super.terminate(throwable);
        AccountLookupResults results = new AccountLookupResults();
        results.error = throwable;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    private List<String> getAccountUris(ServerContext vsoDeploymentContext) {
        ArrayList<String> accountUris = new ArrayList<String>();
        Client accountClient = vsoDeploymentContext.getClient();
        String accountApiUrlFormat = "https://app.vssps.visualstudio.com/_apis/Accounts?memberid=%s&api-version=%s&properties=%s";
        WebTarget resourceTarget = accountClient.target(String.format("https://app.vssps.visualstudio.com/_apis/Accounts?memberid=%s&api-version=%s&properties=%s", vsoDeploymentContext.getUserId(), TFS_API_VERSION, TFS_SERVICE_URL_PROPERTY_NAME));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("charset", "UTF-8");
        Invocation invocation = resourceTarget.request(new MediaType[]{new MediaType("application", "json", parameters)}).buildGet();
        String response = (String)invocation.invoke(String.class);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = objectMapper.readTree(response);
        }
        catch (IOException e) {
            logger.error("Could not parse Account response", (Throwable)e);
            throw new TeamServicesException(TeamServicesException.KEY_VSO_AUTH_FAILED, e);
        }
        List nodes = rootNode.findValues(TFS_SERVICE_URL_PROPERTY_NAME);
        for (JsonNode node : nodes) {
            accountUris.add(StringUtils.removeEnd((String)node.path("$value").asText(), (String)"/"));
        }
        return accountUris;
    }

    public static class AccountLookupResults
    extends Operation.ResultsImpl {
        private final List<ServerContext> serverContexts = new ArrayList<ServerContext>();

        public List<ServerContext> getServerContexts() {
            return Collections.unmodifiableList(this.serverContexts);
        }
    }
}

