/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.operations;

import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.operations.OperationExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import javax.ws.rs.NotAuthorizedException;
import org.slf4j.Logger;

public abstract class Operation {
    public static final Inputs EMPTY_INPUTS = null;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final UUID id = UUID.randomUUID();
    private State state = State.NOT_STARTED;

    protected Operation() {
    }

    public UUID getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public boolean isFinished() {
        return this.state == State.COMPLETED || this.state == State.CANCELLED;
    }

    public boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void doWorkAsync(Inputs inputs) {
        OperationExecutor.getInstance().executeAsync(this, inputs);
    }

    public abstract void doWork(Inputs var1);

    public void cancel() {
        this.state = State.CANCELLED;
    }

    protected void terminate(Throwable throwable) {
        this.state = State.COMPLETED;
    }

    protected void onLookupStarted() {
        this.state = State.STARTED;
        for (Listener listener : this.listeners) {
            listener.notifyLookupStarted();
        }
    }

    protected void onLookupCompleted() {
        if (this.state != State.CANCELLED) {
            this.state = State.COMPLETED;
        }
        for (Listener listener : this.listeners) {
            listener.notifyLookupCompleted();
        }
    }

    protected void onLookupResults(Results results) {
        for (Listener listener : this.listeners) {
            listener.notifyLookupResults(results);
        }
    }

    protected static ServerContext getServerContext(final RepositoryContext repositoryContext, boolean forcePrompt, boolean allowPrompt, Logger logger) {
        ServerContext serverContext;
        logger.info(String.format("getServerContext: url=%s", repositoryContext.getUrl()));
        logger.info(String.format("getServerContext: forcePrompt=%s", forcePrompt));
        logger.info(String.format("getServerContext: allowPrompt=%s", allowPrompt));
        if (ServerContextManager.getInstance().get(repositoryContext.getUrl()) != null && forcePrompt) {
            logger.info("getServerContext: context found. updating auth info");
            ServerContextManager.getInstance().updateAuthenticationInfo(repositoryContext.getUrl());
        }
        if (repositoryContext.getType() == RepositoryContext.Type.GIT) {
            logger.info("getServerContext: creating GIT context");
            if (allowPrompt) {
                final ArrayList authenticatedContexts = new ArrayList();
                ArrayList<Future> authTasks = new ArrayList<Future>();
                try {
                    authTasks.add(OperationExecutor.getInstance().submitOperationTask(new Runnable(){

                        @Override
                        public void run() {
                            ServerContext context = ServerContextManager.getInstance().getUpdatedContext(repositoryContext.getUrl(), false);
                            if (context != null) {
                                authenticatedContexts.add(context);
                            }
                        }
                    }));
                    OperationExecutor.getInstance().wait(authTasks);
                }
                catch (Throwable t) {
                    logger.warn("getServerContext: failed to get authenticated server context", t);
                    return null;
                }
                if (authenticatedContexts == null || authenticatedContexts.size() != 1) {
                    logger.warn("getServerContext: Context not found");
                    return null;
                }
                serverContext = (ServerContext)authenticatedContexts.get(0);
            } else {
                serverContext = ServerContextManager.getInstance().createContextFromGitRemoteUrl(repositoryContext.getUrl(), allowPrompt);
            }
        } else {
            logger.info("getServerContext: creating TFVC context");
            serverContext = ServerContextManager.getInstance().createContextFromTfvcServerUrl(repositoryContext.getUrl(), repositoryContext.getTeamProjectName(), allowPrompt);
        }
        if (serverContext == null) {
            logger.warn("getServerContext: failed to get authenticated server context");
            throw new NotAuthorizedException((Object)repositoryContext.getUrl(), new Object[0]);
        }
        return serverContext;
    }

    public static class CredInputsImpl
    implements Inputs {
        protected boolean promptForCreds = true;

        public void setPromptForCreds(boolean promptForCreds) {
            this.promptForCreds = promptForCreds;
        }

        public boolean getPromptForCreds() {
            return this.promptForCreds;
        }
    }

    public static interface Inputs {
    }

    public static class ResultsImpl
    implements Results {
        protected boolean isCancelled = false;
        protected Throwable error = null;

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public boolean hasError() {
            return this.error != null;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }
    }

    public static interface Results {
        public Throwable getError();

        public boolean hasError();

        public boolean isCancelled();
    }

    public static interface Listener {
        public void notifyLookupStarted();

        public void notifyLookupCompleted();

        public void notifyLookupResults(Results var1);
    }

    public static enum State {
        NOT_STARTED,
        STARTED,
        CANCELLED,
        COMPLETED;

    }
}

