/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.operations;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.workitemtracking.webapi.WorkItemTrackingHttpClient;
import com.microsoft.alm.workitemtracking.webapi.models.Wiql;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItem;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemExpand;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemQueryResult;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItemReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemLookupOperation
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(WorkItemLookupOperation.class);
    public static final int MAX_WORK_ITEM_COUNT = 200;
    private final RepositoryContext repositoryContext;

    public WorkItemLookupOperation(RepositoryContext repositoryContext) {
        logger.info("WorkItemLookupOperation created.");
        ArgumentHelper.checkNotNull((Object)repositoryContext, (String)"repositoryContext");
        this.repositoryContext = repositoryContext;
    }

    @Override
    public void doWork(Operation.Inputs inputs) {
        try {
            logger.info("WorkItemLookupOperation.doWork()");
            ArgumentHelper.checkNotNull((Object)inputs, (String)"inputs");
            this.onLookupStarted();
            boolean allowPrompt = ((Operation.CredInputsImpl)inputs).getPromptForCreds();
            ServerContext latestServerContext = Operation.getServerContext(this.repositoryContext, false, allowPrompt, logger);
            this.onLookupResults(new WitResults(latestServerContext, new ArrayList<WorkItem>()));
            this.doLookup(latestServerContext, (WitInputs)inputs);
            this.onLookupCompleted();
        }
        catch (Throwable t) {
            logger.warn("doWork: failed with an exception", t);
            this.terminate(t);
        }
    }

    protected void doLookup(ServerContext context, WitInputs witInputs) {
        WorkItemTrackingHttpClient witHttpClient = context.getWitHttpClient();
        Wiql wiql = new Wiql();
        wiql.setQuery(witInputs.query);
        logger.debug("WorkItemLookupOperation.doLookup() wiql " + wiql.getQuery());
        WorkItemQueryResult result = witHttpClient.queryByWiql(wiql, context.getTeamProjectReference().getId());
        int count = 0;
        List itemRefs = result.getWorkItems();
        int maxCount = Math.min(itemRefs.size(), 200);
        logger.info("WorkItemLookupOperation.doLookup() found " + maxCount);
        if (maxCount == 0) {
            return;
        }
        IDList ids = new IDList(maxCount);
        final HashMap<Integer, Integer> workItemOrderMap = new HashMap<Integer, Integer>(maxCount);
        for (WorkItemReference itemRef : itemRefs) {
            ids.add(itemRef.getId());
            workItemOrderMap.put(itemRef.getId(), count);
            if (++count < 200) continue;
            break;
        }
        List items = witHttpClient.getWorkItems((List)ids, (List)witInputs.fields, null, witInputs.expand);
        logger.debug("doLookup: Found {} work items on repo {}", (Object)items.size(), (Object)this.repositoryContext.getUrl());
        Collections.sort(items, new Comparator<WorkItem>(){

            @Override
            public int compare(WorkItem wi1, WorkItem wi2) {
                Integer index1 = (Integer)workItemOrderMap.get(wi1.getId());
                Integer index2 = (Integer)workItemOrderMap.get(wi2.getId());
                if (index1 != null && index2 != null) {
                    return index1 - index2;
                }
                if (index1 != null) {
                    return -1;
                }
                if (index2 != null) {
                    return 1;
                }
                return 0;
            }
        });
        super.onLookupResults(new WitResults(context, items));
    }

    @Override
    protected void terminate(Throwable t) {
        super.terminate(t);
        WitResults results = new WitResults(null, new ArrayList<WorkItem>());
        results.error = t;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    protected static class FieldList
    extends ArrayList<String> {
        protected FieldList() {
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append((String)this.get(i));
            }
            return sb.toString();
        }
    }

    protected static class IDList
    extends ArrayList<Integer> {
        public IDList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(this.get(i));
            }
            return sb.toString();
        }
    }

    public class WitResults
    extends Operation.ResultsImpl {
        private final List<WorkItem> workItems;
        private final ServerContext context;

        public WitResults(ServerContext context, List<WorkItem> workItems) {
            assert (workItems != null);
            this.workItems = workItems;
            this.context = context;
        }

        public boolean maxItemsReached() {
            return this.workItems.size() >= 200;
        }

        public List<WorkItem> getWorkItems() {
            return Collections.unmodifiableList(this.workItems);
        }

        public ServerContext getContext() {
            return this.context;
        }
    }

    public static class WitInputs
    extends Operation.CredInputsImpl {
        private final String query;
        private final FieldList fields;
        private final WorkItemExpand expand;

        public WitInputs(String query, List<String> fields) {
            ArgumentHelper.checkNotNull((Object)query, (String)"query");
            ArgumentHelper.checkNotNull(fields, (String)"fields");
            this.query = query;
            this.fields = new FieldList();
            this.fields.addAll(fields);
            this.expand = WorkItemExpand.NONE;
        }

        public WitInputs(String query) {
            ArgumentHelper.checkNotNull((Object)query, (String)"query");
            this.query = query;
            this.fields = null;
            this.expand = WorkItemExpand.ALL;
        }

        public String getQuery() {
            return this.query;
        }
    }
}

