/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.operations;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.workitemtracking.webapi.WorkItemTrackingHttpClient;
import com.microsoft.alm.workitemtracking.webapi.models.QueryExpand;
import com.microsoft.alm.workitemtracking.webapi.models.QueryHierarchyItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemQueriesLookupOperation
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(WorkItemQueriesLookupOperation.class);
    private final RepositoryContext repositoryContext;

    public WorkItemQueriesLookupOperation(RepositoryContext repositoryContext) {
        logger.info("WorkItemQueriesLookupOperation created");
        ArgumentHelper.checkNotNull((Object)repositoryContext, (String)"repositoryContext");
        this.repositoryContext = repositoryContext;
    }

    @Override
    public void doWork(Operation.Inputs inputs) {
        try {
            logger.info("WorkItemQueriesLookupOperation.doWork()");
            ArgumentHelper.checkNotNull((Object)inputs, (String)"inputs");
            this.onLookupStarted();
            ServerContext context = Operation.getServerContext(this.repositoryContext, false, false, logger);
            this.doLookup(context, (QueryInputs)inputs);
            this.onLookupCompleted();
        }
        catch (Throwable t) {
            logger.warn("doWork: failed with an exception", t);
            this.terminate(t);
        }
    }

    protected void doLookup(ServerContext context, QueryInputs inputs) {
        logger.info("WorkItemQueriesLookupOperation.doLookup()");
        try {
            WorkItemTrackingHttpClient witHttpClient = context.getWitHttpClient();
            List rootDirectories = witHttpClient.getQueries(context.getTeamProjectReference().getId(), QueryExpand.WIQL, Integer.valueOf(1), Boolean.valueOf(false));
            ArrayList<QueryHierarchyItem> queries = new ArrayList<QueryHierarchyItem>();
            for (QueryHierarchyItem directory : rootDirectories) {
                if (inputs.directory == QueryRootDirectories.MY_QUERIES && directory.isFolder() && !directory.isPublic() && directory.getHasChildren()) {
                    queries.addAll(directory.getChildren());
                    continue;
                }
                if (inputs.directory != QueryRootDirectories.SHARED_QUERIES || !directory.isFolder() || !directory.isPublic() || !directory.getHasChildren()) continue;
                queries.addAll(directory.getChildren());
            }
            super.onLookupResults(new QueryResults(queries, inputs));
        }
        catch (Throwable t) {
            logger.warn("doLookup: failed with an exception", t);
            this.terminate(t);
        }
    }

    @Override
    protected void terminate(Throwable t) {
        super.terminate(t);
        QueryResults results = new QueryResults(new ArrayList<QueryHierarchyItem>(), null);
        results.error = t;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    public class QueryResults
    extends Operation.ResultsImpl {
        private final List<QueryHierarchyItem> queries;
        private final QueryInputs inputs;

        public QueryResults(List<QueryHierarchyItem> queries, QueryInputs inputs) {
            this.queries = queries;
            this.inputs = inputs;
        }

        public List<QueryHierarchyItem> getQueries() {
            return Collections.unmodifiableList(this.queries);
        }

        public QueryInputs getInputs() {
            return this.inputs;
        }
    }

    public static class QueryInputs
    implements Operation.Inputs {
        private final QueryRootDirectories directory;

        public QueryInputs(QueryRootDirectories directory) {
            this.directory = directory;
        }
    }

    public static enum QueryRootDirectories {
        MY_QUERIES,
        SHARED_QUERIES;

    }
}

