/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.versioncontrol.path;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.FileHelper;
import com.microsoft.alm.plugin.versioncontrol.path.ServerPath;
import java.io.File;

public abstract class LocalPath {
    public static final char TFS_PREFERRED_LOCAL_PATH_SEPARATOR = '\\';
    public static final String GENERAL_LOCAL_PATH_SEPARATOR = "/";

    public static final boolean isChild(String parentPath, String possibleChild) {
        ArgumentHelper.checkNotNull((Object)parentPath, (String)"parentPath");
        ArgumentHelper.checkNotNull((Object)possibleChild, (String)"possibleChild");
        if (FileHelper.doesFileSystemIgnoreCase() && parentPath.equalsIgnoreCase(possibleChild) || parentPath.equals(possibleChild)) {
            return true;
        }
        File parent = new File(parentPath);
        File child = new File(possibleChild);
        for (File tmp = child.getParentFile(); tmp != null; tmp = tmp.getParentFile()) {
            if (!tmp.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static final String combine(String parent, String relative) {
        ArgumentHelper.checkNotNull((Object)parent, (String)"parent");
        ArgumentHelper.checkNotNull((Object)relative, (String)"relative");
        File relativeFile = new File(relative);
        if (relativeFile.isAbsolute()) {
            return relative;
        }
        return new File(parent, relative).getAbsolutePath();
    }

    public static String makeRelative(String localPath, String relativeTo) {
        ArgumentHelper.checkNotNull((Object)localPath, (String)"localPath");
        ArgumentHelper.checkNotNull((Object)relativeTo, (String)"relativeTo");
        if (localPath.regionMatches(true, 0, relativeTo, 0, relativeTo.length())) {
            if (localPath.length() == relativeTo.length()) {
                return "";
            }
            if (relativeTo.length() > 0 && relativeTo.charAt(relativeTo.length() - 1) == File.separatorChar) {
                return localPath.substring(relativeTo.length());
            }
            if (localPath.charAt(relativeTo.length()) == File.separatorChar) {
                return localPath.substring(relativeTo.length() + 1);
            }
        }
        return localPath;
    }

    public static String makeServer(String localPath, String relativeToLocalPath, String serverRoot) {
        ArgumentHelper.checkNotNull((Object)localPath, (String)"localPath");
        ArgumentHelper.checkNotNull((Object)relativeToLocalPath, (String)"relativeToLocalPath");
        ArgumentHelper.checkNotNull((Object)serverRoot, (String)"serverRoot");
        String relativePart = LocalPath.makeRelative(localPath, relativeToLocalPath);
        StringBuilder relativeBuffer = new StringBuilder(relativePart);
        for (int k = 0; k < relativeBuffer.length(); ++k) {
            if (relativeBuffer.charAt(k) != File.separatorChar) continue;
            relativeBuffer.setCharAt(k, '/');
        }
        if (relativeBuffer.length() > 0 && relativeBuffer.charAt(0) == '/') {
            relativeBuffer.deleteCharAt(0);
        }
        return ServerPath.canonicalize(serverRoot + '/' + relativeBuffer.toString());
    }

    public static String removeTrailingSeparators(String path) {
        int index;
        ArgumentHelper.checkNotNull((Object)path, (String)"path");
        int length = path.length();
        for (index = path.length() - 1; index > 0 && path.charAt(index) == File.separatorChar; --index) {
        }
        return index < length - 1 ? path.substring(0, index + 1) : path;
    }
}

