/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.properties;

import org.gradle.internal.impldep.aQute.bnd.properties.BadLocationException;
import org.gradle.internal.impldep.aQute.bnd.properties.CopyOnWriteTextStore;
import org.gradle.internal.impldep.aQute.bnd.properties.GapTextStore;
import org.gradle.internal.impldep.aQute.bnd.properties.IDocument;
import org.gradle.internal.impldep.aQute.bnd.properties.IRegion;
import org.gradle.internal.impldep.aQute.bnd.properties.ITextStore;
import org.gradle.internal.impldep.aQute.bnd.properties.LineTracker;

public class Document
implements IDocument {
    public static final String[] DELIMITERS = new String[]{"\r", "\n", "\r\n"};
    private LineTracker lineTracker = new LineTracker();
    private ITextStore textStore = new CopyOnWriteTextStore(new GapTextStore());

    public Document(String text) {
        this.setText(text);
    }

    @Override
    public int getNumberOfLines() {
        return this.lineTracker.getNumberOfLines();
    }

    @Override
    public IRegion getLineInformation(int line) throws BadLocationException {
        return this.lineTracker.getLineInformation(line);
    }

    @Override
    public String get(int offset, int length) throws BadLocationException {
        return this.textStore.get(offset, length);
    }

    @Override
    public String getLineDelimiter(int line) throws BadLocationException {
        return this.lineTracker.getLineDelimiter(line);
    }

    @Override
    public int getLength() {
        return this.textStore.getLength();
    }

    @Override
    public void replace(int offset, int length, String text) throws BadLocationException {
        this.textStore.replace(offset, length, text);
        this.lineTracker.set(this.get());
    }

    @Override
    public char getChar(int pos) {
        return this.textStore.get(pos);
    }

    public void setText(String text) {
        this.textStore.set(text);
        this.lineTracker.set(text);
    }

    @Override
    public String get() {
        return this.textStore.get(0, this.textStore.getLength());
    }

    protected static class DelimiterInfo {
        public int delimiterIndex;
        public int delimiterLength;
        public String delimiter;

        protected DelimiterInfo() {
        }
    }
}

