/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.regions;

import org.apache.commons.logging.LogFactory;
import org.gradle.internal.impldep.com.amazonaws.AmazonClientException;
import org.gradle.internal.impldep.com.amazonaws.SdkClientException;
import org.gradle.internal.impldep.com.amazonaws.regions.AwsRegionProvider;
import org.gradle.internal.impldep.com.amazonaws.util.EC2MetadataUtils;

public class InstanceMetadataRegionProvider
extends AwsRegionProvider {
    private volatile String region;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRegion() throws SdkClientException {
        if (this.region == null) {
            InstanceMetadataRegionProvider instanceMetadataRegionProvider = this;
            synchronized (instanceMetadataRegionProvider) {
                if (this.region == null) {
                    this.region = this.tryDetectRegion();
                }
            }
        }
        return this.region;
    }

    private String tryDetectRegion() {
        try {
            return EC2MetadataUtils.getEC2InstanceRegion();
        }
        catch (AmazonClientException sce) {
            LogFactory.getLog(InstanceMetadataRegionProvider.class).debug((Object)("Ignoring failure to retrieve the region: " + sce.getMessage()));
            return null;
        }
    }
}

