/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.api.client.googleapis.auth.oauth2;

import java.io.IOException;
import java.util.Collection;
import org.gradle.internal.impldep.com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import org.gradle.internal.impldep.com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import org.gradle.internal.impldep.com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import org.gradle.internal.impldep.com.google.api.client.http.GenericUrl;
import org.gradle.internal.impldep.com.google.api.client.http.HttpExecuteInterceptor;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequestInitializer;
import org.gradle.internal.impldep.com.google.api.client.http.HttpTransport;
import org.gradle.internal.impldep.com.google.api.client.json.JsonFactory;
import org.gradle.internal.impldep.com.google.api.client.util.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleAuthorizationCodeTokenRequest
extends AuthorizationCodeTokenRequest {
    public GoogleAuthorizationCodeTokenRequest(HttpTransport transport, JsonFactory jsonFactory, String clientId, String clientSecret, String code, String redirectUri) {
        this(transport, jsonFactory, "https://accounts.google.com/o/oauth2/token", clientId, clientSecret, code, redirectUri);
    }

    public GoogleAuthorizationCodeTokenRequest(HttpTransport transport, JsonFactory jsonFactory, String tokenServerEncodedUrl, String clientId, String clientSecret, String code, String redirectUri) {
        super(transport, jsonFactory, new GenericUrl(tokenServerEncodedUrl), code);
        this.setClientAuthentication(new ClientParametersAuthentication(clientId, clientSecret));
        this.setRedirectUri(redirectUri);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setRequestInitializer(HttpRequestInitializer requestInitializer) {
        return (GoogleAuthorizationCodeTokenRequest)super.setRequestInitializer(requestInitializer);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setTokenServerUrl(GenericUrl tokenServerUrl) {
        return (GoogleAuthorizationCodeTokenRequest)super.setTokenServerUrl(tokenServerUrl);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setScopes(Collection<String> scopes) {
        return (GoogleAuthorizationCodeTokenRequest)super.setScopes((Collection)scopes);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setGrantType(String grantType) {
        return (GoogleAuthorizationCodeTokenRequest)super.setGrantType(grantType);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
        Preconditions.checkNotNull(clientAuthentication);
        return (GoogleAuthorizationCodeTokenRequest)super.setClientAuthentication(clientAuthentication);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setCode(String code) {
        return (GoogleAuthorizationCodeTokenRequest)super.setCode(code);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest setRedirectUri(String redirectUri) {
        Preconditions.checkNotNull(redirectUri);
        return (GoogleAuthorizationCodeTokenRequest)super.setRedirectUri(redirectUri);
    }

    @Override
    public GoogleTokenResponse execute() throws IOException {
        return this.executeUnparsed().parseAs(GoogleTokenResponse.class);
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest set(String fieldName, Object value) {
        return (GoogleAuthorizationCodeTokenRequest)super.set(fieldName, value);
    }
}

