/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.api.client.googleapis.testing.auth.oauth2;

import java.io.IOException;
import org.gradle.internal.impldep.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import org.gradle.internal.impldep.com.google.api.client.http.HttpExecuteInterceptor;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequest;
import org.gradle.internal.impldep.com.google.api.client.http.HttpTransport;
import org.gradle.internal.impldep.com.google.api.client.json.JsonFactory;
import org.gradle.internal.impldep.com.google.api.client.json.jackson2.JacksonFactory;
import org.gradle.internal.impldep.com.google.api.client.testing.http.MockHttpTransport;
import org.gradle.internal.impldep.com.google.api.client.testing.http.MockLowLevelHttpRequest;
import org.gradle.internal.impldep.com.google.api.client.testing.http.MockLowLevelHttpResponse;
import org.gradle.internal.impldep.com.google.api.client.util.Beta;
import org.gradle.internal.impldep.com.google.api.client.util.Clock;

@Beta
public class MockGoogleCredential
extends GoogleCredential {
    public static final String ACCESS_TOKEN = "access_xyz";
    public static final String REFRESH_TOKEN = "refresh123";
    private static final String EXPIRES_IN_SECONDS = "3600";
    private static final String TOKEN_TYPE = "Bearer";
    private static final String TOKEN_RESPONSE = "{\"access_token\": \"%s\", \"expires_in\":  %s, \"refresh_token\": \"%s\", \"token_type\": \"%s\"}";
    private static final String DEFAULT_TOKEN_RESPONSE_JSON = String.format("{\"access_token\": \"%s\", \"expires_in\":  %s, \"refresh_token\": \"%s\", \"token_type\": \"%s\"}", "access_xyz", "3600", "refresh123", "Bearer");

    public MockGoogleCredential(Builder builder) {
        super(builder);
    }

    public static MockHttpTransport newMockHttpTransportWithSampleTokenResponse() {
        MockLowLevelHttpResponse mockLowLevelHttpResponse = new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(DEFAULT_TOKEN_RESPONSE_JSON);
        MockLowLevelHttpRequest request = new MockLowLevelHttpRequest().setResponse(mockLowLevelHttpResponse);
        return new MockHttpTransport.Builder().setLowLevelHttpRequest(request).build();
    }

    @Beta
    private static class MockClientAuthentication
    implements HttpExecuteInterceptor {
        private MockClientAuthentication() {
        }

        public void intercept(HttpRequest request) throws IOException {
        }
    }

    @Beta
    public static class Builder
    extends GoogleCredential.Builder {
        public Builder setTransport(HttpTransport transport) {
            return (Builder)super.setTransport(transport);
        }

        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            return (Builder)super.setClientAuthentication(clientAuthentication);
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            return (Builder)super.setJsonFactory(jsonFactory);
        }

        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        public MockGoogleCredential build() {
            if (this.getTransport() == null) {
                this.setTransport(new MockHttpTransport.Builder().build());
            }
            if (this.getClientAuthentication() == null) {
                this.setClientAuthentication(new MockClientAuthentication());
            }
            if (this.getJsonFactory() == null) {
                this.setJsonFactory(new JacksonFactory());
            }
            return new MockGoogleCredential(this);
        }
    }
}

